/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.svtp.blocks;

import com.github.sokyranthedragon.svtp.blocks.DeadFlowerBlock;
import com.github.sokyranthedragon.svtp.blocks.GoldenTorchBlock;
import com.github.sokyranthedragon.svtp.blocks.GoldenWallTorchBlock;
import com.github.sokyranthedragon.svtp.blocks.PaperBundleBlock;
import com.github.sokyranthedragon.svtp.blocks.RedstoneLanternBlock;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Contract;

@MethodsReturnNonnullByDefault
public class SVTPBlocks {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"sokys_various_things_pack", (ResourceKey)Registries.BLOCK);
    public static final RegistrySupplier<Block> ARMORED_GLASS = SVTPBlocks.register("armored_glass", TransparentBlock::new, SVTPBlocks.armoredGlassProperties(Blocks.GLASS));
    public static final RegistrySupplier<Block> ARMORED_GLASS_PANE = SVTPBlocks.register("armored_glass_pane", IronBarsBlock::new, SVTPBlocks.armoredGlassProperties(Blocks.GLASS_PANE));
    public static final RegistrySupplier<Block> ARMORED_TINTED_GLASS = SVTPBlocks.register("armored_tinted_glass", TintedGlassBlock::new, SVTPBlocks.armoredGlassProperties(Blocks.TINTED_GLASS));
    public static final RegistrySupplier<Block> ARMORED_WHITE_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_white_stained_glass", Blocks.WHITE_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_ORANGE_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_orange_stained_glass", Blocks.ORANGE_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_MAGENTA_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_magenta_stained_glass", Blocks.MAGENTA_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_LIGHT_BLUE_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_light_blue_stained_glass", Blocks.LIGHT_BLUE_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_YELLOW_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_yellow_stained_glass", Blocks.YELLOW_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_LIME_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_lime_stained_glass", Blocks.LIME_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_PINK_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_pink_stained_glass", Blocks.PINK_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_GRAY_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_gray_stained_glass", Blocks.GRAY_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_LIGHT_GRAY_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_light_gray_stained_glass", Blocks.LIGHT_GRAY_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_CYAN_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_cyan_stained_glass", Blocks.CYAN_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_PURPLE_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_purple_stained_glass", Blocks.PURPLE_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_BLUE_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_blue_stained_glass", Blocks.BLUE_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_BROWN_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_brown_stained_glass", Blocks.BROWN_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_GREEN_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_green_stained_glass", Blocks.GREEN_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_RED_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_red_stained_glass", Blocks.RED_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_BLACK_STAINED_GLASS = SVTPBlocks.registerStainedArmoredGlass("armored_black_stained_glass", Blocks.BLACK_STAINED_GLASS);
    public static final RegistrySupplier<Block> ARMORED_WHITE_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_white_stained_glass_pane", Blocks.WHITE_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_ORANGE_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_orange_stained_glass_pane", Blocks.ORANGE_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_MAGENTA_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_magenta_stained_glass_pane", Blocks.MAGENTA_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_LIGHT_BLUE_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_light_blue_stained_glass_pane", Blocks.LIGHT_BLUE_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_YELLOW_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_yellow_stained_glass_pane", Blocks.YELLOW_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_LIME_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_lime_stained_glass_pane", Blocks.LIME_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_PINK_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_pink_stained_glass_pane", Blocks.PINK_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_GRAY_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_gray_stained_glass_pane", Blocks.GRAY_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_LIGHT_GRAY_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_light_gray_stained_glass_pane", Blocks.LIGHT_GRAY_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_CYAN_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_cyan_stained_glass_pane", Blocks.CYAN_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_PURPLE_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_purple_stained_glass_pane", Blocks.PURPLE_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_BLUE_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_blue_stained_glass_pane", Blocks.BLUE_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_BROWN_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_brown_stained_glass_pane", Blocks.BROWN_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_GREEN_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_green_stained_glass_pane", Blocks.GREEN_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_RED_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_red_stained_glass_pane", Blocks.RED_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> ARMORED_BLACK_STAINED_GLASS_PANE = SVTPBlocks.registerStainedArmoredPane("armored_black_stained_glass_pane", Blocks.BLACK_STAINED_GLASS_PANE);
    public static final RegistrySupplier<Block> STONE_DOOR = SVTPBlocks.register("stone_door", props -> new DoorBlock(BlockSetType.STONE, props), () -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(4.0f).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final RegistrySupplier<Block> GOLDEN_TORCH_0 = SVTPBlocks.register("golden_torch_0", props -> new GoldenTorchBlock(ParticleTypes.FLAME, (BlockBehaviour.Properties)props), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).lightLevel(state -> 15).sound(SoundType.METAL));
    public static final RegistrySupplier<Block> WALL_GOLDEN_TORCH_0 = SVTPBlocks.register("wall_golden_torch_0", props -> new GoldenWallTorchBlock(ParticleTypes.FLAME, (BlockBehaviour.Properties)props), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).lightLevel(state -> 15).sound(SoundType.METAL).dropsLike((Block)GOLDEN_TORCH_0.get()));
    public static final RegistrySupplier<Block> GOLDEN_TORCH_1 = SVTPBlocks.register("golden_torch_1", props -> new GoldenTorchBlock(ParticleTypes.FLAME, (BlockBehaviour.Properties)props), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).lightLevel(state -> 15).sound(SoundType.METAL));
    public static final RegistrySupplier<Block> WALL_GOLDEN_TORCH_1 = SVTPBlocks.register("wall_golden_torch_1", props -> new GoldenWallTorchBlock(ParticleTypes.FLAME, (BlockBehaviour.Properties)props), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).lightLevel(state -> 15).sound(SoundType.METAL).dropsLike((Block)GOLDEN_TORCH_1.get()));
    public static final RegistrySupplier<Block> GOLDEN_SOUL_TORCH_0 = SVTPBlocks.register("golden_soul_torch_0", props -> new GoldenTorchBlock(ParticleTypes.SOUL_FIRE_FLAME, (BlockBehaviour.Properties)props), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).lightLevel(state -> 15).sound(SoundType.METAL));
    public static final RegistrySupplier<Block> WALL_GOLDEN_SOUL_TORCH_0 = SVTPBlocks.register("wall_golden_soul_torch_0", props -> new GoldenWallTorchBlock(ParticleTypes.SOUL_FIRE_FLAME, (BlockBehaviour.Properties)props), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).lightLevel(state -> 15).sound(SoundType.METAL).dropsLike((Block)GOLDEN_SOUL_TORCH_0.get()));
    public static final RegistrySupplier<Block> GOLDEN_SOUL_TORCH_1 = SVTPBlocks.register("golden_soul_torch_1", props -> new GoldenTorchBlock(ParticleTypes.SOUL_FIRE_FLAME, (BlockBehaviour.Properties)props), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).lightLevel(state -> 15).sound(SoundType.METAL));
    public static final RegistrySupplier<Block> WALL_GOLDEN_SOUL_TORCH_1 = SVTPBlocks.register("wall_golden_soul_torch_1", props -> new GoldenWallTorchBlock(ParticleTypes.SOUL_FIRE_FLAME, (BlockBehaviour.Properties)props), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).lightLevel(state -> 15).sound(SoundType.METAL).dropsLike((Block)GOLDEN_SOUL_TORCH_1.get()));
    public static final RegistrySupplier<Block> PAPER_BUNDLE_0 = SVTPBlocks.register("paper_bundle_0", PaperBundleBlock::new, SVTPBlocks.paperProperties());
    public static final RegistrySupplier<Block> PAPER_BUNDLE_1 = SVTPBlocks.register("paper_bundle_1", PaperBundleBlock::new, SVTPBlocks.paperProperties());
    public static final RegistrySupplier<Block> PAPER_BUNDLE_2 = SVTPBlocks.register("paper_bundle_2", PaperBundleBlock::new, SVTPBlocks.paperProperties());
    public static final RegistrySupplier<Block> PAPER_BUNDLE_3 = SVTPBlocks.register("paper_bundle_3", PaperBundleBlock::new, SVTPBlocks.paperProperties());
    public static final RegistrySupplier<Block> PAPER_BUNDLE_4 = SVTPBlocks.register("paper_bundle_4", PaperBundleBlock::new, SVTPBlocks.paperProperties());
    public static final RegistrySupplier<Block> PAPER_BUNDLE_5 = SVTPBlocks.register("paper_bundle_5", PaperBundleBlock::new, SVTPBlocks.paperProperties());
    public static final RegistrySupplier<Block> REDSTONE_LANTERN = SVTPBlocks.register("redstone_lantern", RedstoneLanternBlock::new, () -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.STONE).lightLevel(state -> (Boolean)state.getValue((Property)RedstoneLanternBlock.REDSTONE_STATE) ^ (Boolean)state.getValue((Property)RedstoneLanternBlock.MANUAL_STATE) ? 15 : 0).strength(0.3f, 3.5f).isValidSpawn((state, getter, pos, type) -> true));
    public static final RegistrySupplier<Block> DEAD_FLOWER = SVTPBlocks.register("dead_flower", props -> new DeadFlowerBlock((Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 7.0f, (BlockBehaviour.Properties)props), () -> BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).replaceable().noCollission().instabreak().sound(SoundType.GRASS).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final RegistrySupplier<Block> POTTED_DEAD_FLOWER = SVTPBlocks.register("potted_dead_flower", props -> new FlowerPotBlock((Block)DEAD_FLOWER.get(), props), () -> BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY));

    public static void init() {
        BLOCKS.register();
    }

    public static void registerFlammableBlocks() {
        FireBlock fire = (FireBlock)Blocks.FIRE;
        fire.setFlammable((Block)PAPER_BUNDLE_0.get(), 30, 60);
        fire.setFlammable((Block)PAPER_BUNDLE_1.get(), 30, 60);
        fire.setFlammable((Block)PAPER_BUNDLE_2.get(), 30, 60);
        fire.setFlammable((Block)PAPER_BUNDLE_3.get(), 30, 60);
        fire.setFlammable((Block)PAPER_BUNDLE_4.get(), 30, 60);
        fire.setFlammable((Block)PAPER_BUNDLE_5.get(), 30, 60);
        fire.setFlammable((Block)DEAD_FLOWER.get(), 60, 100);
    }

    private static RegistrySupplier<Block> register(String id, Function<BlockBehaviour.Properties, Block> function, Supplier<BlockBehaviour.Properties> properties) {
        return BLOCKS.register(id, () -> (Block)function.apply((BlockBehaviour.Properties)properties.get()));
    }

    private static Supplier<BlockBehaviour.Properties> paperProperties() {
        return () -> BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).sound(SoundType.WOOL).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).ignitedByLava();
    }

    private static Supplier<BlockBehaviour.Properties> armoredGlassProperties(Block base) {
        return () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)base).strength(Blocks.OBSIDIAN.defaultDestroyTime() * 0.75f, Blocks.OBSIDIAN.getExplosionResistance());
    }

    private static RegistrySupplier<Block> registerStainedArmoredGlass(String id, Block base) {
        return SVTPBlocks.register(id, props -> new StainedGlassBlock(((StainedGlassBlock)base).getColor(), props), SVTPBlocks.armoredGlassProperties(base));
    }

    private static RegistrySupplier<Block> registerStainedArmoredPane(String id, Block base) {
        return SVTPBlocks.register(id, props -> new StainedGlassPaneBlock(((StainedGlassPaneBlock)base).getColor(), props), SVTPBlocks.armoredGlassProperties(base));
    }

    @Contract(pure=true)
    public static RegistrySupplier<Block>[] getStainedGlassBlockProviders() {
        return new RegistrySupplier[]{ARMORED_WHITE_STAINED_GLASS, ARMORED_ORANGE_STAINED_GLASS, ARMORED_MAGENTA_STAINED_GLASS, ARMORED_LIGHT_BLUE_STAINED_GLASS, ARMORED_YELLOW_STAINED_GLASS, ARMORED_LIME_STAINED_GLASS, ARMORED_PINK_STAINED_GLASS, ARMORED_GRAY_STAINED_GLASS, ARMORED_LIGHT_GRAY_STAINED_GLASS, ARMORED_CYAN_STAINED_GLASS, ARMORED_PURPLE_STAINED_GLASS, ARMORED_BLUE_STAINED_GLASS, ARMORED_BROWN_STAINED_GLASS, ARMORED_GREEN_STAINED_GLASS, ARMORED_RED_STAINED_GLASS, ARMORED_BLACK_STAINED_GLASS};
    }

    @Contract(pure=true)
    public static RegistrySupplier<Block>[] getStainedGlassPaneBlockProviders() {
        return new RegistrySupplier[]{ARMORED_WHITE_STAINED_GLASS_PANE, ARMORED_ORANGE_STAINED_GLASS_PANE, ARMORED_MAGENTA_STAINED_GLASS_PANE, ARMORED_LIGHT_BLUE_STAINED_GLASS_PANE, ARMORED_YELLOW_STAINED_GLASS_PANE, ARMORED_LIME_STAINED_GLASS_PANE, ARMORED_PINK_STAINED_GLASS_PANE, ARMORED_GRAY_STAINED_GLASS_PANE, ARMORED_LIGHT_GRAY_STAINED_GLASS_PANE, ARMORED_CYAN_STAINED_GLASS_PANE, ARMORED_PURPLE_STAINED_GLASS_PANE, ARMORED_BLUE_STAINED_GLASS_PANE, ARMORED_BROWN_STAINED_GLASS_PANE, ARMORED_GREEN_STAINED_GLASS_PANE, ARMORED_RED_STAINED_GLASS_PANE, ARMORED_BLACK_STAINED_GLASS_PANE};
    }

    @Contract(pure=true)
    public static Block[] getStainedGlassBlocks() {
        return (Block[])Arrays.stream(SVTPBlocks.getStainedGlassBlockProviders()).map(Supplier::get).toArray(Block[]::new);
    }

    @Contract(pure=true)
    public static Block[] getStainedGlassPaneBlocks() {
        return (Block[])Arrays.stream(SVTPBlocks.getStainedGlassPaneBlockProviders()).map(Supplier::get).toArray(Block[]::new);
    }
}

