/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.svtp.crafting;

import com.github.sokyranthedragon.svtp.blocks.SVTPBlocks;
import com.github.sokyranthedragon.svtp.crafting.SVTPRecipeSerializers;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SuspiciousStewRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

@MethodsReturnNonnullByDefault
public class SVTPSuspiciousStewRecipe
extends SuspiciousStewRecipe {
    public SVTPSuspiciousStewRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        boolean brownMushroom = false;
        boolean redMushroom = false;
        boolean bowl = false;
        boolean flower = false;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack stack = craftingInput.getItem(i);
            if (stack.isEmpty()) continue;
            if (!brownMushroom && stack.is(Blocks.BROWN_MUSHROOM.asItem())) {
                brownMushroom = true;
                continue;
            }
            if (!redMushroom && stack.is(Blocks.RED_MUSHROOM.asItem())) {
                redMushroom = true;
                continue;
            }
            if (!bowl && stack.is(Items.BOWL)) {
                bowl = true;
                continue;
            }
            if (!flower && stack.is(((Block)SVTPBlocks.DEAD_FLOWER.get()).asItem())) {
                flower = true;
                continue;
            }
            return false;
        }
        return redMushroom && brownMushroom && bowl && flower;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SVTPRecipeSerializers.SVTP_SUSPICIOUS_STEW.get();
    }
}

