/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.svtp.datagen.fabric;

import com.github.sokyranthedragon.svtp.blocks.RedstoneLanternBlock;
import com.github.sokyranthedragon.svtp.blocks.SVTPBlocks;
import com.github.sokyranthedragon.svtp.datagen.fabric.SVTPModelTemplates;
import com.github.sokyranthedragon.svtp.datagen.fabric.SVTPTextureMappings;
import com.github.sokyranthedragon.svtp.datagen.fabric.SVTPTexturedModels;
import dev.architectury.registry.registries.RegistrySupplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4943;
import net.minecraft.class_4944;

class SVTPModelGenerator
extends FabricModelProvider {
    public SVTPModelGenerator(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(class_4910 generator) {
        SVTPModelGenerator.createDoor(generator, SVTPBlocks.STONE_DOOR);
        SVTPModelGenerator.createRedstoneLantern(generator, SVTPBlocks.REDSTONE_LANTERN);
        this.createPlantWithDefaultItem(generator, SVTPBlocks.DEAD_FLOWER, SVTPBlocks.POTTED_DEAD_FLOWER);
        SVTPModelGenerator.createSvtpTorch(generator, SVTPBlocks.GOLDEN_TORCH_0, SVTPBlocks.WALL_GOLDEN_TORCH_0);
        SVTPModelGenerator.createSvtpTorch(generator, SVTPBlocks.GOLDEN_TORCH_1, SVTPBlocks.WALL_GOLDEN_TORCH_1);
        SVTPModelGenerator.createSvtpTorch(generator, SVTPBlocks.GOLDEN_SOUL_TORCH_0, SVTPBlocks.WALL_GOLDEN_SOUL_TORCH_0);
        SVTPModelGenerator.createSvtpTorch(generator, SVTPBlocks.GOLDEN_SOUL_TORCH_1, SVTPBlocks.WALL_GOLDEN_SOUL_TORCH_1);
        PaperModelGenerator.create(generator, SVTPBlocks.PAPER_BUNDLE_0).createModel();
        PaperModelGenerator.create(generator, SVTPBlocks.PAPER_BUNDLE_1).setTop(SVTPBlocks.PAPER_BUNDLE_0).createModel();
        PaperModelGenerator.create(generator, SVTPBlocks.PAPER_BUNDLE_2).setAll(SVTPBlocks.PAPER_BUNDLE_1).setTop(SVTPBlocks.PAPER_BUNDLE_0).setBottom(SVTPBlocks.PAPER_BUNDLE_2).createModel();
        PaperModelGenerator.create(generator, SVTPBlocks.PAPER_BUNDLE_3).createModel();
        PaperModelGenerator.create(generator, SVTPBlocks.PAPER_BUNDLE_4).setTop(SVTPBlocks.PAPER_BUNDLE_3).setBottom(SVTPBlocks.PAPER_BUNDLE_1).createModel();
        PaperModelGenerator.create(generator, SVTPBlocks.PAPER_BUNDLE_5).setAll(SVTPBlocks.PAPER_BUNDLE_4).setTop(SVTPBlocks.PAPER_BUNDLE_3).setBottom(SVTPBlocks.PAPER_BUNDLE_2).createModel();
        SVTPModelGenerator.createArmoredGlassBlocks(generator, SVTPBlocks.ARMORED_GLASS, SVTPBlocks.ARMORED_GLASS_PANE);
        generator.method_25622((class_2248)SVTPBlocks.ARMORED_TINTED_GLASS.get(), SVTPTexturedModels.CUBE_TRANSLUCENT);
        class_2248[] stainedGlassBlocks = SVTPBlocks.getStainedGlassBlocks();
        class_2248[] stainedGlassPaneBlocks = SVTPBlocks.getStainedGlassPaneBlocks();
        for (int i = 0; i < stainedGlassBlocks.length; ++i) {
            SVTPModelGenerator.createStainedArmoredGlassBlock(generator, stainedGlassBlocks[i], stainedGlassPaneBlocks[i]);
        }
    }

    public void generateItemModels(class_4915 itemModelGenerators) {
    }

    private static void createArmoredGlassBlocks(class_4910 generator, RegistrySupplier<class_2248> blockSupplier, RegistrySupplier<class_2248> paneSupplier) {
        class_2248 block = (class_2248)blockSupplier.get();
        class_2248 pane = (class_2248)paneSupplier.get();
        generator.method_25622(block, SVTPTexturedModels.CUBE_TRANSPARENT);
        class_4944 textureMapping = SVTPTextureMappings.armoredPane(block);
        class_2960 post = SVTPModelTemplates.STAINED_GLASS_PANE_POST_TRANSPARENT.method_25846(pane, textureMapping, generator.field_22831);
        class_2960 side = SVTPModelTemplates.STAINED_GLASS_PANE_SIDE_TRANSPARENT.method_25846(pane, textureMapping, generator.field_22831);
        class_2960 sideAlt = SVTPModelTemplates.STAINED_GLASS_PANE_SIDE_ALT_TRANSPARENT.method_25846(pane, textureMapping, generator.field_22831);
        class_2960 noSide = SVTPModelTemplates.STAINED_GLASS_PANE_NOSIDE_TRANSPARENT.method_25846(pane, textureMapping, generator.field_22831);
        class_2960 noSideAlt = SVTPModelTemplates.STAINED_GLASS_PANE_NOSIDE_ALT_TRANSPARENT.method_25846(pane, textureMapping, generator.field_22831);
        class_1792 item = pane.method_8389();
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_25911((class_2248)block), generator.field_22831);
        SVTPModelGenerator.generateArmoredGlassPane(generator, pane, post, side, sideAlt, noSide, noSideAlt);
    }

    private static void createStainedArmoredGlassBlock(class_4910 generator, class_2248 block, class_2248 pane) {
        generator.method_25622(block, SVTPTexturedModels.CUBE_TRANSLUCENT);
        class_4944 textureMapping = SVTPTextureMappings.armoredPane(block);
        class_2960 post = SVTPModelTemplates.STAINED_GLASS_PANE_POST_TRANSLUCENT.method_25846(pane, textureMapping, generator.field_22831);
        class_2960 side = SVTPModelTemplates.STAINED_GLASS_PANE_SIDE_TRANSLUCENT.method_25846(pane, textureMapping, generator.field_22831);
        class_2960 sideAlt = SVTPModelTemplates.STAINED_GLASS_PANE_SIDE_ALT_TRANSLUCENT.method_25846(pane, textureMapping, generator.field_22831);
        class_2960 noSide = SVTPModelTemplates.STAINED_GLASS_PANE_NOSIDE_TRANSLUCENT.method_25846(pane, textureMapping, generator.field_22831);
        class_2960 noSideAlt = SVTPModelTemplates.STAINED_GLASS_PANE_NOSIDE_ALT_TRANSLUCENT.method_25846(pane, textureMapping, generator.field_22831);
        class_1792 item = pane.method_8389();
        SVTPModelTemplates.FLAT_ITEM_TRANSLUCENT.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_25911((class_2248)block), generator.field_22831);
        SVTPModelGenerator.generateArmoredGlassPane(generator, pane, post, side, sideAlt, noSide, noSideAlt);
    }

    private static void generateArmoredGlassPane(class_4910 generator, class_2248 pane, class_2960 post, class_2960 side, class_2960 sideAlt, class_2960 noSide, class_2960 noSideAlt) {
        generator.field_22830.accept(class_4922.method_25758((class_2248)pane).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)post)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideAlt)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideAlt).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSide)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideAlt)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideAlt).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSide).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)));
    }

    private static void createDoor(class_4910 generator, RegistrySupplier<class_2248> blockSupplier) {
        class_2248 block = (class_2248)blockSupplier.get();
        class_4944 textureMapping = class_4944.method_25900((class_2248)block);
        class_2960 bottomLeft = SVTPModelTemplates.DOOR_BOTTOM_LEFT_TRANSPARENT.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottomLeftOpen = SVTPModelTemplates.DOOR_BOTTOM_LEFT_OPEN_TRANSPARENT.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottomRight = SVTPModelTemplates.DOOR_BOTTOM_RIGHT_TRANSPARENT.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottomRightOpen = SVTPModelTemplates.DOOR_BOTTOM_RIGHT_OPEN_TRANSPARENT.method_25846(block, textureMapping, generator.field_22831);
        class_2960 topLeft = SVTPModelTemplates.DOOR_TOP_LEFT_TRANSPARENT.method_25846(block, textureMapping, generator.field_22831);
        class_2960 topLeftOpen = SVTPModelTemplates.DOOR_TOP_LEFT_OPEN_TRANSPARENT.method_25846(block, textureMapping, generator.field_22831);
        class_2960 topRight = SVTPModelTemplates.DOOR_TOP_RIGHT_TRANSPARENT.method_25846(block, textureMapping, generator.field_22831);
        class_2960 topRightOpen = SVTPModelTemplates.DOOR_TOP_RIGHT_OPEN_TRANSPARENT.method_25846(block, textureMapping, generator.field_22831);
        generator.method_25537(block.method_8389());
        generator.field_22830.accept(class_4910.method_25609((class_2248)block, (class_2960)bottomLeft, (class_2960)bottomLeftOpen, (class_2960)bottomRight, (class_2960)bottomRightOpen, (class_2960)topLeft, (class_2960)topLeftOpen, (class_2960)topRight, (class_2960)topRightOpen));
    }

    private static void createSvtpTorch(class_4910 generator, RegistrySupplier<class_2248> groundTorchSupplier, RegistrySupplier<class_2248> wallTorchSupplier) {
        class_2248 groundTorch = (class_2248)groundTorchSupplier.get();
        class_2248 wallTorch = (class_2248)wallTorchSupplier.get();
        class_4944 textureMapping = SVTPTextureMappings.svtpTorch(groundTorch);
        generator.field_22830.accept(class_4910.method_25644((class_2248)groundTorch, (class_2960)SVTPModelTemplates.SVTP_TORCH_TRANSPARENT.method_25846(groundTorch, textureMapping, generator.field_22831)));
        generator.field_22830.accept(class_4925.method_25770((class_2248)wallTorch, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)SVTPModelTemplates.SVTP_TORCH_WALL_TRANSPARENT.method_25846(wallTorch, textureMapping, generator.field_22831))).method_25775(class_4910.method_25630()));
        class_1792 groundTorchItem = groundTorch.method_8389();
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)groundTorchItem), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)groundTorchItem)), generator.field_22831);
        generator.method_25540(wallTorch);
    }

    private static void createRedstoneLantern(class_4910 generator, RegistrySupplier<class_2248> lanternSupplier) {
        class_2248 lantern = (class_2248)lanternSupplier.get();
        class_2960 unlitResource = class_4943.field_22942.method_25846(lantern, SVTPTextureMappings.redstoneLantern(lantern, "_off"), generator.field_22831);
        class_4935 unlitVariant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)unlitResource);
        class_2960 litResource = class_4943.field_22942.method_25847(lantern, "_on", SVTPTextureMappings.redstoneLantern(lantern, "_on"), generator.field_22831);
        class_4935 litVariant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)litResource);
        generator.field_22830.accept(class_4925.method_25769((class_2248)lantern).method_25775((class_4926)class_4926.method_25784((class_2769)RedstoneLanternBlock.REDSTONE_STATE, (class_2769)RedstoneLanternBlock.MANUAL_STATE).method_25797((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), unlitVariant).method_25797((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), unlitVariant).method_25797((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), litVariant).method_25797((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), litVariant)).method_25775(class_4910.method_25599()));
    }

    private void createPlantWithDefaultItem(class_4910 generator, RegistrySupplier<class_2248> flowerSupplier, RegistrySupplier<class_2248> pottedFlowerSupplier) {
        class_2248 flower = (class_2248)flowerSupplier.get();
        class_2248 pottedFlower = (class_2248)pottedFlowerSupplier.get();
        generator.method_25600(flower);
        class_4944 plantMapping = class_4944.method_25877((class_2248)flower);
        class_2960 plantModel = SVTPModelTemplates.CROSS_TRANSPARENT.method_25846(flower, plantMapping, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)flower, (class_2960)plantModel));
        class_4944 pottedPlantMapping = class_4944.method_25881((class_2248)flower);
        class_2960 pottedPlantModel = SVTPModelTemplates.FLOWER_POT_CROSS_TRANSPARENT.method_25846(pottedFlower, pottedPlantMapping, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)pottedFlower, (class_2960)pottedPlantModel));
    }

    private static final class PaperModelGenerator {
        private final class_4910 generator;
        private final RegistrySupplier<class_2248> target;
        private RegistrySupplier<class_2248> top;
        private RegistrySupplier<class_2248> bottom;
        private RegistrySupplier<class_2248> northWest;
        private RegistrySupplier<class_2248> southEast;

        private PaperModelGenerator(class_4910 generator, RegistrySupplier<class_2248> target, RegistrySupplier<class_2248> top, RegistrySupplier<class_2248> bottom, RegistrySupplier<class_2248> northWest, RegistrySupplier<class_2248> southEast) {
            this.generator = generator;
            this.target = target;
            this.top = top;
            this.bottom = bottom;
            this.northWest = northWest;
            this.southEast = southEast;
        }

        public static PaperModelGenerator create(class_4910 generator, RegistrySupplier<class_2248> target) {
            return new PaperModelGenerator(generator, target, target, target, target, target);
        }

        public void createModel() {
            class_4944 textureMapping = SVTPTextureMappings.orientableCubeSameNorthWestAndSouthEast((class_2248)this.top.get(), (class_2248)this.bottom.get(), (class_2248)this.northWest.get(), (class_2248)this.southEast.get());
            class_2960 model = class_4943.field_22942.method_25846((class_2248)this.target.get(), textureMapping, this.generator.field_22831);
            this.generator.field_22830.accept(class_4925.method_25770((class_2248)((class_2248)this.target.get()), (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model)).method_25775(class_4910.method_25599()));
        }

        public PaperModelGenerator setAll(RegistrySupplier<class_2248> block) {
            this.top = block;
            this.bottom = block;
            this.northWest = block;
            this.southEast = block;
            return this;
        }

        public PaperModelGenerator setTop(RegistrySupplier<class_2248> top) {
            this.top = top;
            return this;
        }

        public PaperModelGenerator setBottom(RegistrySupplier<class_2248> bottom) {
            this.bottom = bottom;
            return this;
        }

        public PaperModelGenerator setNorthWest(RegistrySupplier<class_2248> northWest) {
            this.northWest = northWest;
            return this;
        }

        public PaperModelGenerator setSouthEast(RegistrySupplier<class_2248> southEast) {
            this.southEast = southEast;
            return this;
        }
    }
}

