/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.svtp.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
public class GoldenWallTorchBlock
extends WallTorchBlock {
    public static final Map<Direction, VoxelShape> AABBS_GOLDEN_TORCH = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)4.5, (double)3.0, (double)9.0, (double)11.5, (double)14.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)4.5, (double)3.0, (double)0.0, (double)11.5, (double)14.0, (double)7.0), (Object)Direction.WEST, (Object)Block.box((double)9.0, (double)3.0, (double)4.5, (double)16.0, (double)14.0, (double)11.5), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)4.5, (double)7.0, (double)14.0, (double)11.5)));

    public GoldenWallTorchBlock(SimpleParticleType simpleParticleType, BlockBehaviour.Properties properties) {
        super(simpleParticleType, properties);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        Direction direction = ((Direction)blockState.getValue((Property)FACING)).getOpposite();
        double x = (double)blockPos.getX() + 0.5 + 0.27 * (double)direction.getStepX();
        double y = (double)blockPos.getY() + 0.7625 + 0.22;
        double z = (double)blockPos.getZ() + 0.5 + 0.27 * (double)direction.getStepZ();
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)this.flameParticle, x, y, z, 0.0, 0.0, 0.0);
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return AABBS_GOLDEN_TORCH.get(blockState.getValue((Property)FACING));
    }
}

