/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.dragondescent;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.dragondescent.DescentCommand;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DescentGUIListener
implements Listener {
    private final WeaponMasterMain plugin;
    private final DescentCommand descentCommandManager;

    public DescentGUIListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.descentCommandManager = new DescentCommand(plugin);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(this.plugin.descent.DESCENT_GUI_NAME)) {
            return;
        }
        final Player player = (Player)event.getWhoClicked();
        if (!event.getView().getTopInventory().equals(event.getClickedInventory())) {
            return;
        }
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.GRAY_STAINED_GLASS_PANE || event.getCurrentItem().getType() == Material.BARRIER) {
            event.setCancelled(true);
            return;
        }
        switch (event.getSlot()) {
            case 4: {
                this.increment(player, "allDamageResistance");
                break;
            }
            case 13: {
                this.increment(player, "dragonExtraRNG");
                break;
            }
            case 14: {
                this.increment(player, "tougherArmor");
                break;
            }
            case 15: {
                this.increment(player, "enhancedEnergy");
                break;
            }
            case 16: {
                this.increment(player, "strongArrows");
                break;
            }
            case 17: {
                this.increment(player, "grimTouch");
                break;
            }
            case 20: {
                this.increment(player, "shardSeeker");
                break;
            }
            case 21: {
                this.increment(player, "heartbleed");
                break;
            }
            case 22: {
                this.increment(player, "extraAttackSpeed");
                break;
            }
            case 24: {
                this.increment(player, "wisdom");
                break;
            }
            case 29: {
                this.increment(player, "shieldedArmor");
                break;
            }
            case 31: {
                this.increment(player, "mightyStrength");
                break;
            }
            case 33: {
                this.increment(player, "strongLegs");
                break;
            }
            case 34: {
                this.increment(player, "reviver");
                break;
            }
            case 38: {
                this.increment(player, "silkyTouch");
                break;
            }
            case 40: {
                this.increment(player, "vitality");
                break;
            }
            case 42: {
                this.increment(player, "sicklyTouch");
                break;
            }
            case 49: {
                this.increment(player, "strongAttacks");
                break;
            }
            case 51: {
                this.increment(player, "witch");
                break;
            }
            case 52: {
                this.increment(player, "runner");
                break;
            }
            default: {
                player.sendMessage("\u00a7cThat's not an option.");
            }
        }
        event.getView().close();
        new BukkitRunnable(){

            public void run() {
                DescentGUIListener.this.descentCommandManager.openInventory(player);
            }
        }.runTaskLater((Plugin)this.plugin, 5L);
    }

    public void increment(Player player, String upgradeName) {
        if (this.plugin.descent.getUpgrade(player, upgradeName) >= this.plugin.descent.MAX_LEVEL) {
            player.sendMessage("\u00a7cThis upgrade is already at its maximum level!");
            return;
        }
        if (!this.plugin.descent.incrementDescent(player.getUniqueId(), upgradeName)) {
            player.playSound((Entity)player, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            player.sendMessage("\u00a7cYou can't afford this!");
        } else {
            player.playSound((Entity)player, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            player.sendMessage(String.format("\u00a73You successfully bought this upgrade. \u00a77[Level \u00a74%d\u00a77]", this.plugin.descent.getUpgrade(player, upgradeName)));
        }
    }
}

