/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.dragonmanager;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.TrueDamageHelper;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Illager;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MidFightTasks {
    private final double SEARCH_DIST = 160.0;
    private final double ANGER_DIST = 100.0;
    private final double GUARD_MAX_HP = 135.0;
    private final int STORM_SIZE = 4;
    private final double DEFENDER_MAX_HEALTH = 70.0;
    private final double AGENT_HEALTH = 100.0;
    private int hiveAnger_lastTickRan = -1000;
    private int endGuard_lastTickRan = -1000;
    private int lightningAttack_lastTickRan = -1000;
    private int fireballStorm_lastTickRan = -1000;
    private int perchedFireballStorm_lastTickRan = -1000;
    private int toxicStorm_lastTickRan = -1000;
    private int endDweller_lastTickRan = -1000;
    private int endstoneDefender_lastTickRan = -1000;
    private int sniper_lastTickRan = -1000;
    private int ghost_lastTickRan = -1000;
    private int agents_lastTickRan = -1000;
    private final Random rnd = new Random();
    private final WeaponMasterMain plugin;
    private EnderDragon currentlyActiveDragon;

    public MidFightTasks(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.currentlyActiveDragon = null;
    }

    public static boolean rejectWithChance(double averageSeconds) {
        return Math.random() >= 0.05 / averageSeconds;
    }

    @Nullable
    public Player getRandomNearbyPlayer() {
        int i = 1;
        Player target = null;
        for (Entity entity : this.currentlyActiveDragon.getNearbyEntities(160.0, 160.0, 160.0)) {
            Player player;
            if (!(entity instanceof Player) || !(Math.random() < 1.0 / (double)i++) || (player = (Player)entity).getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) continue;
            target = player;
        }
        return target;
    }

    public void lockTarget(final Mob source, final LivingEntity target) {
        new BukkitRunnable(){

            public void run() {
                if (source.isDead()) {
                    this.cancel();
                    return;
                }
                if (source.getTarget() == null || !source.getTarget().equals(target)) {
                    source.setTarget(target);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    public void updateDragon(EnderDragon dragon) {
        this.currentlyActiveDragon = dragon;
    }

    public void startFightTasks() {
        new BukkitRunnable(){
            int tickNumber = 0;

            public void run() {
                ++this.tickNumber;
                if (MidFightTasks.this.currentlyActiveDragon == null || MidFightTasks.this.currentlyActiveDragon.isDead()) {
                    return;
                }
                MidFightTasks.this.doHiveAnger(this.tickNumber);
                MidFightTasks.this.spawnEndGuard(this.tickNumber);
                MidFightTasks.this.doLightningAttack(this.tickNumber);
                MidFightTasks.this.doFireballStorm(this.tickNumber);
                MidFightTasks.this.doPerchedFireballStorm(this.tickNumber);
                MidFightTasks.this.doToxicStorm(this.tickNumber);
                MidFightTasks.this.regenerateOnLowHealth(this.tickNumber);
                MidFightTasks.this.spawnEndDweller(this.tickNumber);
                MidFightTasks.this.spawnEndstoneDefender(this.tickNumber);
                MidFightTasks.this.summonSniper(this.tickNumber);
                MidFightTasks.this.summonGhosts(this.tickNumber);
                MidFightTasks.this.callAgents(this.tickNumber);
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    public void doHiveAnger(int tickNumber) {
        if (MidFightTasks.rejectWithChance(95.0)) {
            return;
        }
        if (tickNumber < this.hiveAnger_lastTickRan + 300) {
            return;
        }
        this.hiveAnger_lastTickRan = tickNumber;
        Player target = this.getRandomNearbyPlayer();
        if (target == null) {
            return;
        }
        int angeredCount = 0;
        for (Entity entity : target.getNearbyEntities(100.0, 100.0, 100.0)) {
            Enderman enderman;
            if (!(entity instanceof Enderman) || (enderman = (Enderman)entity).getTarget() != null) continue;
            double d = Math.random();
            double d2 = angeredCount < 10 ? 0.05 : 0.0;
            if (!(d < 0.1 + d2)) continue;
            enderman.setTarget((LivingEntity)target);
            enderman.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 100, 0, true));
            ++angeredCount;
        }
        target.sendMessage(String.format("\u00a75WeaponMaster Dragon \u00a77used \u00a73Hive Anger \u00a77on you and angered \u00a7b%d \u00a77endermen.", angeredCount));
    }

    public void spawnEndGuard(int tickNumber) {
        if (MidFightTasks.rejectWithChance(55.0)) {
            return;
        }
        if (tickNumber < this.endGuard_lastTickRan + 300) {
            return;
        }
        this.endGuard_lastTickRan = tickNumber;
        Player target = this.getRandomNearbyPlayer();
        if (target == null) {
            return;
        }
        final Enderman endGuard = (Enderman)this.currentlyActiveDragon.getWorld().spawnEntity(target.getLocation(), EntityType.ENDERMAN);
        ItemStack helmet = new ItemStack(Material.DIAMOND_HELMET, 1);
        helmet.addUnsafeEnchantment(Enchantment.BLAST_PROTECTION, 10);
        endGuard.getEquipment().setHelmet(helmet);
        endGuard.setTarget((LivingEntity)target);
        endGuard.setCustomName("\u00a7dEnd Guard");
        endGuard.setCustomNameVisible(true);
        endGuard.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(135.0);
        endGuard.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).addModifier(new AttributeModifier(UUID.randomUUID(), "weaponmaster", 1.1, AttributeModifier.Operation.MULTIPLY_SCALAR_1));
        endGuard.setHealth(135.0);
        PersistentDataContainer pdc = endGuard.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)this.plugin, "WM_DRAGON_NODROPS"), PersistentDataType.INTEGER, (Object)1);
        new BukkitRunnable(){
            int amplifier = -1;

            public void run() {
                ++this.amplifier;
                endGuard.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, 0x3FFFFFFF, this.amplifier, true));
                if (this.amplifier >= 3) {
                    this.cancel();
                    return;
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 300L, 300L);
        this.lockTarget((Mob)endGuard, (LivingEntity)target);
        target.sendMessage("\u00a75WeaponMaster Dragon \u00a77used \u00a73Call Help \u00a77on you. Kill the guards before they get too powerful!");
    }

    public void doLightningAttack(int tickNumber) {
        if (MidFightTasks.rejectWithChance(25.0)) {
            return;
        }
        if (tickNumber < this.lightningAttack_lastTickRan + 300) {
            return;
        }
        this.lightningAttack_lastTickRan = tickNumber;
        for (Entity entity : this.currentlyActiveDragon.getNearbyEntities(160.0, 160.0, 160.0)) {
            if (!(entity instanceof Player)) continue;
            Player target = (Player)entity;
            double damage = 7.0 + (double)this.rnd.nextInt(11);
            if (this.rnd.nextFloat() < 0.5f) {
                damage += 0.5;
            }
            TrueDamageHelper.dealTrueDamage((LivingEntity)target, damage);
            target.getWorld().strikeLightningEffect(target.getLocation());
            target.sendMessage(String.format("\u00a75WeaponMaster Dragon \u00a77used \u00a73Lightning \u00a77on you for \u00a74%.1f \u00a77damage.", damage));
        }
    }

    public void doFireballStorm(int tickNumber) {
        if (MidFightTasks.rejectWithChance(65.0)) {
            return;
        }
        if (tickNumber < this.fireballStorm_lastTickRan + 300) {
            return;
        }
        if (tickNumber < this.perchedFireballStorm_lastTickRan + 200) {
            return;
        }
        this.fireballStorm_lastTickRan = tickNumber;
        final Location loc = this.currentlyActiveDragon.getLocation();
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                Vector ray = new Vector((double)x, -1.4, (double)z).normalize().multiply(1.9);
                Location spawnLoc = loc.clone().add(ray.multiply(4.0));
                DragonFireball fireball = (DragonFireball)loc.getWorld().spawnEntity(spawnLoc, EntityType.DRAGON_FIREBALL);
                fireball.setVelocity(ray);
            }
        }
        new BukkitRunnable(){
            int attacksLeft = 15;

            public void run() {
                if (this.attacksLeft <= 0) {
                    this.cancel();
                    return;
                }
                for (Entity entity : MidFightTasks.this.currentlyActiveDragon.getNearbyEntities(160.0, 160.0, 160.0)) {
                    if (!(entity instanceof Player)) continue;
                    Player target = (Player)entity;
                    Vector direction = target.getLocation().subtract(MidFightTasks.this.currentlyActiveDragon.getLocation()).toVector();
                    Vector velocity = direction.normalize().multiply(3.8);
                    Location spawnLoc = MidFightTasks.this.currentlyActiveDragon.getLocation().add(velocity.multiply(2.5));
                    DragonFireball fireball = (DragonFireball)loc.getWorld().spawnEntity(spawnLoc, EntityType.DRAGON_FIREBALL);
                    fireball.setVelocity(velocity);
                }
                --this.attacksLeft;
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 8L);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals(loc.getWorld())) continue;
            player.sendMessage("\u00a75WeaponMaster Dragon \u00a77used \u00a73Fireball Storm\u00a77.");
        }
    }

    public void doPerchedFireballStorm(int tickNumber) {
        if (this.currentlyActiveDragon.getPhase() != EnderDragon.Phase.SEARCH_FOR_BREATH_ATTACK_TARGET && this.currentlyActiveDragon.getPhase() != EnderDragon.Phase.BREATH_ATTACK) {
            return;
        }
        if (this.currentlyActiveDragon.getVelocity().lengthSquared() >= 16.0) {
            this.currentlyActiveDragon.setVelocity(new Vector(0.0, 0.0, 0.0));
        }
        if (tickNumber < this.perchedFireballStorm_lastTickRan + 200) {
            return;
        }
        this.perchedFireballStorm_lastTickRan = tickNumber;
        Location loc = this.currentlyActiveDragon.getLocation();
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                DragonFireball fireball;
                Vector ray = new Vector((double)x, -1.4, (double)z).normalize().multiply(0.6);
                Location spawnLoc = loc.clone().add(ray.multiply(2.5));
                if (Math.random() < 0.5) {
                    fireball = (DragonFireball)loc.getWorld().spawnEntity(spawnLoc, EntityType.DRAGON_FIREBALL);
                    fireball.setVelocity(ray);
                    continue;
                }
                fireball = (Fireball)loc.getWorld().spawnEntity(spawnLoc, EntityType.FIREBALL);
                fireball.setVelocity(ray);
                fireball.setYield(2.0f);
                fireball.setIsIncendiary(true);
            }
        }
    }

    public void doToxicStorm(int tickNumber) {
        if (MidFightTasks.rejectWithChance(90.0)) {
            return;
        }
        if (tickNumber < this.toxicStorm_lastTickRan + 300) {
            return;
        }
        this.toxicStorm_lastTickRan = tickNumber;
        for (Entity entity : this.currentlyActiveDragon.getNearbyEntities(160.0, 160.0, 160.0)) {
            if (!(entity instanceof Player)) continue;
            Player target = (Player)entity;
            target.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 200, 0, true));
            target.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 200, 0, true));
            target.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 200, 0, true));
            target.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, 200, 0, true));
            target.playSound(target.getLocation(), Sound.ENTITY_WITHER_SPAWN, 1.0f, 1.0f);
            target.sendMessage("\u00a75WeaponMaster Dragon \u00a77used \u00a73Toxic Storm \u00a77and gave you \u00a7cWeakness\u00a77, \u00a7cPoison\u00a77, \u00a7cHunger\u00a77, and \u00a7cMining Fatigue \u00a77for \u00a7c10 \u00a77seconds.");
        }
    }

    public void regenerateOnLowHealth(int tickNumber) {
        if (this.currentlyActiveDragon.getHealth() <= 150.0 && tickNumber % 60 == 0) {
            this.currentlyActiveDragon.setHealth(this.currentlyActiveDragon.getHealth() + 1.0);
        } else if (this.currentlyActiveDragon.getHealth() <= 250.0 && tickNumber % 100 == 0) {
            this.currentlyActiveDragon.setHealth(this.currentlyActiveDragon.getHealth() + 1.0);
        } else if (tickNumber % 180 == 0) {
            this.currentlyActiveDragon.setHealth(Math.min(this.currentlyActiveDragon.getHealth() + 1.0, this.currentlyActiveDragon.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()));
        }
    }

    public void spawnEndDweller(int tickNumber) {
        if (MidFightTasks.rejectWithChance(45.0)) {
            return;
        }
        if (tickNumber < this.endDweller_lastTickRan + 300) {
            return;
        }
        this.endDweller_lastTickRan = tickNumber;
        Player target = this.getRandomNearbyPlayer();
        if (target == null) {
            return;
        }
        IronGolem endDweller = (IronGolem)this.currentlyActiveDragon.getWorld().spawnEntity(target.getLocation(), EntityType.IRON_GOLEM);
        endDweller.setTarget((LivingEntity)target);
        endDweller.setCustomName("\u00a77End Dweller");
        endDweller.setCustomNameVisible(true);
        endDweller.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
        PersistentDataContainer pdc = endDweller.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)this.plugin, "WM_DRAGON_NODROPS"), PersistentDataType.INTEGER, (Object)1);
        this.lockTarget((Mob)endDweller, (LivingEntity)target);
        target.sendMessage("\u00a75WeaponMaster Dragon \u00a77used \u00a73Summon End Dweller \u00a77on you.");
    }

    public void spawnEndstoneDefender(int tickNumber) {
        if (MidFightTasks.rejectWithChance(70.0)) {
            return;
        }
        if (tickNumber < this.endstoneDefender_lastTickRan + 300) {
            return;
        }
        this.endstoneDefender_lastTickRan = tickNumber;
        Player target = this.getRandomNearbyPlayer();
        if (target == null) {
            return;
        }
        final WitherSkeleton defender = (WitherSkeleton)this.currentlyActiveDragon.getWorld().spawnEntity(target.getLocation(), EntityType.WITHER_SKELETON);
        defender.setTarget((LivingEntity)target);
        defender.setCustomName("\u00a76\u00a7lEndstone Defender");
        defender.setCustomNameVisible(true);
        defender.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(70.0);
        defender.setHealth(70.0);
        ItemStack endStone = new ItemStack(Material.END_STONE, 1);
        endStone.addUnsafeEnchantment(Enchantment.BLAST_PROTECTION, 10);
        defender.getEquipment().setHelmet(endStone);
        defender.getEquipment().setChestplate(new ItemStack(Material.NETHERITE_CHESTPLATE, 1));
        defender.getEquipment().setLeggings(new ItemStack(Material.DIAMOND_LEGGINGS, 1));
        defender.getEquipment().setBoots(new ItemStack(Material.DIAMOND_BOOTS, 1));
        PersistentDataContainer pdc = defender.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)this.plugin, "WM_DRAGON_NODROPS"), PersistentDataType.INTEGER, (Object)1);
        target.sendMessage("\u00a75WeaponMaster Dragon \u00a77used \u00a73Endstone Defense \u00a77on you.");
        new BukkitRunnable(){

            public void run() {
                defender.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(250.0);
            }
        }.runTaskLater((Plugin)this.plugin, 80L);
    }

    public void summonSniper(int tickNumber) {
        if (MidFightTasks.rejectWithChance(70.0)) {
            return;
        }
        if (tickNumber < this.sniper_lastTickRan + 300) {
            return;
        }
        this.sniper_lastTickRan = tickNumber;
        Player target = this.getRandomNearbyPlayer();
        if (target == null) {
            return;
        }
        Skeleton sniper = (Skeleton)this.currentlyActiveDragon.getWorld().spawnEntity(target.getLocation(), EntityType.SKELETON);
        sniper.setTarget((LivingEntity)target);
        sniper.setCustomName("\u00a7bEnder Sniper");
        ItemStack helmet = new ItemStack(Material.DIAMOND_HELMET, 1);
        helmet.addUnsafeEnchantment(Enchantment.BLAST_PROTECTION, 10);
        sniper.getEquipment().setHelmet(helmet);
        ItemStack sniperItem = sniper.getEquipment().getItemInMainHand();
        sniperItem.addUnsafeEnchantment(Enchantment.POWER, 20);
        sniperItem.addUnsafeEnchantment(Enchantment.PUNCH, 3);
        sniperItem.addEnchantment(Enchantment.FLAME, 1);
        sniper.getEquipment().setItemInMainHand(sniperItem);
        sniper.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        PersistentDataContainer pdc = sniper.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)this.plugin, "WM_DRAGON_NODROPS"), PersistentDataType.INTEGER, (Object)1);
        target.sendMessage("\u00a75WeaponMaster Dragon \u00a77used \u00a73Summon Sniper \u00a77on you.");
        this.lockTarget((Mob)sniper, (LivingEntity)target);
    }

    public void summonGhosts(int tickNumber) {
        if (MidFightTasks.rejectWithChance(105.0)) {
            return;
        }
        if (tickNumber < this.ghost_lastTickRan + 300) {
            return;
        }
        this.ghost_lastTickRan = tickNumber;
        Player target = this.getRandomNearbyPlayer();
        if (target == null) {
            return;
        }
        int number = 1 + this.rnd.nextInt(3);
        for (int i = 0; i < number; ++i) {
            double x = target.getLocation().getX() + ThreadLocalRandom.current().nextDouble(-5.0, 5.0);
            double y = target.getLocation().getY() + (double)this.rnd.nextInt(64);
            double z = target.getLocation().getZ() + ThreadLocalRandom.current().nextDouble(-5.0, 5.0);
            Location spawnLoc = new Location(this.currentlyActiveDragon.getWorld(), x, y, z);
            Phantom ghost = (Phantom)this.currentlyActiveDragon.getWorld().spawnEntity(spawnLoc, EntityType.PHANTOM);
            ghost.setTarget((LivingEntity)target);
            ghost.setCustomName("\u00a74Ghost");
            ghost.setCustomNameVisible(true);
            double health = this.currentlyActiveDragon.getHealth() / this.currentlyActiveDragon.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
            double multi = (1.0 - health) * 8.0;
            ghost.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).addModifier(new AttributeModifier(UUID.randomUUID(), "weaponmaster", multi, AttributeModifier.Operation.MULTIPLY_SCALAR_1));
            PersistentDataContainer pdc = ghost.getPersistentDataContainer();
            pdc.set(new NamespacedKey((Plugin)this.plugin, "WM_DRAGON_NODROPS"), PersistentDataType.INTEGER, (Object)1);
            this.lockTarget((Mob)ghost, (LivingEntity)target);
        }
        target.sendMessage("\u00a75WeaponMaster Dragon \u00a77used \u00a73Summon Ghosts \u00a77on you.");
    }

    public void callAgents(int tickNumber) {
        if (MidFightTasks.rejectWithChance(70.0)) {
            return;
        }
        if (tickNumber < this.agents_lastTickRan + 300) {
            return;
        }
        this.agents_lastTickRan = tickNumber;
        Player target = this.getRandomNearbyPlayer();
        if (target == null) {
            return;
        }
        String[] names = new String[]{"\u00a72Brown", "\u00a72Smith", "\u00a72Jones"};
        EntityType[] types = new EntityType[]{EntityType.VINDICATOR, EntityType.EVOKER, EntityType.PILLAGER};
        for (int i = 0; i < 3; ++i) {
            Illager agent = (Illager)this.currentlyActiveDragon.getWorld().spawnEntity(target.getLocation(), types[i]);
            agent.setTarget((LivingEntity)target);
            agent.setCustomName(names[i]);
            agent.setCustomNameVisible(true);
            ItemStack helmet = new ItemStack(Material.DIAMOND_HELMET, 1);
            helmet.addUnsafeEnchantment(Enchantment.BLAST_PROTECTION, 10);
            agent.getEquipment().setHelmet(helmet);
            agent.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(100.0);
            agent.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, 0x3FFFFFFF, 3, true));
            agent.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 0x3FFFFFFF, 0, true));
            PersistentDataContainer pdc = agent.getPersistentDataContainer();
            pdc.set(new NamespacedKey((Plugin)this.plugin, "WM_DRAGON_NODROPS"), PersistentDataType.INTEGER, (Object)1);
            this.lockTarget((Mob)agent, (LivingEntity)target);
        }
        target.sendMessage("\u00a75WeaponMaster Dragon \u00a77used \u00a73Call Agents \u00a77on you.");
    }
}

