/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.AssassinsBlade;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class AssassinsBladeListener
implements Listener {
    private final float REQUIRED_ANGLE = 40.0f;
    private final Util util;

    public AssassinsBladeListener(WeaponMasterMain plugin) {
        this.util = new Util(plugin);
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        float targetYaw;
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForAssassinsBlade(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.assassinsblade.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.assassinsblade.use\u00a73.");
            return;
        }
        Entity target = event.getEntity();
        float playerYaw = (player.getLocation().getYaw() + 360.0f) % 360.0f;
        float angle = Math.abs(playerYaw - (targetYaw = (target.getLocation().getYaw() + 360.0f) % 360.0f));
        if (angle < 40.0f || 320.0f < angle) {
            event.setDamage(event.getDamage() * 1.4);
            player.getWorld().spawnParticle(Particle.LARGE_SMOKE, target.getLocation(), 40);
        }
    }
}

