/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.CavemanSword;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CavemanItemListener
implements Listener {
    private final Map<UUID, Integer> xpCooldown = new HashMap<UUID, Integer>();
    private final double MULTIPLIER = 0.25;
    private final WeaponMasterMain plugin;
    private final Util util;

    public CavemanItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    private int parseExpInt(String s) {
        String data = s.substring(16, s.length());
        return Integer.parseInt(data);
    }

    private int parseLevelInt(String s) {
        String data = s.substring(21, s.length());
        return Integer.parseInt(data);
    }

    private int getRequirementToLevelUp(int level) {
        if (level >= 16) {
            return 2147483600;
        }
        return (new int[]{1, 20, 30, 50, 70, 90, 110, 140, 170, 210, 260, 320, 400, 510, 670, 910})[level] * 1000;
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        int lastAmount;
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        final Player player = (Player)event.getDamager();
        if (!this.util.checkForCavemanSword(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.cavemansword.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.cavemansword.use\u00a73.");
            return;
        }
        int amount = (int)(Math.min((event.getFinalDamage() + 1.0) * event.getFinalDamage() * event.getDamage(), 16000.0) * 0.25);
        if (amount > (lastAmount = this.xpCooldown.getOrDefault(player.getUniqueId(), 0).intValue())) {
            ItemMeta iMeta = player.getInventory().getItemInMainHand().getItemMeta();
            List lore = iMeta.getLore();
            Objects.requireNonNull(this.util);
            int exp = this.parseExpInt((String)lore.get(3));
            Objects.requireNonNull(this.util);
            int level = this.parseLevelInt((String)lore.get(5));
            if ((exp += (amount -= lastAmount)) >= this.getRequirementToLevelUp(level)) {
                exp = 0;
                iMeta.removeEnchant(Enchantment.SHARPNESS);
                iMeta.addEnchant(Enchantment.SHARPNESS, ++level, true);
                player.sendMessage(String.format("\u00a79Your %s \u00a79is now level \u00a76%d.", this.util.CAVEMAN_SWORD_NAME, level));
                Objects.requireNonNull(this.util);
                lore.set(5, String.format("\u00a76Sharpness Level: \u00a7b%d", level));
            }
            Objects.requireNonNull(this.util);
            lore.set(3, String.format("\u00a76Experience: \u00a7b%d", exp));
            double xpPercent = 100.0 * (double)exp / (double)this.getRequirementToLevelUp(level);
            Objects.requireNonNull(this.util);
            lore.set(4, String.format("\u00a76Required Experience: \u00a7b%d \u00a76(\u00a7b%.1f\u00a76%%)", this.getRequirementToLevelUp(level), xpPercent));
            this.plugin.paperUtils.sendActionBar(player, String.format("\u00a7a+%d  \u00a77|  \u00a7b%d\u00a76/\u00a7b%d \u00a76(\u00a7b%.1f\u00a76%%)", amount, exp, this.getRequirementToLevelUp(level), xpPercent), true);
            iMeta.setLore(lore);
            player.getInventory().getItemInMainHand().setItemMeta(iMeta);
            this.xpCooldown.put(player.getUniqueId(), lastAmount - 1);
            new BukkitRunnable(){

                public void run() {
                    CavemanItemListener.this.xpCooldown.put(player.getUniqueId(), 0);
                }
            }.runTaskLater((Plugin)this.plugin, 10L);
        }
    }
}

