/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.CopperSword;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CopperSwordListener
implements Listener {
    Random rnd = new Random();
    private final WeaponMasterMain plugin;
    private final Util util;
    private final NamespacedKey pdcWaxKey;
    private final NamespacedKey pdcOxidizeKey;

    public CopperSwordListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.pdcWaxKey = new NamespacedKey((Plugin)plugin, "WM_COPPER_SWORD_WAX");
        this.pdcOxidizeKey = new NamespacedKey((Plugin)plugin, "WM_COPPER_SWORD_OXIDIZE");
    }

    @EventHandler
    public void OnHit(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForCopperSword(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.coppersword.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.coppersword.use\u00a73.");
            return;
        }
        ItemMeta im = player.getInventory().getItemInMainHand().getItemMeta();
        PersistentDataContainer pdc = im.getPersistentDataContainer();
        if (!pdc.has(this.pdcOxidizeKey, PersistentDataType.STRING)) {
            pdc.set(this.pdcOxidizeKey, PersistentDataType.STRING, (Object)"normal");
        }
        if (!pdc.has(this.pdcWaxKey, PersistentDataType.INTEGER)) {
            pdc.set(this.pdcWaxKey, PersistentDataType.INTEGER, (Object)0);
        }
        if (Math.random() < 0.05 && (Integer)pdc.get(this.pdcWaxKey, PersistentDataType.INTEGER) != 1) {
            List lore = im.getLore();
            String oxidizeLevel = (String)pdc.get(this.pdcOxidizeKey, PersistentDataType.STRING);
            if (oxidizeLevel.equals("normal")) {
                lore.set(8, "\u00a7bEXPOSED");
                pdc.set(this.pdcOxidizeKey, PersistentDataType.STRING, (Object)"exposed");
                im.removeEnchant(Enchantment.SHARPNESS);
                im.removeEnchant(Enchantment.UNBREAKING);
                im.addEnchant(Enchantment.SHARPNESS, 2, false);
                im.addEnchant(Enchantment.UNBREAKING, 8, true);
                player.sendMessage("\u00a7cOh no, your Copper Sword Oxidized.");
            } else if (oxidizeLevel.equals("exposed")) {
                lore.set(8, "\u00a7bOXIDIZED");
                pdc.set(this.pdcOxidizeKey, PersistentDataType.STRING, (Object)"oxidized");
                im.removeEnchant(Enchantment.SHARPNESS);
                im.removeEnchant(Enchantment.UNBREAKING);
                im.addEnchant(Enchantment.SHARPNESS, 1, false);
                im.addEnchant(Enchantment.UNBREAKING, 7, true);
                player.sendMessage("\u00a7cOh no, your Copper Sword Oxidized.");
            }
            im.setLore(lore);
            player.getInventory().getItemInMainHand().setItemMeta(im);
        }
        if ((double)player.getAttackCooldown() != 1.0) {
            return;
        }
        if (Math.random() > 0.15) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacked = (LivingEntity)event.getEntity();
        int duration = this.rnd.nextInt(41) + 40;
        attacked.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, duration, 127));
        attacked.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, duration, 9));
        attacked.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, duration, 0));
        this.plugin.paperUtils.sendActionBar(player, String.format("\u00a73You stunned your enemy for %d seconds.", duration / 20), true);
        if (attacked.getType() == EntityType.PLAYER) {
            Player attackedPlayer = (Player)event.getEntity();
            attackedPlayer.playSound((Entity)attackedPlayer, Sound.BLOCK_ANVIL_LAND, 1.0f, 1.0f);
            this.plugin.paperUtils.sendActionBar(attackedPlayer, String.format("\u00a73You were stunned for %d seconds.", duration / 20), true);
        }
    }

    @EventHandler
    public void OnRepair(PrepareAnvilEvent event) {
        PersistentDataContainer pdc;
        List lore;
        ItemMeta im;
        ItemStack outputItem;
        if (!this.util.checkForCopperSword(event.getInventory().getItem(0))) {
            return;
        }
        if (event.getInventory().getItem(1) == null) {
            return;
        }
        Player player = (Player)event.getView().getPlayer();
        if (event.getInventory().getItem(1).getType() == Material.GOLD_INGOT) {
            event.setResult(new ItemStack(Material.AIR, 1));
            event.getInventory().setRepairCost(0);
        }
        if (event.getInventory().getItem(1).getType() == Material.HONEYCOMB) {
            outputItem = new ItemStack(Material.GOLDEN_SWORD, 1);
            im = event.getInventory().getItem(0).getItemMeta();
            lore = im.getLore();
            pdc = im.getPersistentDataContainer();
            pdc.set(this.pdcWaxKey, PersistentDataType.INTEGER, (Object)1);
            lore.set(9, "\u00a76WAXED");
            im.setLore(lore);
            outputItem.setItemMeta(im);
            event.setResult(outputItem);
        }
        if (event.getInventory().getItem(1).getType() == Material.COPPER_BLOCK) {
            if (event.getInventory().getItem(1).getAmount() != 4) {
                player.sendMessage("\u00a7cYou must have exactly \u00a7b4 \u00a7cof \u00a76Copper Block \u00a7cto execute this operation.");
            } else {
                outputItem = new ItemStack(Material.GOLDEN_SWORD, 1);
                im = event.getInventory().getItem(0).getItemMeta();
                lore = im.getLore();
                pdc = im.getPersistentDataContainer();
                pdc.set(this.pdcOxidizeKey, PersistentDataType.STRING, (Object)"normal");
                lore.set(8, "\u00a7bNORMAL");
                im.setLore(lore);
                im.addEnchant(Enchantment.SHARPNESS, 3, false);
                im.removeEnchant(Enchantment.UNBREAKING);
                im.addEnchant(Enchantment.UNBREAKING, 9, true);
                outputItem.setItemMeta(im);
                event.setResult(outputItem);
            }
        }
    }

    @EventHandler
    public void onAnvilClick(InventoryClickEvent event) {
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getView().getType() != InventoryType.ANVIL) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getRawSlot() != 2 || !this.util.checkForCopperSword(event.getInventory().getItem(0))) {
            return;
        }
        if (event.getInventory().getItem(1).getType() == Material.GOLD_INGOT) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cYou're not allowed to execute this anvil operation on " + this.util.COPPER_SWORD_NAME + "\u00a7c. This item can't be repaired.");
        } else if (event.getInventory().getItem(1).getType() == Material.HONEYCOMB || event.getInventory().getItem(1).getType() == Material.COPPER_BLOCK) {
            event.getWhoClicked().setItemOnCursor(event.getCurrentItem());
            event.getClickedInventory().clear();
        }
    }
}

