/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.DragonArmor;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.mainitems.DragonArmor.DragonArmorUpgradeListener;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class DragonArmorListener
implements Listener {
    private final double PROTECTION_EACH = 0.05;
    private final double PROTECTION_ENCHANT = 0.0075;
    private final double BONUS_EACH = 0.02;
    private final float REDUCTION_HUNGER = 0.6666667f;
    private final WeaponMasterMain plugin;
    private final Util util;
    private final boolean fixStuttering;

    public DragonArmorListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.fixStuttering = plugin.getConfig().getBoolean("dragonArmor.fixStuttering", true);
    }

    public boolean hasFullSet(PlayerInventory inventory) {
        return this.util.checkForDragonArmor(inventory.getHelmet()) && this.util.checkForDragonArmor(inventory.getChestplate()) && this.util.checkForDragonArmor(inventory.getLeggings()) && this.util.checkForDragonArmor(inventory.getBoots());
    }

    private int getUpgradeLevel(ItemStack stack) {
        PersistentDataContainer pdc = stack.getItemMeta().getPersistentDataContainer();
        return (Integer)pdc.getOrDefault(DragonArmorUpgradeListener.DRAGON_ARMOR_UPGRADE_KEY, PersistentDataType.INTEGER, (Object)0);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onDamage(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.VOID) {
            return;
        }
        if (event.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getEntity();
        double damageProtection = 1.0;
        if (this.util.checkForDragonArmor(player.getInventory().getHelmet())) {
            damageProtection -= 0.05 + 0.005 * (double)this.getUpgradeLevel(player.getInventory().getHelmet());
        }
        if (this.util.checkForDragonArmor(player.getInventory().getChestplate())) {
            damageProtection -= 0.05 + 0.005 * (double)this.getUpgradeLevel(player.getInventory().getChestplate());
        }
        if (this.util.checkForDragonArmor(player.getInventory().getLeggings())) {
            damageProtection -= 0.05 + 0.005 * (double)this.getUpgradeLevel(player.getInventory().getLeggings());
        }
        if (this.util.checkForDragonArmor(player.getInventory().getBoots())) {
            damageProtection -= 0.05 + 0.005 * (double)this.getUpgradeLevel(player.getInventory().getBoots());
        }
        if (this.hasFullSet(player.getInventory())) {
            int a = player.getInventory().getHelmet().getEnchantmentLevel(Enchantment.PROTECTION);
            int b = player.getInventory().getChestplate().getEnchantmentLevel(Enchantment.PROTECTION);
            int c = player.getInventory().getLeggings().getEnchantmentLevel(Enchantment.PROTECTION);
            int d = player.getInventory().getBoots().getEnchantmentLevel(Enchantment.PROTECTION);
            damageProtection -= (double)(a + b + c + d) * 0.0075;
        }
        if (damageProtection >= 0.999) {
            return;
        }
        damageProtection = Math.max(damageProtection, 0.02);
        if (!player.hasPermission("weaponmaster.dragonarmor.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.dragonarmor.use\u00a73.");
            return;
        }
        event.setDamage(event.getDamage() * damageProtection);
        if (this.fixStuttering && player.getNoDamageTicks() > 0 && player.getNoDamageTicks() != 10 && event.getDamage() < player.getLastDamage() + 0.001) {
            event.setCancelled(true);
            return;
        }
        this.plugin.paperUtils.sendActionBar(player, String.format("\u00a7eDamage was reduced by %.0f%% to %.1f.", 100.0 * (1.0 - damageProtection), event.getDamage()), false);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onDamageFromEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        double damageBonus = 1.0;
        if (this.util.checkForDragonArmor(player.getInventory().getHelmet())) {
            damageBonus += 0.02 + 0.002 * (double)this.getUpgradeLevel(player.getInventory().getHelmet());
        }
        if (this.util.checkForDragonArmor(player.getInventory().getChestplate())) {
            damageBonus += 0.02 + 0.002 * (double)this.getUpgradeLevel(player.getInventory().getChestplate());
        }
        if (this.util.checkForDragonArmor(player.getInventory().getLeggings())) {
            damageBonus += 0.02 + 0.002 * (double)this.getUpgradeLevel(player.getInventory().getLeggings());
        }
        if (this.util.checkForDragonArmor(player.getInventory().getBoots())) {
            damageBonus += 0.02 + 0.002 * (double)this.getUpgradeLevel(player.getInventory().getBoots());
        }
        if (damageBonus <= 1.001) {
            return;
        }
        if (!player.hasPermission("weaponmaster.dragonarmor.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.dragonarmor.use\u00a73.");
            return;
        }
        event.setDamage(event.getDamage() * damageBonus);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onExhaustion(EntityExhaustionEvent event) {
        Player player = (Player)event.getEntity();
        if (!this.hasFullSet(player.getInventory())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.dragonarmor.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.dragonarmor.use\u00a73.");
            return;
        }
        event.setExhaustion(event.getExhaustion() * 0.6666667f);
    }
}

