/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.DragonArmor;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class DragonArmorUpgradeListener
implements Listener {
    public static final NamespacedKey DRAGON_ARMOR_UPGRADE_KEY = new NamespacedKey("weaponmaster", "dragon_armor_upgrade");
    public static final int LORE_LINE_1 = 11;
    public static final int LORE_LINE_2 = 12;
    public static final int LORE_LINE_3 = 13;
    public static final int LORE_LINE_4 = 14;
    private final WeaponMasterMain plugin;
    private final Util util;

    public DragonArmorUpgradeListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    public int getUpgradeCount(ItemMeta im) {
        return (Integer)im.getPersistentDataContainer().getOrDefault(DRAGON_ARMOR_UPGRADE_KEY, PersistentDataType.INTEGER, (Object)0);
    }

    public int getLevelsForItem(int lvl) {
        return 70 * lvl;
    }

    @EventHandler
    public void onAnvil(PrepareAnvilEvent event) {
        ItemStack dragonArmor = event.getInventory().getItem(0);
        ItemStack scale = event.getInventory().getItem(1);
        if (!this.util.checkForDragonArmor(dragonArmor)) {
            return;
        }
        if (!this.util.checkFor(scale, 0, "id: DRAGON_SCALE")) {
            return;
        }
        ItemMeta armorIM = dragonArmor.getItemMeta();
        int currentUpgradeLevel = this.getUpgradeCount(armorIM);
        if (currentUpgradeLevel >= 5) {
            ItemStack barrier = new ItemStack(Material.BARRIER, 1);
            ItemMeta barrierIM = barrier.getItemMeta();
            barrierIM.setDisplayName("\u00a7cError");
            barrierIM.setLore(Arrays.asList("\u00a77You have already reached the maximum level!"));
            event.setResult(barrier);
            event.getResult().setItemMeta(barrierIM);
            return;
        }
        ItemMeta newIM = armorIM.clone();
        List newLore = newIM.getLore();
        String lvls = String.format("\u00a74\u00a7l[!] \u00a7eWeaponMaster: \u00a7a\u00a7oThis operation will cost \u00a7b%d \u00a7a\u00a7olevels.", this.getLevelsForItem(++currentUpgradeLevel));
        String upgradingTo = String.format("\u00a74\u00a7l[!] \u00a7eWeaponMaster: \u00a73Upgrading to level \u00a7b%d%s\u00a73!", currentUpgradeLevel, currentUpgradeLevel == 5 ? " \u00a72(MAXED)" : "");
        if (currentUpgradeLevel == 1) {
            newLore.add(11, "");
            newLore.add(12, lvls);
            newLore.add(13, upgradingTo);
            newLore.add(14, "");
        } else {
            newLore.set(11, "");
            newLore.set(12, lvls);
            newLore.set(13, upgradingTo);
            newLore.set(14, "");
        }
        newIM.getPersistentDataContainer().set(DRAGON_ARMOR_UPGRADE_KEY, PersistentDataType.INTEGER, (Object)currentUpgradeLevel);
        newIM.setLore(newLore);
        ItemStack newItemStack = new ItemStack(dragonArmor.getType(), 1);
        event.setResult(newItemStack);
        event.getResult().setItemMeta(newIM);
    }

    @EventHandler
    private void onPickingResultingItem(InventoryClickEvent event) {
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getView().getType() != InventoryType.ANVIL) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getRawSlot() == 2 && this.util.checkForDragonArmor(event.getInventory().getItem(0)) && this.util.checkFor(event.getInventory().getItem(1), 0, "id: DRAGON_SCALE")) {
            ItemMeta im = event.getCurrentItem().getItemMeta();
            int lvl = this.getUpgradeCount(im);
            int levelsRequired = this.getLevelsForItem(lvl);
            if (player.getLevel() < levelsRequired) {
                player.sendMessage(String.format("\u00a7cYou must have \u00a7b%d \u00a7clevels to perform this action.", levelsRequired));
                event.setCancelled(true);
                return;
            }
            player.setLevel(player.getLevel() - levelsRequired);
            List newLore = im.getLore();
            newLore.set(11, "");
            newLore.set(12, String.format("\u00a76Upgrade Level: \u00a7b%d%s", lvl, lvl >= 5 ? " \u00a7a(MAXED!)" : ""));
            newLore.set(13, String.format("\u00a79BONUS: \u00a73Reduces damage taken by another \u00a7b%.1f%%\u00a73. [%.1f%%]", (double)lvl * 0.5, 5.0 + (double)lvl * 0.5));
            newLore.set(14, String.format("\u00a79BONUS: \u00a73Increases damage dealt by another \u00a7b%.1f%%\u00a73. [%.1f%%]", (double)lvl * 0.2, 2.0 + (double)lvl * 0.2));
            im.setLore(newLore);
            event.getCurrentItem().setItemMeta(im);
            event.getWhoClicked().setItemOnCursor(event.getCurrentItem());
            event.getClickedInventory().clear();
        }
    }
}

