/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.DragonElytra;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DragonElytraUpgradeListener
implements Listener {
    UUID modifierUUID = UUID.fromString("00000000-1111-0000-0000-200c8453f6de");
    private final WeaponMasterMain plugin;
    private final Util util;

    public DragonElytraUpgradeListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    public int getUpgradeCount(ItemMeta im) {
        Collection modifiers = im.getAttributeModifiers(Attribute.GENERIC_ARMOR);
        if (modifiers == null) {
            return 0;
        }
        if (modifiers.size() > 1) {
            throw new RuntimeException("should only be 1 AM");
        }
        Iterator iterator = modifiers.iterator();
        if (iterator.hasNext()) {
            AttributeModifier aMod = (AttributeModifier)iterator.next();
            return (int)(aMod.getAmount() / 0.5);
        }
        return 0;
    }

    public int getLevelsForItem(ItemMeta im) {
        return 40 * this.getUpgradeCount(im);
    }

    @EventHandler
    public void onAnvil(PrepareAnvilEvent event) {
        ItemStack elytra = event.getInventory().getItem(0);
        ItemStack scale = event.getInventory().getItem(1);
        Player player = (Player)event.getViewers().get(0);
        if (!this.util.checkForDragonElytra(elytra)) {
            return;
        }
        if (!this.util.checkFor(scale, 0, "id: DRAGON_SCALE")) {
            return;
        }
        ItemMeta elytraIM = elytra.getItemMeta();
        int currentUpgradeLevel = this.getUpgradeCount(elytraIM);
        if (currentUpgradeLevel >= 10) {
            ItemStack barrier = new ItemStack(Material.BARRIER, 1);
            ItemMeta barrierIM = barrier.getItemMeta();
            barrierIM.setDisplayName("\u00a7cError");
            barrierIM.setLore(Arrays.asList("\u00a77You have already reached the maximum level!"));
            event.setResult(barrier);
            event.getResult().setItemMeta(barrierIM);
            return;
        }
        ItemMeta newIM = elytraIM.clone();
        List newLore = newIM.getLore();
        newIM.removeAttributeModifier(Attribute.GENERIC_ARMOR);
        newIM.addAttributeModifier(Attribute.GENERIC_ARMOR, new AttributeModifier(this.modifierUUID, "weaponmaster", (double)(++currentUpgradeLevel) * 0.5, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
        newLore.add(String.format("\u00a74\u00a7l[!] \u00a7eWeaponMaster: \u00a7a\u00a7oThis operation will cost \u00a7b%d \u00a7a\u00a7olevels.", this.getLevelsForItem(newIM)));
        newLore.add(String.format("\u00a74\u00a7l[!] \u00a7eWeaponMaster: \u00a73Upgrading to level \u00a7b%d%s\u00a73!", currentUpgradeLevel, currentUpgradeLevel == 10 ? " \u00a72(MAXED)" : ""));
        newIM.setLore(newLore);
        ItemStack newItemStack = new ItemStack(Material.ELYTRA, 1);
        event.setResult(newItemStack);
        event.getResult().setItemMeta(newIM);
    }

    public void stripLastLoreLines(ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        List lore = im.getLore();
        for (int i = 0; i < 2; ++i) {
            lore.remove(lore.size() - 1);
        }
        im.setLore(lore);
        itemStack.setItemMeta(im);
    }

    @EventHandler
    private void onPickingResultingItem(InventoryClickEvent event) {
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getView().getType() != InventoryType.ANVIL) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getRawSlot() == 2 && this.util.checkForDragonElytra(event.getInventory().getItem(0)) && this.util.checkFor(event.getInventory().getItem(1), 0, "id: DRAGON_SCALE")) {
            ItemMeta im = event.getCurrentItem().getItemMeta();
            int levelsRequired = this.getLevelsForItem(im);
            if (player.getLevel() < levelsRequired) {
                player.sendMessage(String.format("\u00a7cYou must have \u00a7b%d \u00a7clevels to perform this action.", levelsRequired));
                event.setCancelled(true);
                return;
            }
            player.setLevel(player.getLevel() - levelsRequired);
            this.stripLastLoreLines(event.getCurrentItem());
            event.getWhoClicked().setItemOnCursor(event.getCurrentItem());
            event.getClickedInventory().clear();
        }
    }
}

