/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.DragonSword;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DragonSwordUpgradeListener
implements Listener {
    private final WeaponMasterMain plugin;
    private final Util util;

    public DragonSwordUpgradeListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    public int getUpgradeCount(List<String> lore) {
        String loreData = lore.get(this.util.DRAGON_UPGRADE);
        if (loreData.equals("\u00a76LEGENDARY")) {
            return 0;
        }
        if (loreData.length() <= 2) {
            return 0;
        }
        String[] data = loreData.split(" ");
        return Integer.parseInt(data[2].substring(2));
    }

    public double abilityTriggerProbability(int upgradeLevel) {
        return 0.5 + 0.05 * (double)upgradeLevel;
    }

    public double abilityTriggerProbability(List<String> lore) {
        return this.abilityTriggerProbability(this.getUpgradeCount(lore));
    }

    public int getLevelsForItem(List<String> lore) {
        return 40 * this.getUpgradeCount(lore);
    }

    @EventHandler
    public void onAnvil(PrepareAnvilEvent event) {
        ItemStack dragon = event.getInventory().getItem(0);
        ItemStack scale = event.getInventory().getItem(1);
        Player player = (Player)event.getViewers().get(0);
        if (!this.util.checkForDragonSword(dragon)) {
            return;
        }
        if (!this.util.checkFor(scale, 0, "id: DRAGON_SCALE")) {
            return;
        }
        ItemMeta dragonIM = dragon.getItemMeta();
        List dragonLore = dragonIM.getLore();
        int currentUpgradeLevel = this.getUpgradeCount(dragonLore);
        if (currentUpgradeLevel >= 10) {
            return;
        }
        ++currentUpgradeLevel;
        ItemMeta newIM = dragonIM.clone();
        List newLore = newIM.getLore();
        if (((String)newLore.get(this.util.DRAGON_UPGRADE)).equals("\u00a76LEGENDARY")) {
            newLore.add(this.util.DRAGON_UPGRADE, "");
            newLore.add(this.util.DRAGON_UPGRADE + 1, "\u00a77\u00a7oUpgrades increase the chance to deal even higher damage.");
        }
        newLore.set(this.util.DRAGON_UPGRADE, String.format("\u00a76Upgrade Level: \u00a7b%d%s", currentUpgradeLevel, currentUpgradeLevel >= 10 ? " \u00a7a(MAXED!)" : ""));
        newLore.add(String.format("\u00a74\u00a7l[!] \u00a7eWeaponMaster: \u00a7a\u00a7oThis operation will cost \u00a7b%d \u00a7a\u00a7olevels.", this.getLevelsForItem(newLore)));
        newIM.setLore(newLore);
        for (Enchantment enchant : newIM.getEnchants().keySet()) {
            newIM.removeEnchant(enchant);
        }
        ItemStack newItemStack = new ItemStack(Material.NETHERITE_SWORD, 1);
        event.setResult(newItemStack);
        event.getResult().setItemMeta(newIM);
        player.sendMessage("\u00a77done!");
    }

    public void stripLastLoreLine(ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        List lore = im.getLore();
        lore.remove(lore.size() - 1);
        im.setLore(lore);
        itemStack.setItemMeta(im);
    }

    @EventHandler
    private void onPickingResultingItem(InventoryClickEvent event) {
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getView().getType() != InventoryType.ANVIL) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getRawSlot() == 2 && this.util.checkForDragonSword(event.getInventory().getItem(0)) && this.util.checkFor(event.getInventory().getItem(1), 0, "id: DRAGON_SCALE")) {
            ItemMeta im = event.getCurrentItem().getItemMeta();
            int levelsRequired = this.getLevelsForItem(im.getLore());
            if (player.getLevel() < levelsRequired) {
                player.sendMessage(String.format("\u00a7cYou must have \u00a7b%d \u00a7clevels to perform this action.", levelsRequired));
                event.setCancelled(true);
                return;
            }
            player.setLevel(player.getLevel() - levelsRequired);
            this.stripLastLoreLine(event.getCurrentItem());
            event.getWhoClicked().setItemOnCursor(event.getCurrentItem());
            event.getClickedInventory().clear();
        }
    }
}

