/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.Fireball;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class FireballListener
implements Listener {
    private final float VELOCITY = 1.9f;
    private final float POWER = 3.0f;
    private final double SEEKING_DISTANCE = 3.0;
    private final WeaponMasterMain plugin;
    private final Util util;

    public FireballListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        final Player player = event.getPlayer();
        if (!this.util.checkForFireball(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.fireball.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.fireball.use\u00a73.");
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            event.setCancelled(true);
        }
        if (Util.checkForInteractableBlock(event)) {
            return;
        }
        Location eyeLocation = player.getEyeLocation();
        Location spawnLoc = eyeLocation.add(eyeLocation.getDirection().multiply(0.9));
        World world = player.getWorld();
        if (Math.random() <= 0.02) {
            DragonFireball dragonFireballEntity = (DragonFireball)world.spawnEntity(spawnLoc, EntityType.DRAGON_FIREBALL);
            dragonFireballEntity.setVelocity(eyeLocation.getDirection().multiply(1.9f));
            event.getPlayer().sendMessage("\u00a73You summoned a dragon fireball!");
        } else {
            final Fireball fireball = (Fireball)world.spawnEntity(spawnLoc, EntityType.FIREBALL);
            fireball.setVelocity(eyeLocation.getDirection().multiply(1.9f));
            fireball.setYield(3.0f);
            fireball.setShooter((ProjectileSource)player);
            new BukkitRunnable(){

                public void run() {
                    if (fireball.isDead()) {
                        this.cancel();
                        return;
                    }
                    Location fireballLoc = fireball.getLocation();
                    fireball.getWorld().spawnParticle(Particle.FLAME, fireballLoc, 10, 0.0, 0.0, 0.0, 0.001);
                    if (FireballListener.this.plugin.getConfig().getBoolean("fireball.heatSeeking")) {
                        List nearEntities = fireball.getNearbyEntities(3.0, 3.0, 3.0);
                        nearEntities.sort((a, b) -> (int)(1000.0 * (a.getLocation().distanceSquared(fireballLoc) - b.getLocation().distanceSquared(fireballLoc))));
                        for (Entity target : nearEntities) {
                            if (!player.hasLineOfSight(target) || !(target instanceof Player) || target.isDead() || target.getEntityId() == player.getEntityId()) continue;
                            fireball.setVelocity(target.getLocation().toVector().subtract(fireballLoc.toVector()).normalize().multiply(1.9f));
                            break;
                        }
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
        }
        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
            player.getInventory().getItemInMainHand().setAmount(player.getInventory().getItemInMainHand().getAmount() - 1);
        }
    }
}

