/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.MinerBlessing;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;

public class MinerUtil {
    protected final WeaponMasterMain plugin;
    protected final Util util;
    protected final Random rnd = new Random();

    public MinerUtil(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    protected String getMode(List<String> lore) {
        return lore.get(this.util.MINER_INSERTION + 3);
    }

    protected int xpToAdd(Material mat, List<String> lore) {
        if (this.getMode(lore).equals("\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Silk Touch")) {
            return this.silkLoot(mat);
        }
        if (this.getMode(lore).equals("\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Smelting Touch")) {
            return this.smeltingLoot(mat);
        }
        return this.defaultLoot(mat);
    }

    protected int silkLoot(Material mat) {
        if (mat == Material.OBSIDIAN || mat == Material.ANCIENT_DEBRIS) {
            return 55;
        }
        if (mat == Material.DEEPSLATE) {
            return 15;
        }
        if (mat == Material.STONE || mat == Material.TUFF) {
            return 4;
        }
        return 1;
    }

    protected int smeltingLoot(Material mat) {
        if (mat == Material.JIGSAW) {
            return 5000000;
        }
        if (mat == Material.STRUCTURE_BLOCK) {
            return 500000;
        }
        if (mat == Material.BEDROCK) {
            return 100000;
        }
        if (mat == Material.ANCIENT_DEBRIS) {
            return 2600;
        }
        return this.defaultLoot(mat);
    }

    protected int defaultLoot(Material mat) {
        if (mat == Material.DEEPSLATE_COAL_ORE) {
            return 3300;
        }
        if (mat == Material.DEEPSLATE_EMERALD_ORE) {
            return 1800;
        }
        if (mat == Material.DIAMOND_ORE || mat == Material.DEEPSLATE_DIAMOND_ORE) {
            return 1500;
        }
        if (mat == Material.EMERALD_ORE) {
            return 1000;
        }
        if (mat == Material.DEEPSLATE_LAPIS_ORE || mat == Material.DEEPSLATE_COPPER_ORE || mat == Material.DEEPSLATE_IRON_ORE || mat == Material.DEEPSLATE_GOLD_ORE) {
            return 810;
        }
        if (mat == Material.IRON_ORE || mat == Material.GOLD_ORE || mat == Material.DEEPSLATE_REDSTONE_ORE || mat == Material.REDSTONE_ORE || mat == Material.LAPIS_ORE) {
            return 600;
        }
        if (mat == Material.COAL_ORE || mat == Material.COPPER_ORE || mat == Material.NETHER_QUARTZ_ORE || mat == Material.NETHER_GOLD_ORE) {
            return 220;
        }
        if (mat == Material.OBSIDIAN || mat == Material.ANCIENT_DEBRIS) {
            return 55;
        }
        if (mat == Material.DEEPSLATE) {
            return 15;
        }
        if (mat == Material.STONE || mat == Material.TUFF) {
            return 4;
        }
        return 1;
    }

    protected int doFortuneOre(int amount, int hasFortune) {
        int multiplier;
        if (hasFortune == 0) {
            return amount;
        }
        float f = this.rnd.nextFloat();
        if (hasFortune == 4) {
            multiplier = Math.max((int)(f * 6.0f), 1);
        } else if (hasFortune == 3) {
            multiplier = Math.max((int)(f * 5.0f), 1);
        } else {
            throw new IllegalStateException("fortune has to be 3 or 4");
        }
        return amount * multiplier;
    }

    protected int parseExpInt(String s) {
        String data = s.substring(16, s.length());
        return Integer.parseInt(data);
    }

    protected int parseLevelInt(String s) {
        String data = s.substring(10, s.length());
        return Integer.parseInt(data);
    }

    protected int getRequirementToLevelUp(int level) {
        if (level >= 16) {
            return 2000000 + (1 << Math.min(level - 16, 30));
        }
        return (new int[]{2000, 5000, 11000, 21000, 38000, 64000, 102000, 156000, 229000, 326000, 452000, 612000, 813000, 1061000, 1363000, 1727000})[level];
    }

    public void fixEnchants(int tier, ItemMeta im, Player player) {
        if (tier >= 7) {
            return;
        }
        im.removeEnchant(Enchantment.EFFICIENCY);
        im.removeEnchant(Enchantment.UNBREAKING);
        im.removeEnchant(Enchantment.FORTUNE);
        im.removeEnchant(Enchantment.SILK_TOUCH);
        switch (tier) {
            case 0: {
                break;
            }
            case 1: {
                im.addEnchant(Enchantment.EFFICIENCY, 1, false);
                break;
            }
            case 2: {
                im.addEnchant(Enchantment.EFFICIENCY, 2, false);
                break;
            }
            case 3: {
                im.addEnchant(Enchantment.EFFICIENCY, 3, false);
                im.addEnchant(Enchantment.UNBREAKING, 1, false);
                break;
            }
            case 4: {
                im.addEnchant(Enchantment.EFFICIENCY, 4, false);
                im.addEnchant(Enchantment.UNBREAKING, 1, false);
                im.addEnchant(Enchantment.SHARPNESS, 1, false);
                break;
            }
            case 5: {
                im.addEnchant(Enchantment.EFFICIENCY, 5, false);
                im.addEnchant(Enchantment.UNBREAKING, 2, false);
                im.addEnchant(Enchantment.SHARPNESS, 2, false);
                break;
            }
            case 6: {
                im.addEnchant(Enchantment.EFFICIENCY, 5, false);
                im.addEnchant(Enchantment.UNBREAKING, 3, false);
                im.addEnchant(Enchantment.SHARPNESS, 3, false);
            }
        }
    }
}

