/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.NetheriteStaff;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.mainitems.NetheriteStaff.EffectPicker;
import io.github.greatericontop.weaponmaster.utils.MathHelper;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class NetheriteStaffListener
implements Listener {
    Random rand = new Random();
    private final double VELOCITY = 4.0;
    private final WeaponMasterMain plugin;
    private final Util util;

    public NetheriteStaffListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    @EventHandler
    public void onAttack(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForNetheriteStaff(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.netheritestaff.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.netheritestaff.use\u00a73.");
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacked = (LivingEntity)event.getEntity();
        Object[] effectData = EffectPicker.getRandomEffect(false);
        PotionEffect effect = new PotionEffect((PotionEffectType)effectData[0], ((Integer)effectData[1]).intValue(), ((Integer)effectData[2]).intValue());
        attacked.addPotionEffect(effect);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.util.checkForNetheriteStaff(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.netheritestaff.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.netheritestaff.use\u00a73.");
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && (event.getClickedBlock().getType() == Material.DIRT || event.getClickedBlock().getType() == Material.GRASS_BLOCK)) {
            event.setCancelled(true);
        }
        if (Util.checkForInteractableBlock(event)) {
            return;
        }
        Damageable iMeta = (Damageable)player.getInventory().getItemInMainHand().getItemMeta();
        if (iMeta.getDamage() > 1930) {
            this.plugin.paperUtils.sendActionBar(player, "\u00a73Not enough durability to shoot an arrow!", true);
            return;
        }
        if (event.getPlayer().getGameMode() == GameMode.SURVIVAL && player.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.UNBREAKING) < 4 && !event.getPlayer().getInventory().contains(Material.ARROW)) {
            this.plugin.paperUtils.sendActionBar(player, "\u00a73You must have arrows in your inventory to shoot!", true);
            return;
        }
        Location eyeLocation = player.getEyeLocation();
        Location spawnLoc = eyeLocation.clone().add(eyeLocation.getDirection().multiply(0.9));
        World world = player.getWorld();
        Arrow arrow = (Arrow)world.spawnEntity(spawnLoc, EntityType.ARROW);
        arrow.setShooter((ProjectileSource)player);
        arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
        Object[] effectData = EffectPicker.getRandomEffect(true);
        PotionEffect effect = new PotionEffect((PotionEffectType)effectData[0], ((Integer)effectData[1]).intValue(), ((Integer)effectData[2]).intValue());
        arrow.addCustomEffect(effect, true);
        arrow.setVelocity(eyeLocation.getDirection().multiply(4.0));
        arrow.setColor(Color.BLACK);
        arrow.setDamage(0.75);
        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
            iMeta.setDamage(iMeta.getDamage() + MathHelper.getDamageWithUnbreaking(5, (ItemMeta)iMeta));
            if (player.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.UNBREAKING) < 4 && Math.random() + (double)player.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.UNBREAKING) * 0.25 < 0.95) {
                player.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.ARROW, 1)});
            }
            player.getInventory().getItemInMainHand().setItemMeta((ItemMeta)iMeta);
        }
    }
}

