/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.NinjaBow;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.InaccuracyAdder;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class NinjaItemListener
implements Listener {
    private Map<UUID, Boolean> cooldown = new HashMap<UUID, Boolean>();
    private final WeaponMasterMain plugin;
    private final Util util;
    private final double INACCURACY = 0.01675;

    public NinjaItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    public Arrow spawnArrow(World world, Location location, Vector direction, double velocity, double maxInaccuracyMagnitude, double damageValue, int punchValue, boolean isFire, Player shooterPlayer, AbstractArrow.PickupStatus pickupStatus) {
        Arrow arrow = (Arrow)world.spawnEntity(location, EntityType.ARROW);
        Vector normalVelocity = direction.clone().normalize().multiply(velocity);
        arrow.setVelocity(normalVelocity.add(InaccuracyAdder.generateInaccuracy(maxInaccuracyMagnitude)));
        arrow.setDamage(damageValue);
        arrow.setKnockbackStrength(punchValue);
        arrow.setShooter((ProjectileSource)shooterPlayer);
        arrow.setPickupStatus(pickupStatus);
        if (isFire) {
            arrow.setFireTicks(Integer.MAX_VALUE);
        }
        return arrow;
    }

    @EventHandler
    public void onBowShoot(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (this.util.checkForNinjaBow(event.getBow())) {
            player.sendMessage("\u00a7cYou need to use LEFT CLICK to shoot this.");
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeftClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        final Player player = event.getPlayer();
        if (!this.util.checkForNinjaBow(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.ninjabow.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.ninjabow.use\u00a73.");
            return;
        }
        if (!this.cooldown.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            return;
        }
        ItemMeta im = player.getInventory().getItemInMainHand().getItemMeta();
        double damageValue = 2.0 + (im.hasEnchant(Enchantment.POWER) ? 0.5 : 0.0) + (double)im.getEnchantLevel(Enchantment.POWER) * 0.5;
        boolean isFire = im.hasEnchant(Enchantment.FLAME);
        boolean hasInfinity = im.hasEnchant(Enchantment.INFINITY);
        int punchValue = im.getEnchantLevel(Enchantment.PUNCH);
        if (player.getGameMode() != GameMode.CREATIVE) {
            if (!player.getInventory().contains(Material.ARROW)) {
                return;
            }
            if (!hasInfinity) {
                player.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.ARROW, 1)});
            }
        }
        Location eyeLoc = player.getEyeLocation();
        Vector mainArrowDirection = eyeLoc.getDirection();
        Vector arrow1Direction = mainArrowDirection.clone().rotateAroundY(0.2617993877991494);
        Vector arrow2Direction = mainArrowDirection.clone().rotateAroundY(-0.2617993877991494);
        Arrow mainArrow = this.spawnArrow(eyeLoc.getWorld(), eyeLoc.clone().add(mainArrowDirection.clone().multiply(0.1)), mainArrowDirection, 3.0, 0.01675, damageValue, punchValue, isFire, player, AbstractArrow.PickupStatus.DISALLOWED);
        mainArrow.setCritical(true);
        Arrow sideArrow1 = this.spawnArrow(eyeLoc.getWorld(), eyeLoc.clone().add(arrow1Direction.clone().multiply(0.2)), arrow1Direction, 3.0, 0.06281250000000001, damageValue * 0.6, punchValue, isFire, player, AbstractArrow.PickupStatus.DISALLOWED);
        Arrow sideArrow2 = this.spawnArrow(eyeLoc.getWorld(), eyeLoc.clone().add(arrow2Direction.clone().multiply(0.2)), arrow2Direction, 3.0, 0.06281250000000001, damageValue * 0.6, punchValue, isFire, player, AbstractArrow.PickupStatus.DISALLOWED);
        this.cooldown.put(player.getUniqueId(), false);
        new BukkitRunnable(){

            public void run() {
                NinjaItemListener.this.cooldown.put(player.getUniqueId(), true);
            }
        }.runTaskLater((Plugin)this.plugin, 8L);
    }
}

