/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.RPGLauncher;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.InaccuracyAdder;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class RPGItemListener
implements Listener {
    private final WeaponMasterMain plugin;
    private final Util util;
    private ArrayList<String> projectilesInFlightUUIDs = new ArrayList();
    private final double SPREAD_RADIUS = 0.4495;

    public RPGItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    private Arrow fireOneGrenade(Player player) {
        Location eyeLoc = player.getEyeLocation();
        Vector velocityVector = eyeLoc.getDirection().multiply(14.5);
        Vector inaccuracy = InaccuracyAdder.generateInaccuracy(0.4495);
        velocityVector.add(inaccuracy);
        Arrow arrow = (Arrow)player.getWorld().spawnEntity(eyeLoc.add(velocityVector.clone().multiply(0.1)), EntityType.ARROW);
        arrow.setVelocity(velocityVector);
        arrow.setShooter((ProjectileSource)player);
        return arrow;
    }

    @EventHandler
    public void onLeftClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        final Player player = event.getPlayer();
        if (!this.util.checkForRPGLauncher(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.rpgl.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.rpgl.use\u00a73.");
            return;
        }
        final Arrow arrow = this.fireOneGrenade(player);
        this.projectilesInFlightUUIDs.add(arrow.getUniqueId().toString());
        player.setVelocity(player.getVelocity().subtract(player.getEyeLocation().getDirection().multiply(0.2)));
        new BukkitRunnable(){

            public void run() {
                if (arrow.isDead()) {
                    this.cancel();
                } else {
                    player.getWorld().spawnParticle(Particle.LARGE_SMOKE, arrow.getLocation(), 190);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile entity = event.getEntity();
        if (!this.projectilesInFlightUUIDs.contains(entity.getUniqueId().toString())) {
            return;
        }
        Player player = (Player)entity.getShooter();
        double magnitude = Math.min(entity.getVelocity().length() * 0.1, 0.2);
        Location explosionLocation = entity.getLocation().subtract(entity.getVelocity().normalize().multiply(magnitude));
        entity.getLocation().getWorld().createExplosion(explosionLocation, 5.0f, true, true, (Entity)player);
        entity.remove();
        player.sendMessage("\u00a73FWOOM!");
    }
}

