/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.dragonmanager;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.dragonmanager.DragonWeightManager;
import io.github.greatericontop.weaponmaster.dragonmanager.LootDropper;
import io.github.greatericontop.weaponmaster.dragonmanager.MidFightTasks;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.DragonBattle;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;

public class FightManager
implements Listener {
    public static final double DRAGON_MAX_HP = 1000.0;
    public EnderDragon currentlyActiveDragon = null;
    public UUID currentlyActiveDragonID = null;
    public DragonWeightManager dragonWeightManager = null;
    private final MidFightTasks midFightTasks;
    public double damageDealtToDragonThroughExplosions = 0.0;
    private final WeaponMasterMain plugin;

    public FightManager(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.midFightTasks = new MidFightTasks(plugin);
        this.midFightTasks.startFightTasks();
        this.registerDragonUnloadCheckRunnable();
    }

    private void registerDragonUnloadCheckRunnable() {
        new BukkitRunnable(){

            public void run() {
                if (FightManager.this.currentlyActiveDragonID == null || !FightManager.this.currentlyActiveDragon.isDead()) {
                    return;
                }
                for (World world : Bukkit.getWorlds()) {
                    DragonBattle battle = world.getEnderDragonBattle();
                    if (battle == null || battle.getEnderDragon() == null || battle.getEnderDragon().isDead() || !battle.getEnderDragon().getUniqueId().equals(FightManager.this.currentlyActiveDragonID)) continue;
                    Bukkit.broadcastMessage((String)"\u00a7cWhile you all were regearing, the WeaponMaster Dragon was regearing too! It has healed 250 health!");
                    FightManager.this.currentlyActiveDragon = battle.getEnderDragon();
                    FightManager.this.currentlyActiveDragon.setHealth(Math.min(1000.0, FightManager.this.currentlyActiveDragon.getHealth() + 250.0));
                    FightManager.this.midFightTasks.updateDragon(FightManager.this.currentlyActiveDragon);
                    return;
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 40L, 40L);
    }

    public boolean checkSpecialDragonConditions(EntitySpawnEvent event) {
        World world = event.getLocation().getWorld();
        if (world == null) {
            return false;
        }
        if (world.getEnvironment() != World.Environment.THE_END) {
            return false;
        }
        BoundingBox crystalBoundingBox = new BoundingBox(0.499, 0.0, 0.499, 0.501, 200.0, 0.501);
        Collection nearbyEntities = world.getNearbyEntities(crystalBoundingBox, entity -> entity.getType().toString().equals("END_CRYSTAL") || entity.getType().toString().equals("ENDER_CRYSTAL"));
        return nearbyEntities.size() >= 3;
    }

    @EventHandler
    public void onDragonSpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (!(event.getEntity() instanceof EnderDragon)) {
            return;
        }
        if (!this.checkSpecialDragonConditions(event)) {
            entity.setCustomName("\u00a7dEnder Dragon");
            return;
        }
        this.currentlyActiveDragon = (EnderDragon)entity;
        this.buffDragon(this.currentlyActiveDragon);
        this.currentlyActiveDragonID = this.currentlyActiveDragon.getUniqueId();
        this.damageDealtToDragonThroughExplosions = 0.0;
        this.midFightTasks.updateDragon(this.currentlyActiveDragon);
        this.dragonWeightManager = new DragonWeightManager(this.plugin, this.currentlyActiveDragon, 1000.0).setEnabled(true);
        Bukkit.broadcastMessage((String)"\u00a7cThe WeaponMaster Dragon has spawned!");
    }

    public void buffDragon(EnderDragon dragon) {
        dragon.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(1000.0);
        dragon.setHealth(1000.0);
        dragon.setCustomName("\u00a7cWeaponMaster Dragon");
        dragon.setCustomNameVisible(true);
    }

    @EventHandler
    public void onDragonDamage(EntityDamageEvent event) {
        if (this.currentlyActiveDragon == null) {
            return;
        }
        if (!event.getEntity().getUniqueId().equals(this.currentlyActiveDragon.getUniqueId())) {
            return;
        }
        if (event.getDamage() >= 30.0) {
            double adjustedExtra = Math.pow(event.getDamage() - 29.0, 0.6) - 1.0;
            event.setDamage(30.0 + adjustedExtra);
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            if (this.damageDealtToDragonThroughExplosions >= 80.0) {
                event.setDamage(event.getDamage() * 0.1);
            } else if (this.damageDealtToDragonThroughExplosions + event.getDamage() >= 80.0) {
                double fullDamage = 80.0 - this.damageDealtToDragonThroughExplosions;
                event.setDamage(fullDamage + 0.1 * (event.getDamage() - fullDamage));
            }
            this.damageDealtToDragonThroughExplosions += event.getFinalDamage();
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        if (pdc.has(new NamespacedKey((Plugin)this.plugin, "WM_DRAGON_NODROPS"), PersistentDataType.INTEGER)) {
            event.getDrops().clear();
            event.setDroppedExp(0);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageByEntityEvent event) {
        if (this.dragonWeightManager == null) {
            return;
        }
        this.dragonWeightManager.onDamage(event);
    }

    @EventHandler
    public void onDragonDeath(EntityDeathEvent event) {
        if (this.currentlyActiveDragon == null) {
            return;
        }
        if (!event.getEntity().getUniqueId().equals(this.currentlyActiveDragon.getUniqueId())) {
            return;
        }
        LootDropper lootDropper = new LootDropper(this.plugin);
        for (Player player : this.dragonWeightManager.players) {
            if (player.isDead()) {
                player = Bukkit.getPlayer((UUID)player.getUniqueId());
                this.plugin.getLogger().info("[Debug] player was dead so re-getting player object");
            }
            int weight = this.dragonWeightManager.getDragonWeight(player.getUniqueId());
            lootDropper.doAllDrops(this.currentlyActiveDragon.getWorld(), weight, player);
        }
        this.midFightTasks.updateDragon(null);
        this.dragonWeightManager.setEnabled(false);
    }
}

