/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.dragonmanager;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.minorcrafts.MinorItems;
import io.github.greatericontop.weaponmaster.utils.MathHelper;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class LootDropper {
    private final int[] dx = new int[]{-1, -1, -1, 0, 0, 0, 1, 1, 1};
    private final int[] dz = new int[]{-1, 0, 1, -1, 0, 1, -1, 0, 1};
    private final WeaponMasterMain plugin;
    private final MinorItems customItems;

    public LootDropper(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.customItems = new MinorItems();
    }

    public void dropItemAt(World world, Location loc, ItemStack toDrop, UUID owner, String displayName, int pickupDelay) {
        Item item = (Item)world.spawnEntity(loc, EntityType.ITEM);
        item.setItemStack(toDrop);
        item.setOwner(owner);
        item.setPickupDelay(pickupDelay);
        item.setVelocity(new Vector(0.0, 0.5, 0.0));
        item.setInvulnerable(true);
        if (displayName != null) {
            item.setCustomName(displayName);
            item.setCustomNameVisible(true);
        }
    }

    public int getYLevel(World world, int x, int z) {
        int maxY = 0;
        for (int i = 0; i < 9; ++i) {
            int yHere = world.getHighestBlockYAt(x + this.dx[i], z + this.dz[i]);
            maxY = Math.max(yHere, maxY);
        }
        return maxY;
    }

    public void createDrop(World world, int x, int z, ItemStack itemStack, UUID owner, String displayName) {
        int y = this.getYLevel(world, x, z);
        final Location loc = new Location(world, (double)x, (double)y, (double)z).add(0.0, 1.0, 0.0);
        for (int i = 0; i < 9; ++i) {
            loc.clone().add((double)this.dx[i], 0.0, (double)this.dz[i]).getBlock().setType(Material.PURPUR_BLOCK);
        }
        final Location itemLoc = loc.clone().add(0.5, 1.25, 0.5);
        this.dropItemAt(world, itemLoc, itemStack, owner, displayName, 60);
        new BukkitRunnable(){
            int i = 0;

            public void run() {
                if (this.i >= 20) {
                    this.cancel();
                    return;
                }
                loc.getWorld().spawnParticle(Particle.FLAME, itemLoc, 200, 0.0, 0.0, 0.0, 0.07);
                ++this.i;
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 40L);
    }

    public void createDrop(World world, ItemStack itemStack, UUID owner, String displayName) {
        int x = ThreadLocalRandom.current().nextInt(-30, 31);
        int z = ThreadLocalRandom.current().nextInt(-30, 31);
        this.createDrop(world, x, z, itemStack, owner, displayName);
    }

    public void createDrop(World world, ItemStack itemStack, Player player, String itemName) {
        this.createDrop(world, itemStack, player.getUniqueId(), String.format("\u00a7f%s\u00a77: \u00a7a%s", player.getDisplayName(), itemName));
    }

    public int doMajorDrops(World world, int weight, Player player) {
        double doubleDropsChance;
        boolean hasSoloerBonus = weight >= 1275;
        this.plugin.getLogger().info(String.format("[Debug] player %s: weight %d (solo %b)", player.getName(), weight, hasSoloerBonus));
        double d = doubleDropsChance = hasSoloerBonus ? 0.5 : 0.0;
        if (this.plugin.descent.isEnabled) {
            doubleDropsChance += 0.015 * (double)this.plugin.descent.getUpgrade(player, "dragonExtraRNG");
        }
        double hornChance = hasSoloerBonus ? 0.1 : 0.06;
        double scaleChance = hasSoloerBonus ? 0.2 : 0.12;
        double wingChance = hasSoloerBonus ? 0.7 : 0.42;
        double rand = Math.random();
        if (rand < hornChance && weight >= 600) {
            ItemStack stack = this.customItems.generateDragonHornItemStack();
            if (Math.random() < doubleDropsChance) {
                stack.setAmount(2);
            }
            this.createDrop(world, stack, player, "Dragon Horn");
            return weight -= 600;
        }
        if (rand < hornChance + scaleChance && weight >= 550) {
            ItemStack stack = this.customItems.generateDragonScaleItemStack();
            if (Math.random() < doubleDropsChance) {
                stack.setAmount(2);
            }
            this.createDrop(world, stack, player, "Dragon Scale");
            return weight -= 550;
        }
        if (rand < hornChance + scaleChance + wingChance && weight >= 400) {
            ItemStack stack = this.customItems.generateDragonWingItemStack();
            if (Math.random() < doubleDropsChance) {
                stack.setAmount(2);
            }
            this.createDrop(world, stack, player, "Dragon Wing");
            return weight -= 400;
        }
        return weight;
    }

    public int doMinorDrops(World world, int weight, Player player) {
        int shulkerShellAmount = 0;
        int obsidianAmount = 0;
        int enderPearlAmount = 0;
        for (int i = 0; weight > 0 && i < 32; ++i) {
            double rand = Math.random();
            if (weight >= 130 && rand < 0.08) {
                ++shulkerShellAmount;
                weight -= 130;
                continue;
            }
            if (weight >= 25 && 0.04 <= rand && rand < 0.34) {
                ++obsidianAmount;
                weight -= 25;
                continue;
            }
            if (weight < 25 || !(0.34 <= rand) || !(rand < 0.64)) continue;
            ++enderPearlAmount;
            weight -= 25;
        }
        if (shulkerShellAmount > 0) {
            this.createDrop(world, new ItemStack(Material.SHULKER_SHELL, shulkerShellAmount), player, "Shulker Shell");
        }
        if (obsidianAmount > 0) {
            this.createDrop(world, new ItemStack(Material.OBSIDIAN, obsidianAmount), player, "Obsidian");
        }
        if (enderPearlAmount > 0) {
            this.createDrop(world, new ItemStack(Material.ENDER_PEARL, enderPearlAmount), player, "Ender Pearl");
        }
        return weight;
    }

    public int doAllDrops(World world, int totalWeight, Player player) {
        int shards = MathHelper.roundProbability((double)totalWeight / 40.0);
        if (totalWeight >= 50) {
            shards += ThreadLocalRandom.current().nextInt(1, 6);
        }
        if (totalWeight >= 1275) {
            shards += 30;
            player.sendTitle("\u00a76Solo!", "", 20, 120, 20);
            player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
        }
        this.plugin.descent.addShards(player, shards);
        player.sendMessage(String.format("\u00a73You had \u00a7a%d \u00a73weight and earned \u00a7b%d\u00a73 shards.", totalWeight, shards));
        return this.doMinorDrops(world, this.doMajorDrops(world, totalWeight, player), player);
    }
}

