/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.utils;

import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.ItemMeta;

public class MathHelper {
    public static int roundProbability(double number) {
        int intPart = (int)number;
        double fracPart = number - (double)intPart;
        if (Math.random() < fracPart) {
            ++intPart;
        }
        return intPart;
    }

    public static int getDamageWithUnbreaking(int rawDamage, int unbreakingLevel) {
        int newAmount = 0;
        for (int i = 0; i < rawDamage; ++i) {
            if (!(Math.random() < 1.0 / (double)unbreakingLevel)) continue;
            ++newAmount;
        }
        return newAmount;
    }

    public static int getDamageWithUnbreaking(int rawDamage, ItemMeta im) {
        int unbreakingLevel = im.getEnchantLevel(Enchantment.UNBREAKING);
        return MathHelper.getDamageWithUnbreaking(rawDamage, unbreakingLevel);
    }

    public static String getColor(double percent) {
        if (percent >= 90.0) {
            return "a";
        }
        if (percent >= 50.0) {
            return "e";
        }
        if (percent >= 25.0) {
            return "6";
        }
        return "c";
    }
}

