/*
 * Decompiled with CFR 0.152.
 */
package cutefox.betterenchanting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cutefox.betterenchanting.Util.EnchantingIngredientMapPayload;
import cutefox.betterenchanting.Util.IngredientData;
import cutefox.betterenchanting.Util.Utils;
import cutefox.betterenchanting.conditions.ModConfigConditions;
import cutefox.betterenchanting.config.GlobalConfig;
import cutefox.betterenchanting.datagen.ModEnchantIngredientMap;
import cutefox.betterenchanting.registry.ModEnchantmentTags;
import cutefox.betterenchanting.registry.ModItemTags;
import cutefox.betterenchanting.registry.ModItems;
import cutefox.betterenchanting.registry.ModLootTableModifiers;
import cutefox.betterenchanting.registry.ModLootTables;
import cutefox.betterenchanting.registry.ModScreenHandlerType;
import cutefox.betterenchanting.registry.ModTradeOffers;
import eu.midnightdust.lib.config.MidnightConfig;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetterEnchanting
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"better-enchanting");
    public static final String MOD_ID = "BetterEnchanting";
    public static boolean NEO_ENCHANT_PRESENT = false;
    public static boolean BUMBLEZONE_PRESENT = false;
    public static boolean REPLANTMENT_PRESENT = false;
    public static boolean DUNGEONS_AND_TAVERNS_PRESENT = false;
    public static boolean HORSESHOES_PRESENT = false;
    public static boolean ENDERSCAPE_PRESENT = false;
    public static boolean DIVERSITY_PRESENT = false;
    public static boolean TOSS_UP_PRESENT = false;
    public static boolean SPELL_POWER_PRESENT = false;
    public static boolean COMBAT_ROLL_PRESENT = false;
    private List<IngredientData> customIngredientData;

    public void onInitialize() {
        ModConfigConditions.registerConditions();
        this.checkForCompat();
        this.customIngredientData = new ArrayList<IngredientData>();
        MidnightConfig.init((String)"better-enchanting/betterEnchanting", GlobalConfig.class);
        ModItems.registerModItems();
        ModScreenHandlerType.registerModScreenHandlers();
        ModEnchantmentTags.registerModTags();
        ModEnchantIngredientMap.createMap();
        ModTradeOffers.removeEnchantedBooks();
        ModItemTags.registerModTags();
        ModLootTables.registerLootTables();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return Utils.id("enchanting");
            }

            public void method_14491(class_3300 manager) {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                for (class_2960 id : manager.method_14488("enchanting", path -> path.toString().endsWith(".json")).keySet()) {
                    try {
                        InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                        try {
                            InputStreamReader reader = new InputStreamReader(stream);
                            IngredientData data = (IngredientData)gson.fromJson((Reader)reader, IngredientData.class);
                            BetterEnchanting.this.customIngredientData.add(data);
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occurred while loading resource json " + id.toString(), (Throwable)e);
                    }
                }
            }
        });
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)Utils.id("item_group"), (Object)this.generateItemGroup());
        PayloadTypeRegistry.playS2C().register(EnchantingIngredientMapPayload.ID, EnchantingIngredientMapPayload.CODEC);
        ModLootTableModifiers.modifyLootTables();
        this.addEventListner();
    }

    private void addEventListner() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> server.execute(() -> ServerPlayNetworking.send((class_3222)handler.field_14140, (class_8710)new EnchantingIngredientMapPayload(ModEnchantIngredientMap.jsonMap))));
        ServerLifecycleEvents.SERVER_STARTED.register(e -> {
            if (e.method_34864().method_14487().contains("enchantplus")) {
                NEO_ENCHANT_PRESENT = true;
                ModEnchantIngredientMap.loadNeoEnchantConfig();
            }
            if (e.method_34864().method_14487().contains("replantment")) {
                REPLANTMENT_PRESENT = true;
                ModEnchantIngredientMap.loadReplantmentConfig();
            }
            if (e.method_34864().method_14487().contains("nova_structures")) {
                DUNGEONS_AND_TAVERNS_PRESENT = true;
                LOGGER.info("Mod nova_structures (Dungeon and Taverns) is loaded ! ");
                ModEnchantIngredientMap.loadDungeonsAndTavernsConfig();
            }
            if (e.method_34864().method_14487().contains("toss_up") && !TOSS_UP_PRESENT) {
                LOGGER.info("Datapack Toss Up is present and loaded ; Building compat for BetterEnchanting");
                TOSS_UP_PRESENT = true;
                ModEnchantIngredientMap.loadTossUpConfig();
            }
            ModEnchantIngredientMap.genMapFromJson((class_1937)e.method_3847(class_3218.field_25179));
            ModEnchantIngredientMap.buildCustomIngredientDataMap((class_1937)e.method_3847(class_3218.field_25179), this.customIngredientData);
        });
        ServerLifecycleEvents.SERVER_STARTING.register(e -> Utils.setRegistryManager((class_5455)e.method_30611()));
    }

    private class_1761 generateItemGroup() {
        return FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)ModItems.ESSENCE_OF_PROTECTION)).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.betterenchanting.item_group")).method_47317((context, entries) -> {
            entries.method_45423(ModItems.MOD_ITEM_LIST.stream().map(class_1792::method_7854).toList());
            if (BUMBLEZONE_PRESENT) {
                entries.method_45423(ModItems.MOD_ITEM_LIST_BUMBLEZONE_COMPAT.stream().map(class_1792::method_7854).toList());
            }
        }).method_47324();
    }

    private void checkForCompat() {
        if (FabricLoader.getInstance().isModLoaded("the_bumblezone")) {
            LOGGER.info("Mod Bumblezone is present and loaded ; Building compat for BetterEnchanting");
            BUMBLEZONE_PRESENT = true;
            ModEnchantIngredientMap.loadBumblezoneConfig();
        }
        if (FabricLoader.getInstance().isModLoaded("incantationem")) {
            LOGGER.info("Mod incantationem is present and loaded ; Building compat for BetterEnchanting");
        }
        if (FabricLoader.getInstance().isModLoaded("horseshoes")) {
            LOGGER.info("Mod horseshoes is present ; Building compat for BetterEnchanting");
            HORSESHOES_PRESENT = true;
        }
        if (FabricLoader.getInstance().isModLoaded("mr_dungeons_andtaverns")) {
            LOGGER.info("Mod nova_structures (Dungeon and Taverns) is present and loaded ; Building compat for BetterEnchanting");
            DUNGEONS_AND_TAVERNS_PRESENT = true;
        }
        if (FabricLoader.getInstance().isModLoaded("toss_up")) {
            LOGGER.info("Mod Toss Up is present and loaded ; Building compat for BetterEnchanting");
            TOSS_UP_PRESENT = true;
            ModEnchantIngredientMap.loadTossUpConfig();
        }
        if (FabricLoader.getInstance().isModLoaded("diversity")) {
            LOGGER.info("Mod Diversity is present and loaded; Building compat for BetterEnchanting");
            DIVERSITY_PRESENT = true;
            ModEnchantIngredientMap.loadDiversityConfig();
        }
        if (FabricLoader.getInstance().isModLoaded("spell_power")) {
            LOGGER.info("Mod Spell Power is present and loaded; Building compat for BetterEnchanting");
            SPELL_POWER_PRESENT = true;
            ModEnchantIngredientMap.loadSpellPowerConfig();
        }
        if (FabricLoader.getInstance().isModLoaded("combat_roll")) {
            LOGGER.info("Mod Combat Roll is present and loaded; Building compat for BetterEnchanting");
            COMBAT_ROLL_PRESENT = true;
            ModEnchantIngredientMap.loadCombatRollConfig();
        }
        if (FabricLoader.getInstance().isModLoaded("enderscape")) {
            LOGGER.info("Mod Enderscape is present and loaded; Building compat for BetterEnchanting");
            ENDERSCAPE_PRESENT = true;
        }
    }
}

