/*
 * Decompiled with CFR 0.152.
 */
package cutefox.betterenchanting.datagen;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import cutefox.betterenchanting.BetterEnchanting;
import cutefox.betterenchanting.Util.IngredientData;
import cutefox.betterenchanting.Util.Utils;
import cutefox.betterenchanting.registry.ModItems;
import io.netty.buffer.ByteBuf;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9139;

public class ModEnchantIngredientMap {
    public static HashMap<String, List<String>> defaultMap = new HashMap();
    private static final HashMap<class_1887, List<class_1792>> ENCHANTMENT_INGREDIENTS_MAP = new HashMap();
    private static HashMap<class_1887, List<class_1792>> externalEnchantmentIngredientsMap = new HashMap();
    private static HashMap<class_1887, List<class_1792>> modedmap = new HashMap();
    public static Map<String, List<String>> jsonMap = new HashMap<String, List<String>>();
    public static Map<class_1887, IngredientData> customIngredientsDataMap = new HashMap<class_1887, IngredientData>();
    public static final class_9139<ByteBuf, Map<String, List<String>>> MAP_CODEC;

    public static void createMap() {
        BetterEnchanting.LOGGER.info("Creating enchantement ingredient map for mod : BetterEnchanting");
    }

    public static void genMapFromJson(class_1937 world) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            File configFolder = new File(FabricLoader.getInstance().getConfigDir().resolve("better-enchanting").toString());
            configFolder.mkdirs();
            File configFile = new File(configFolder.getAbsolutePath() + "/enchantment_ingredients.json");
            if (configFile.createNewFile()) {
                BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));
                String temp = gson.toJson(defaultMap);
                writer.write(temp);
                writer.close();
            }
            JsonReader reader = new JsonReader((Reader)new FileReader(configFile));
            jsonMap = (Map)gson.fromJson(reader, Map.class);
            reader.close();
            Map<String, List<String>> missingEntries = ModEnchantIngredientMap.getEnchantNotPresentInConfig();
            if (!missingEntries.isEmpty()) {
                BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));
                jsonMap.putAll(missingEntries);
                String temp = gson.toJson(jsonMap);
                writer.append(temp);
                writer.close();
            }
            if (!world.field_9236) {
                ModEnchantIngredientMap.genMapFromJsonStringMap(world, jsonMap);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static void genMapFromJsonStringMap(class_1937 world, Map<String, List<String>> stringMap) {
        for (String key : stringMap.keySet()) {
            class_2960 enchantId = class_2960.method_60654((String)key);
            class_1887 enchantment = (class_1887)world.method_30349().method_30530(class_7924.field_41265).method_63535(enchantId);
            ArrayList ingredients = new ArrayList();
            stringMap.get(key).forEach(s -> {
                class_2960 itemId = class_2960.method_60654((String)s);
                class_1792 temp = (class_1792)class_7923.field_41178.method_63535(itemId);
                ingredients.add(temp != null ? temp : class_1802.field_8077);
            });
            ENCHANTMENT_INGREDIENTS_MAP.put(enchantment, ingredients);
            if (externalEnchantmentIngredientsMap.isEmpty()) continue;
            ENCHANTMENT_INGREDIENTS_MAP.putAll(externalEnchantmentIngredientsMap);
        }
    }

    public static void buildCustomIngredientDataMap(class_1937 world, List<IngredientData> ingredientData) {
        if (!world.field_9236) {
            for (IngredientData data : ingredientData) {
                class_1887 enchantment = (class_1887)world.method_30349().method_30530(class_7924.field_41265).method_63535(data.getEnchantment_id());
                customIngredientsDataMap.put(enchantment, data);
            }
        }
    }

    private static boolean addEnchantmentIngredient(class_2960 enchantmentId, List<class_1792> ingredients) {
        class_2378 enchantRegistry = Utils.getRegistryManager().method_30530(class_7924.field_41265);
        class_1887 enchantment = (class_1887)enchantRegistry.method_63535(enchantmentId);
        return ModEnchantIngredientMap.addEnchantmentIngredient(enchantment, ingredients);
    }

    public static boolean addEnchantmentIngredient(class_1887 enchantment, List<class_1792> ingredients) {
        if (enchantment == null) {
            return false;
        }
        externalEnchantmentIngredientsMap.put(enchantment, ingredients);
        return true;
    }

    private static List<String> listOfIdentifiers(List<class_1792> items) {
        ArrayList<String> list = new ArrayList<String>();
        for (class_1792 item : items) {
            list.add(class_7923.field_41178.method_10221((Object)item).toString());
        }
        return list;
    }

    private static Map<String, List<String>> getEnchantNotPresentInConfig() throws Exception {
        HashMap<String, List<String>> missingEntries = new HashMap<String, List<String>>();
        for (String enchant : defaultMap.keySet()) {
            if (jsonMap.keySet().contains(enchant)) continue;
            missingEntries.put(enchant, defaultMap.get(enchant));
        }
        return missingEntries;
    }

    public static class_1792 getIngredientOfLevel(class_1887 enchantment, int enchantmentLevel) {
        class_1792 ingredient = null;
        if (customIngredientsDataMap.containsKey(enchantment)) {
            ingredient = customIngredientsDataMap.get(enchantment).getIngredientForLevel(enchantmentLevel);
        }
        if (ingredient == null && ENCHANTMENT_INGREDIENTS_MAP.containsKey(enchantment) && ENCHANTMENT_INGREDIENTS_MAP.get(enchantment).size() > enchantmentLevel) {
            ingredient = ENCHANTMENT_INGREDIENTS_MAP.get(enchantment).get(enchantmentLevel);
        }
        return ingredient;
    }

    public static int getCostOfLevel(class_1887 enchantment, int level) {
        int cost = 0;
        if (customIngredientsDataMap.containsKey(enchantment)) {
            cost = customIngredientsDataMap.get(enchantment).getIngredientCostForLevel(level);
        }
        return cost;
    }

    public static void loadNeoEnchantConfig() {
        defaultMap.put("enchantplus:bow/accuracy_shot", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_ARROWS)));
        defaultMap.put("enchantplus:boots/agility", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8479, class_1802.field_8308, class_1802.field_8793, class_1802.field_49098, ModItems.ESSENCE_OF_AGILITY)));
        defaultMap.put("enchantplus:elytra/armored", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8076, class_1802.field_8773, class_1802.field_8281, ModItems.ESSENCE_OF_PROTECTION)));
        defaultMap.put("enchantplus:sword/attack_speed", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8463, ModItems.ESSENCE_OF_COMBAT)));
        defaultMap.put("enchantplus:helmet/auto_feed", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_FOOD)));
        defaultMap.put("enchantplus:tools/auto_smelt", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_SMELTING)));
        defaultMap.put("enchantplus:bow/breezing_arrow", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8399, class_1802.field_49098, ModItems.ESSENCE_OF_ARROWS)));
        defaultMap.put("enchantplus:helmet/bright_vision", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_SIGHT)));
        defaultMap.put("enchantplus:chestplate/builder_arm", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8465, class_1802.field_29025, class_1802.field_8270, class_1802.field_46791, ModItems.ESSENCE_OF_BUILDING)));
        defaultMap.put("enchantplus:bow/echo_shot", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_38746, class_1802.field_28101, ModItems.ESSENCE_OF_ARROWS)));
        defaultMap.put("enchantplus:pickaxe/experimental_bedrock_breaker", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_MINING)));
        defaultMap.put("enchantplus:bow/explosive_arrow", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8626, class_1802.field_8681, ModItems.ESSENCE_OF_ARROWS)));
        defaultMap.put("enchantplus:leggings/fast_swim", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_SEA)));
        defaultMap.put("enchantplus:sword/fear", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_FEAR)));
        defaultMap.put("enchantplus:armor/fury", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8479, class_1802.field_8371, class_1802.field_8556, ModItems.ESSENCE_OF_COMBAT)));
        defaultMap.put("enchantplus:boots/lava_walker", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8354, class_1802.field_8187, ModItems.ESSENCE_OF_FIRE)));
        defaultMap.put("enchantplus:leggings/leaping", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8249, ModItems.ESSENCE_OF_AGILITY)));
        defaultMap.put("enchantplus:sword/life_steal", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_16998, class_1802.field_8371, ModItems.ESSENCE_OF_VAMPIRISM)));
        defaultMap.put("enchantplus:armor/lifeplus", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8279, class_1802.field_8308, class_1802.field_8182, class_1802.field_8712, ModItems.ESSENCE_OF_HEALTH)));
        defaultMap.put("enchantplus:trident/magical_water", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_SEA)));
        defaultMap.put("enchantplus:tools/miningplus", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_MINING)));
        defaultMap.put("enchantplus:sword/poison_aspect", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8680, class_1802.field_8108, class_1802.field_8635, ModItems.ESSENCE_OF_POISON)));
        defaultMap.put("enchantplus:sword/pull", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_PULLING)));
        defaultMap.put("enchantplus:sword/reach", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8600, class_1802.field_27051, ModItems.ESSENCE_OF_REACH)));
        defaultMap.put("enchantplus:hoe/scyther", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_17528, class_1802.field_8303, ModItems.ESSENCE_OF_FORAGING)));
        defaultMap.put("enchantplus:boots/sky_walk", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_WIND)));
        defaultMap.put("enchantplus:pickaxe/spawner_touch", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_SILK_TOUCH)));
        defaultMap.put("enchantplus:boots/step_assist", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8291, class_1802.field_8073, ModItems.ESSENCE_OF_AGILITY)));
        defaultMap.put("enchantplus:bow/storm_arrow", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_27071, ModItems.ESSENCE_OF_ARROWS)));
        defaultMap.put("enchantplus:mace/striker", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_27051, ModItems.ESSENCE_OF_STRIKE)));
        defaultMap.put("enchantplus:axe/timber", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_FORAGING)));
        defaultMap.put("enchantplus:pickaxe/vein_miner", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_MINING)));
        defaultMap.put("enchantplus:armor/venom_protection", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_POISON_PROTECTION)));
        defaultMap.put("enchantplus:helmet/voidless", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_LEVITATION)));
        defaultMap.put("enchantplus:mace/wind_propulsion", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8626, class_1802.field_49098, ModItems.ESSENCE_OF_WIND)));
        defaultMap.put("enchantplus:sword/xp_boost", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8449, ModItems.MAGIC_SHARD_DULL, ModItems.ESSENCE_OF_EXPERIENCE)));
    }

    public static void loadBumblezoneConfig() {
        defaultMap.put(BzEnchantments.NEUROTOXINS.toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of((class_1792)BzItems.BEE_SOUP.get(), ModItems.ESSENCE_OF_NEUROTOXIN)));
        defaultMap.put(BzEnchantments.POTENT_POISON.toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8711, class_1802.field_8108, ModItems.ESSENCE_OF_POISON)));
        defaultMap.put(BzEnchantments.COMB_CUTTER.toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of((class_1792)BzItems.POROUS_HONEYCOMB.get(), ModItems.ESSENCE_OF_COMB_CUTTER)));
    }

    public static void loadDungeonsAndTavernsConfig() {
        defaultMap.put("nova_structures:antidote", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_POISON_PROTECTION)));
        defaultMap.put("nova_structures:ghasted", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8070, class_1802.field_8814, ModItems.ESSENCE_OF_ARROWS)));
        defaultMap.put("nova_structures:gravity", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8281, class_1802.field_23256, ModItems.ESSENCE_OF_GRAVITY)));
        defaultMap.put("nova_structures:illagers_bane", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_17520, class_1802.field_8371, class_1802.field_8773, class_1802.field_50140, ModItems.ESSENCE_OF_COMBAT)));
        defaultMap.put("nova_structures:traveler", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8071, class_1802.field_8073, ModItems.ESSENCE_OF_AGILITY)));
        defaultMap.put("nova_structures:outreach", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_17531, class_1802.field_49098, class_1802.field_17531, ModItems.ESSENCE_OF_REACH)));
        defaultMap.put("nova_structures:photosynthesis", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_PHOTOSYNTHESIS)));
        defaultMap.put("nova_structures:wax_wings", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_WINGS)));
        defaultMap.put("nova_structures:wither_coated", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_BUILDING)));
        defaultMap.put("nova_structures:multishot", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_MULTISHOT)));
        defaultMap.put("nova_structures:piercing", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8145, class_1802.field_8107, class_1802.field_8371, class_1802.field_8547, ModItems.ESSENCE_OF_PIERCING)));
        defaultMap.put("nova_structures:power", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_POWER)));
    }

    public static void loadReplantmentConfig() {
        defaultMap.put("replantment:replant", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_FORAGING)));
    }

    public static void loadDiversityConfig() {
        defaultMap.put("diversity:capacity", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8106, class_1802.field_8466, ModItems.ESSENCE_OF_CAPACITY)));
        defaultMap.put("diversity:refill", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_REFILL)));
    }

    private static Map<class_1887, List<class_1792>> getEnchantIngredientsMap() {
        return ENCHANTMENT_INGREDIENTS_MAP;
    }

    public static List<class_1792> getIngredientsOfEnchantment(class_1887 enchantment) {
        return ENCHANTMENT_INGREDIENTS_MAP.get(enchantment);
    }

    public static void loadTossUpConfig() {
        defaultMap.put("toss_up:toss_up", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8626, class_1802.field_8814, ModItems.ESSENCE_OF_EXPLOSION)));
    }

    public static void loadSpellPowerConfig() {
        defaultMap.put("spell_power:critical_chance", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8725, class_1802.field_8601, class_1802.field_8814, class_1802.field_8070, ModItems.ESSENCE_OF_CRITICAL_SPELL)));
        defaultMap.put("spell_power:critical_damage", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8054, class_1802.field_8759, class_1802.field_8626, class_1802.field_8814, ModItems.ESSENCE_OF_CRITICAL_SPELL)));
        defaultMap.put("spell_power:energize", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8725, class_1802.field_8056, class_1802.field_27071, class_1802.field_8547, ModItems.ESSENCE_OF_ENERGY)));
        defaultMap.put("spell_power:haste", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8479, class_1802.field_28659, class_1802.field_8687, class_1802.field_8801, ModItems.ESSENCE_OF_HASTE)));
        defaultMap.put("spell_power:magic_protection", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8620, class_1802.field_47009, class_1802.field_22421, ModItems.ESSENCE_OF_MAGIC_PROTECTION)));
        defaultMap.put("spell_power:soulfrost", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8543, class_1802.field_27876, class_1802.field_8081, class_1802.field_8178, ModItems.ESSENCE_OF_SOULFROST)));
        defaultMap.put("spell_power:spell_power", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8477, class_1802.field_8793, class_1802.field_8733, class_1802.field_8603, ModItems.ESSENCE_OF_SPELL_POWER)));
        defaultMap.put("spell_power:sunfire", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8713, class_1802.field_23842, class_1802.field_23842, class_1802.field_8183, ModItems.ESSENCE_OF_SUNFIRE)));
        defaultMap.put("spell_engine:spell_infinity", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_SPELL_INFINITY)));
    }

    public static void loadCombatRollConfig() {
        defaultMap.put("combat_roll:multi_roll", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8370, class_1802.field_8249, ModItems.ESSENCE_OF_MULTI_ROLL)));
        defaultMap.put("combat_roll:longfooted", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8660, class_1802.field_27051, class_1802.field_8056, ModItems.ESSENCE_OF_LONGFOOT)));
        defaultMap.put("combat_roll:acrobat", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8479, class_1802.field_8725, class_1802.field_8348, class_1802.field_8399, ModItems.ESSENCE_OF_AGILITY)));
    }

    public static void loadEnderscapeConfig() {
        defaultMap.put("enderscape:bundling", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_CAPACITY)));
        defaultMap.put("enderscape:lightspeed", ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8634, EnderscapeItems.NEBULITE, ModItems.ESSENCE_OF_ENERGY)));
        defaultMap.put("enderscape:transdimensional", ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_BUILDING)));
    }

    static {
        defaultMap.put(class_1893.field_9111.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_27022, class_1802.field_8620, class_1802.field_8477, ModItems.ESSENCE_OF_PROTECTION)));
        defaultMap.put(class_1893.field_9095.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8354, class_1802.field_8135, class_1802.field_8187, ModItems.ESSENCE_OF_FIRE_PROTECTION)));
        defaultMap.put(class_1893.field_9129.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8153, class_1802.field_8614, class_1802.field_49098, ModItems.ESSENCE_OF_FEATHER)));
        defaultMap.put(class_1893.field_9107.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8054, class_1802.field_8626, class_1802.field_8681, ModItems.ESSENCE_OF_BLAST_PROTECTION)));
        defaultMap.put(class_1893.field_9096.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8745, class_1802.field_8621, class_1802.field_8076, ModItems.ESSENCE_OF_PROJECTILE_PROTECTION)));
        defaultMap.put(class_1893.field_9127.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8323, class_1802.field_8161, ModItems.ESSENCE_OF_RESPIRATION)));
        defaultMap.put(class_1893.field_9105.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_SEA)));
        defaultMap.put(class_1893.field_9097.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_17520, class_1802.field_8108, ModItems.ESSENCE_OF_THORN)));
        defaultMap.put(class_1893.field_9128.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8429, class_1802.field_8535, ModItems.ESSENCE_OF_SEA)));
        defaultMap.put(class_1893.field_9122.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8178, ModItems.ESSENCE_OF_ICE)));
        defaultMap.put(class_1893.field_23071.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.SOUL_ESSENCE_1, ModItems.SOUL_ESSENCE_2, ModItems.SOUL_ESSENCE_3)));
        defaultMap.put(class_1893.field_38223.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_SNEAK_1, ModItems.ESSENCE_OF_SNEAK_2, ModItems.ESSENCE_OF_SNEAK_3)));
        defaultMap.put(class_1893.field_9118.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8145, class_1802.field_8371, class_1802.field_16311, class_1802.field_8477, ModItems.ESSENCE_OF_SHARPNESS)));
        defaultMap.put(class_1893.field_9123.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8511, class_1802.field_8801, class_1802.field_8155, class_1802.field_27063, ModItems.ESSENCE_OF_SMITE)));
        defaultMap.put(class_1893.field_9112.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8868, class_1802.field_8680, class_1802.field_8786, class_1802.field_8711, ModItems.ESSENCE_OF_ARTHROPODS)));
        defaultMap.put(class_1893.field_9121.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8249, ModItems.ESSENCE_OF_KNOCKBACK)));
        defaultMap.put(class_1893.field_9124.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8814, ModItems.ESSENCE_OF_FIRE)));
        defaultMap.put(class_1893.field_9110.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8687, class_1802.field_28652, ModItems.ESSENCE_OF_LOOTING)));
        defaultMap.put(class_1893.field_9115.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8076, class_1802.field_8281, ModItems.ESSENCE_OF_SWEEPING)));
        defaultMap.put(class_1893.field_9103.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8543, class_1802.field_8745, class_1802.field_8070, class_1802.field_8815, ModItems.ESSENCE_OF_POWER)));
        defaultMap.put(class_1893.field_9116.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_28866, ModItems.ESSENCE_OF_PUNCH)));
        defaultMap.put(class_1893.field_9126.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_FIRE)));
        defaultMap.put(class_1893.field_9125.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_ARROWS)));
        defaultMap.put(class_1893.field_9131.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8145, class_1802.field_8463, class_1802.field_8281, class_1802.field_8233, ModItems.ESSENCE_OF_EFFICIENCY)));
        defaultMap.put(class_1893.field_9099.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_SILK_TOUCH)));
        defaultMap.put(class_1893.field_9130.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8494, class_1802.field_8733, ModItems.ESSENCE_OF_FORTUNE)));
        defaultMap.put(class_1893.field_9114.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8864, class_1802.field_8207, ModItems.ESSENCE_OF_SEA_LUCK)));
        defaultMap.put(class_1893.field_9100.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8184, class_1802.field_8229, ModItems.ESSENCE_OF_LURE)));
        defaultMap.put(class_1893.field_9119.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8477, class_1802.field_22421, ModItems.ESSENCE_OF_UNBREAKING)));
        defaultMap.put(class_1893.field_9101.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_MENDING)));
        defaultMap.put(class_1893.field_9117.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_CHANNELING)));
        defaultMap.put(class_1893.field_9106.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_28042, class_1802.field_8076, class_1802.field_8155, class_1802.field_8802, ModItems.ESSENCE_OF_IMPALING)));
        defaultMap.put(class_1893.field_9120.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8242, class_1802.field_8071, ModItems.ESSENCE_OF_LOYALTY)));
        defaultMap.put(class_1893.field_9104.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8705, class_1802.field_8864, ModItems.ESSENCE_OF_RIPTIDE)));
        defaultMap.put(class_1893.field_9108.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(ModItems.ESSENCE_OF_MULTISHOT)));
        defaultMap.put(class_1893.field_9132.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8145, class_1802.field_8107, class_1802.field_8236, ModItems.ESSENCE_OF_PIERCING)));
        defaultMap.put(class_1893.field_9098.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_27063, class_1802.field_8801, ModItems.ESSENCE_OF_QUICK_CHARGE)));
        defaultMap.put(class_1893.field_50157.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_20391, class_1802.field_28866, class_1802.field_8281, class_1802.field_23256, ModItems.ESSENCE_OF_DENSITY)));
        defaultMap.put(class_1893.field_50158.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_8620, class_1802.field_20389, class_1802.field_8626, ModItems.ESSENCE_OF_BREACH)));
        defaultMap.put(class_1893.field_50159.method_29177().toString(), ModEnchantIngredientMap.listOfIdentifiers(List.of(class_1802.field_17531, class_1802.field_49098, ModItems.ESSENCE_OF_WIND)));
        MAP_CODEC = new class_9139<ByteBuf, Map<String, List<String>>>(){

            public Map<String, List<String>> decode(ByteBuf byteBuf) {
                Gson gson = new GsonBuilder().create();
                int length = byteBuf.readInt();
                byte[] bytes = new byte[length];
                byteBuf.readBytes(bytes);
                String message = new String(bytes, Charsets.UTF_8);
                Type mapType = new TypeToken<Map<String, List<String>>>(this){}.getType();
                return (Map)gson.fromJson(message, mapType);
            }

            public void encode(ByteBuf byteBuf, Map<String, List<String>> blockPos) {
                Gson gson = new GsonBuilder().create();
                String json = gson.toJson(jsonMap);
                byte[] bytes = json.getBytes(Charsets.UTF_8);
                byteBuf.writeInt(bytes.length);
                byteBuf.writeBytes(bytes);
            }
        };
    }
}

