/*
 * Decompiled with CFR 0.152.
 */
package bluenightfury46.dev.bloodMoon;

import bluenightfury46.dev.bloodMoon.ArmourData;
import bluenightfury46.dev.bloodMoon.Moon;
import bluenightfury46.dev.bloodMoon.MoonCommands;
import bluenightfury46.dev.bloodMoon.MoonTabComplete;
import bluenightfury46.dev.bloodMoon.ReloadCommand;
import bluenightfury46.dev.bloodMoon.TriggerBloodMoon;
import bluenightfury46.dev.bloodMoon.events.BlockBedStuff;
import bluenightfury46.dev.bloodMoon.events.MoonEntitySpawnEv;
import bluenightfury46.dev.bloodMoon.gui.EquipmentGUI;
import bluenightfury46.dev.bloodMoon.gui.GUIEvents;
import java.io.File;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class BloodMoon
extends JavaPlugin {
    @NotNull
    public static BloodMoon plugin;
    @NotNull
    public static ArmourData data;
    @NotNull
    public static double BLOODMOON_CHANCE;
    @NotNull
    public static boolean BLOODMOON_ALLOWSLEEP;
    @NotNull
    public static boolean DO_BLOODMOONS;
    @NotNull
    public static String BLOODMOON_SUBTITLE;
    @NotNull
    public static String BLOODMOON_TITLE;
    @NotNull
    public static String BLOODMOON_CHATMESSAGE;
    @NotNull
    public static String BED_ENTER_FAIL_MESSAGE;
    @NotNull
    public static HashMap<World, Boolean> ACTIVE_BLOODMOON;

    public void onEnable() {
        plugin = this;
        this.loadConfig();
        EquipmentGUI.genCONFIG_INVENTORY();
        this.getCommand("setequipement").setExecutor((CommandExecutor)new MoonCommands());
        this.getCommand("setequipement").setTabCompleter((TabCompleter)new MoonTabComplete());
        this.getCommand("reload-bloodmoon").setExecutor((CommandExecutor)new ReloadCommand());
        this.getCommand("trigger").setExecutor((CommandExecutor)new TriggerBloodMoon());
        this.getCommand("trigger").setTabCompleter((TabCompleter)new MoonTabComplete());
        Bukkit.getPluginManager().registerEvents((Listener)new MoonEntitySpawnEv(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BlockBedStuff(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GUIEvents(), (Plugin)this);
    }

    void loadConfig() {
        File file = new File(this.getDataFolder(), "data.json");
        data = Moon.jsonInit(file);
        this.saveDefaultConfig();
        BLOODMOON_CHANCE = this.getConfig().getDouble("bloodmoon-chance");
        if (BLOODMOON_CHANCE <= 0.0) {
            BLOODMOON_CHANCE = 1.0;
            this.getLogger().warning("bloodmoon-chance value can not be less than, or equal to zero! Defaulting to 1. If this is a mistake, please modify the config.yml and change the value back to an appropriate value");
        }
        if (BLOODMOON_CHANCE > 100.0) {
            BLOODMOON_CHANCE = 100.0;
            this.getLogger().warning("bloodmoon-chance value can not greater than 100! Defaulting to 100. If this is a mistake, please modify the config.yml and change the value back to an appropriate value");
        }
        try {
            BLOODMOON_ALLOWSLEEP = this.getConfig().getBoolean("allow-sleep");
        }
        catch (NullPointerException e) {
            plugin.getLogger().warning("WARNING! allow-sleep in the config.yml is missing, please add it... Defaulting to false");
            BLOODMOON_ALLOWSLEEP = false;
        }
        try {
            BED_ENTER_FAIL_MESSAGE = this.getConfig().getString("messages.bloodmoon-bedenter");
        }
        catch (NullPointerException e) {
            plugin.getLogger().warning("WARNING! messages.bloodmoon-bedenter in the config.yml is missing, please add it... Applying default value");
            BED_ENTER_FAIL_MESSAGE = String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "You can not enter the bed during a blood moon... Good luck";
        }
        BLOODMOON_TITLE = this.getConfig().getString("messages.blood-moon-title-message");
        BLOODMOON_SUBTITLE = this.getConfig().getString("messages.blood-moon-subtitle-message");
        BLOODMOON_CHATMESSAGE = this.getConfig().getString("messages.blood-moon-chat-message");
        DO_BLOODMOONS = this.getConfig().getBoolean("do-bloodmoons");
        try {
            if (DO_BLOODMOONS && !DO_BLOODMOONS) {
                DO_BLOODMOONS = true;
                this.getLogger().warning("Warning! do-bloodmoons failed to load... Defaulting to true");
            }
        }
        catch (NullPointerException e) {
            DO_BLOODMOONS = true;
            this.getLogger().warning("Warning! do-bloodmoons failed to load... Defaulting to true");
        }
    }

    public void onDisable() {
        this.saveDefaultConfig();
        File JSON_FILE = new File(this.getDataFolder(), "data.json");
        Moon.jsonSave(data, JSON_FILE);
        for (World world : this.getServer().getWorlds()) {
            for (LivingEntity livingEntity : world.getLivingEntities()) {
                if (!livingEntity.getType().equals((Object)EntityType.ZOMBIE)) continue;
                MoonEntitySpawnEv.removeItems(livingEntity);
            }
        }
    }

    static {
        BLOODMOON_CHANCE = 100.0;
        BLOODMOON_ALLOWSLEEP = false;
        DO_BLOODMOONS = true;
        BLOODMOON_SUBTITLE = "\u00a74Mobs you find will have stronger armour\u00a74";
        BLOODMOON_TITLE = "\u00a7cThe Blood Moon Rises Once Again!\u00a7c";
        BLOODMOON_CHATMESSAGE = "\u00a74As the blood moon rises the countless monsters band together, you encounter mobs with stronger gear...\u00a74";
        BED_ENTER_FAIL_MESSAGE = String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "You can not enter the bed during a blood moon... Good luck";
        ACTIVE_BLOODMOON = new HashMap();
    }
}

