/*
 * Decompiled with CFR 0.152.
 */
package bluenightfury46.dev.bloodMoon;

import bluenightfury46.dev.bloodMoon.ArmourData;
import bluenightfury46.dev.bloodMoon.BloodMoon;
import bluenightfury46.dev.bloodMoon.exceptions.FileNotFoundOrGenerated;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.ReadOnlyFileSystemException;
import java.util.Scanner;

public class Moon {
    static final String JSON_FILENAME = "data.json";

    public static void preppify() {
        BloodMoon.BED_ENTER_FAIL_MESSAGE = "\u00a7dYou can not enter a bed during a blood-moon, sorry bestie...\u2728\u00a7d";
        BloodMoon.BLOODMOON_SUBTITLE = "\u00a78The preppy moon slays once again \u2728\u00a78";
        BloodMoon.BLOODMOON_TITLE = "\u00a7dPreppy!\u00a7d";
        BloodMoon.BLOODMOON_CHATMESSAGE = "\u00a7d\u00a7d\ud83c\udf80Yars slay queen!!!\u2728\u00a7d";
    }

    public static double percentChance_to_fractChance(double percentage) {
        return 1.0 / (percentage / 100.0);
    }

    public static int getRandomNumber(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    public static ArmourData jsonInit(File JSON_FILE) {
        try {
            if (JSON_FILE != null) {
                if (!JSON_FILE.exists()) {
                    throw new FileNotFoundOrGenerated();
                }
                Scanner scan = new Scanner(JSON_FILE);
                Object tempstr = "";
                while (scan.hasNextLine()) {
                    tempstr = (String)tempstr + scan.nextLine();
                }
                scan.close();
                if (((String)tempstr).isEmpty()) {
                    return new ArmourData(ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR);
                }
                ArmourData data = (ArmourData)new Gson().fromJson((String)tempstr, ArmourData.class);
                return data;
            }
        }
        catch (NullPointerException e) {
            BloodMoon.plugin.getLogger().severe("JsonFileNullError, plugin shutting down");
            return new ArmourData(ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR);
        }
        catch (FileNotFoundOrGenerated e) {
            return new ArmourData(ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR);
        }
        catch (FileNotFoundException | ExceptionInInitializerError e) {
            return new ArmourData(ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR);
        }
        return new ArmourData(ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR, ArmourData.AIR);
    }

    public static void jsonSave(ArmourData toJson, File JSON_FILE) {
        try {
            if (JSON_FILE != null) {
                if (!JSON_FILE.exists()) {
                    JSON_FILE.createNewFile();
                }
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String str_data = gson.toJson((Object)toJson);
                FileWriter writer = new FileWriter(JSON_FILE);
                writer.write(str_data);
                writer.close();
            }
        }
        catch (NullPointerException e) {
            BloodMoon.plugin.getLogger().severe("JsonFileNullError, plugin shutting down");
        }
        catch (ReadOnlyFileSystemException e) {
            BloodMoon.plugin.getLogger().severe("Json file is read only... Shutting down (How did you do that then?)");
        }
        catch (FileNotFoundException e) {
            JSON_FILE.mkdirs();
        }
        catch (IOException e) {
            BloodMoon.plugin.getLogger().severe("Failed to create JSON file...");
        }
    }
}

