/*
 * Decompiled with CFR 0.152.
 */
package bluenightfury46.dev.bloodMoon.events;

import bluenightfury46.dev.bloodMoon.BloodMoon;
import bluenightfury46.dev.bloodMoon.Moon;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MoonEntitySpawnEv
implements Listener {
    @NotNull
    final long FULL_MOON = 0L;

    public long getPhase(World w) {
        return w.getFullTime() / 24000L;
    }

    public boolean isValidHelmet(LivingEntity e) {
        return e.getEquipment().getHelmet().getType().equals((Object)Material.AIR);
    }

    public boolean isValidChestplate(LivingEntity e) {
        return e.getEquipment().getChestplate().getType().equals((Object)Material.AIR);
    }

    public boolean isValidLeggings(LivingEntity e) {
        return e.getEquipment().getLeggings().getType().equals((Object)Material.AIR);
    }

    public boolean isValidBoots(LivingEntity e) {
        return e.getEquipment().getBoots().getType().equals((Object)Material.AIR);
    }

    public boolean isValidOffhand(LivingEntity e) {
        return e.getEquipment().getItemInOffHand().getType().equals((Object)Material.AIR);
    }

    public boolean isValidMainhand(LivingEntity e) {
        return e.getEquipment().getItemInMainHand().getType().equals((Object)Material.AIR);
    }

    public static void removeItems(LivingEntity e) {
        if (e.getEquipment().getHelmet().getType().equals((Object)BloodMoon.data.HELMET.toItemStack().getType())) {
            e.getEquipment().setHelmet(ItemStack.of((Material)Material.AIR));
        }
        if (e.getEquipment().getChestplate().getType().equals((Object)BloodMoon.data.CHESTPLATE.toItemStack().getType())) {
            e.getEquipment().setChestplate(ItemStack.of((Material)Material.AIR));
        }
        if (e.getEquipment().getLeggings().getType().equals((Object)BloodMoon.data.LEGGINGS.toItemStack().getType())) {
            e.getEquipment().setLeggings(ItemStack.of((Material)Material.AIR));
        }
        if (e.getEquipment().getBoots().getType().equals((Object)BloodMoon.data.BOOTS.toItemStack().getType())) {
            e.getEquipment().setBoots(ItemStack.of((Material)Material.AIR));
        }
        if (e.getEquipment().getItemInMainHand().getType().equals((Object)BloodMoon.data.MAINHAND.toItemStack().getType())) {
            e.getEquipment().setItemInMainHand(ItemStack.of((Material)Material.AIR));
        }
        if (e.getEquipment().getItemInOffHand().getType().equals((Object)BloodMoon.data.OFFHAND.toItemStack().getType())) {
            e.getEquipment().setItemInOffHand(ItemStack.of((Material)Material.AIR));
        }
    }

    void BLOODMOON_ACTIVATE(LivingEntity e) {
        if (this.isValidHelmet(e)) {
            Objects.requireNonNull(e.getEquipment()).setHelmet(BloodMoon.data.HELMET.toItemStack());
            e.getEquipment().setHelmetDropChance(0.0f);
        }
        if (this.isValidChestplate(e)) {
            Objects.requireNonNull(e.getEquipment()).setChestplate(BloodMoon.data.CHESTPLATE.toItemStack());
            e.getEquipment().setChestplateDropChance(0.0f);
        }
        if (this.isValidLeggings(e)) {
            Objects.requireNonNull(e.getEquipment()).setLeggings(BloodMoon.data.LEGGINGS.toItemStack());
            e.getEquipment().setLeggingsDropChance(0.0f);
        }
        if (this.isValidBoots(e)) {
            Objects.requireNonNull(e.getEquipment()).setBoots(BloodMoon.data.BOOTS.toItemStack());
            e.getEquipment().setBootsDropChance(0.0f);
        }
        if (this.isValidMainhand(e)) {
            Objects.requireNonNull(e.getEquipment()).setItemInMainHand(BloodMoon.data.MAINHAND.toItemStack());
            e.getEquipment().setItemInMainHandDropChance(0.0f);
        }
        if (this.isValidOffhand(e)) {
            Objects.requireNonNull(e.getEquipment()).setItemInOffHand(BloodMoon.data.OFFHAND.toItemStack());
            e.getEquipment().setItemInOffHandDropChance(0.0f);
        }
    }

    @EventHandler
    public void spawn_event(EntitySpawnEvent event) {
        if (BloodMoon.DO_BLOODMOONS) {
            if (!event.getEntityType().equals((Object)EntityType.ZOMBIE)) {
                return;
            }
            World world = event.getEntity().getWorld();
            if (world.getTime() < 23000L && world.getTime() > 13000L) {
                if (!BloodMoon.ACTIVE_BLOODMOON.containsKey(world)) {
                    int max = (int)Moon.percentChance_to_fractChance(BloodMoon.BLOODMOON_CHANCE);
                    int num = Moon.getRandomNumber(0, max);
                    if (0 == num && this.getPhase(world) == 0L) {
                        BloodMoon.ACTIVE_BLOODMOON.put(world, true);
                        for (Player player : event.getEntity().getWorld().getPlayers()) {
                            player.sendMessage(BloodMoon.BLOODMOON_CHATMESSAGE);
                            player.sendTitle(BloodMoon.BLOODMOON_TITLE, BloodMoon.BLOODMOON_SUBTITLE);
                            event.getEntity().getWorld().playSound(player.getLocation(), Sound.ENTITY_WITHER_SPAWN, 1.2f, 1.0f);
                        }
                    } else {
                        BloodMoon.ACTIVE_BLOODMOON.put(world, false);
                    }
                }
                if (BloodMoon.ACTIVE_BLOODMOON.get(world).equals(true)) {
                    this.BLOODMOON_ACTIVATE((LivingEntity)event.getEntity());
                }
            } else {
                try {
                    if (BloodMoon.ACTIVE_BLOODMOON.containsKey(world)) {
                        BloodMoon.ACTIVE_BLOODMOON.remove(world);
                        for (LivingEntity livingEntity : world.getLivingEntities()) {
                            if (!livingEntity.getType().equals((Object)EntityType.ZOMBIE)) continue;
                            MoonEntitySpawnEv.removeItems(livingEntity);
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }
}

