/*
 * Decompiled with CFR 0.152.
 */
package bluenightfury46.dev.bloodMoon.gui;

import bluenightfury46.dev.bloodMoon.BloodMoon;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class EquipmentGUI {
    public static final int INVENTORY_COLUMNS = 9;
    public static final int INVENTORY_ROWS = 3;
    public static final String INVENTORY_TITLE = "Blood Moon";
    public static final int HELMET_POS = 10;
    public static final int CHESTPLATE_POS = 11;
    public static final int LEGGINGS_POS = 12;
    public static final int BOOTS_POS = 13;
    public static final int MAINHAND_POS = 14;
    public static final int OFFHAND_POS = 15;
    public static final int APPLY_POS = 17;
    public static final int CANCEL_POS = 26;
    public static final Material DEFAULT_MATERIAL = Material.WHITE_STAINED_GLASS;
    @NotNull
    public static Inventory inventory;

    public static boolean isHelmet(Material m) {
        switch (m) {
            case LEATHER_HELMET: 
            case CHAINMAIL_HELMET: 
            case GOLDEN_HELMET: 
            case IRON_HELMET: 
            case DIAMOND_HELMET: 
            case NETHERITE_HELMET: 
            case TURTLE_HELMET: 
            case PLAYER_HEAD: 
            case WITHER_SKELETON_SKULL: 
            case SKELETON_SKULL: 
            case CREEPER_HEAD: 
            case DRAGON_HEAD: 
            case ZOMBIE_HEAD: {
                return true;
            }
        }
        return false;
    }

    public static boolean isChestplate(Material m) {
        switch (m) {
            case LEATHER_CHESTPLATE: 
            case CHAINMAIL_CHESTPLATE: 
            case GOLDEN_CHESTPLATE: 
            case IRON_CHESTPLATE: 
            case DIAMOND_CHESTPLATE: 
            case NETHERITE_CHESTPLATE: 
            case ELYTRA: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLeggings(Material m) {
        switch (m) {
            case LEATHER_LEGGINGS: 
            case CHAINMAIL_LEGGINGS: 
            case GOLDEN_LEGGINGS: 
            case IRON_LEGGINGS: 
            case DIAMOND_LEGGINGS: 
            case NETHERITE_LEGGINGS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBoots(Material m) {
        switch (m) {
            case LEATHER_BOOTS: 
            case CHAINMAIL_BOOTS: 
            case GOLDEN_BOOTS: 
            case IRON_BOOTS: 
            case DIAMOND_BOOTS: 
            case NETHERITE_BOOTS: {
                return true;
            }
        }
        return false;
    }

    public static void setHelmet(ItemStack i) {
        inventory.setItem(10, i);
    }

    public static void setChestplate(ItemStack i) {
        inventory.setItem(11, i);
    }

    public static void setLeggings(ItemStack i) {
        inventory.setItem(12, i);
    }

    public static void setBoots(ItemStack i) {
        inventory.setItem(13, i);
    }

    public static void setMainhand(ItemStack i) {
        inventory.setItem(14, i);
    }

    public static void setOffhand(ItemStack i) {
        inventory.setItem(15, i);
    }

    public static ItemStack getOffhandItem() {
        return inventory.getItem(15);
    }

    public static ItemStack getMainhandItem() {
        return inventory.getItem(14);
    }

    public static ItemStack getHelmetItem() {
        return inventory.getItem(10);
    }

    public static ItemStack getChestplateItem() {
        return inventory.getItem(11);
    }

    public static ItemStack getLeggingsItem() {
        return inventory.getItem(12);
    }

    public static ItemStack getBootsItem() {
        return inventory.getItem(13);
    }

    @NotNull
    public static void genCONFIG_INVENTORY() {
        inventory = BloodMoon.plugin.getServer().createInventory(null, 27, INVENTORY_TITLE);
        EquipmentGUI.reloadItems();
    }

    public static void reloadItems() {
        inventory.setItem(10, EquipmentGUI.genGUIItem(BloodMoon.data.HELMET.toItemStack().getType(), 1, "Helmet", "Set the blood moon helmet"));
        inventory.setItem(11, EquipmentGUI.genGUIItem(BloodMoon.data.CHESTPLATE.toItemStack().getType(), 1, "Chestplate", "Set the blood moon chestplate"));
        inventory.setItem(12, EquipmentGUI.genGUIItem(BloodMoon.data.LEGGINGS.toItemStack().getType(), 1, "Leggings", "Set the blood moon leggings"));
        inventory.setItem(13, EquipmentGUI.genGUIItem(BloodMoon.data.BOOTS.toItemStack().getType(), 1, "Boots", "Set the blood moon boots"));
        inventory.setItem(14, EquipmentGUI.genGUIItem(BloodMoon.data.MAINHAND.toItemStack().getType(), 1, "Mainhand", "Set the blood moon mainhand"));
        inventory.setItem(15, EquipmentGUI.genGUIItem(BloodMoon.data.OFFHAND.toItemStack().getType(), 1, "Offhand", "Set the blood moon offhand"));
        inventory.setItem(17, EquipmentGUI.genGUIItem(Material.LIME_STAINED_GLASS, 1, String.valueOf(ChatColor.GREEN) + "Apply", "Set the blood moon mainhand"));
        inventory.setItem(26, EquipmentGUI.genGUIItem(Material.BARRIER, 1, String.valueOf(ChatColor.RED) + "Cancel", "Set the blood moon offhand"));
    }

    @NotNull
    public static Inventory getCONFIG_INVENTORY() {
        Inventory inventory = EquipmentGUI.inventory;
        if (inventory == null) {
            EquipmentGUI.$$$reportNull$$$0(0);
        }
        return inventory;
    }

    public static ItemStack genGUIItem(@NotNull Material m, int count, String name, String ... Lore) {
        ItemStack itemStack;
        if (m == null) {
            EquipmentGUI.$$$reportNull$$$0(1);
        }
        if ((itemStack = new ItemStack(m, count)).getType().isAir() || itemStack.getType() == null) {
            itemStack = new ItemStack(DEFAULT_MATERIAL, count);
        }
        try {
            ItemMeta meta = itemStack.getItemMeta();
            meta.setItemName(name);
            meta.setLore(List.of(Lore));
            itemStack.setItemMeta(meta);
        }
        catch (NullPointerException e) {
            itemStack.setType(DEFAULT_MATERIAL);
            try {
                ItemMeta meta = itemStack.getItemMeta();
                meta.setItemName(name);
                meta.setLore(List.of(Lore));
                itemStack.setItemMeta(meta);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return itemStack;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bluenightfury46/dev/bloodMoon/gui/EquipmentGUI";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCONFIG_INVENTORY";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "bluenightfury46/dev/bloodMoon/gui/EquipmentGUI";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "genGUIItem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

