/*
 * Decompiled with CFR 0.152.
 */
package bluenightfury46.dev.bloodMoon.json;

import bluenightfury46.dev.bloodMoon.json.JsonEnchantments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class JsonItemstack {
    @NotNull
    public String material_name;
    @NotNull
    public ArrayList<JsonEnchantments> enchantments = new ArrayList();

    public JsonItemstack(ItemStack item) {
        this.material_name = item.getType().name();
        this.enchantments.add(new JsonEnchantments(Enchantment.BINDING_CURSE, 1));
        this.enchantments.remove(new JsonEnchantments(Enchantment.BINDING_CURSE, 1));
        if (item.getEnchantments().values().size() > 0) {
            Set enchantment = item.getEnchantments().keySet();
            for (Enchantment e : enchantment) {
                this.enchantments.add(new JsonEnchantments(e, (Integer)item.getEnchantments().get(e)));
            }
        }
    }

    public ItemStack toItemStack() {
        ItemStack return_item = new ItemStack(Material.getMaterial((String)this.material_name));
        try {
            if (this.enchantments.isEmpty()) {
                return return_item;
            }
        }
        catch (NullPointerException e) {
            return return_item;
        }
        for (JsonEnchantments enchant : this.enchantments) {
            return_item.addUnsafeEnchantment(enchant.toEnchant(), enchant.LEVEL);
        }
        return return_item;
    }

    public Map<Enchantment, Integer> asEnchantments() {
        HashMap<Enchantment, Integer> enchantMap = new HashMap<Enchantment, Integer>();
        for (JsonEnchantments enchant : this.enchantments) {
            enchantMap.put(enchant.toEnchant(), enchant.LEVEL);
        }
        return enchantMap;
    }
}

