/*
 * Decompiled with CFR 0.152.
 */
package bluenightfury46.dev.bloodMoon;

import bluenightfury46.dev.bloodMoon.ArmourData;
import bluenightfury46.dev.bloodMoon.Moon;
import bluenightfury46.dev.bloodMoon.MoonCommands;
import bluenightfury46.dev.bloodMoon.MoonTabComplete;
import bluenightfury46.dev.bloodMoon.ReloadCommand;
import bluenightfury46.dev.bloodMoon.TriggerBloodMoon;
import bluenightfury46.dev.bloodMoon.events.MoonEntitySpawnEv;
import java.io.File;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class BloodMoon
extends JavaPlugin {
    @NotNull
    public static BloodMoon plugin;
    @NotNull
    public static ArmourData data;
    @NotNull
    public static double BLOODMOON_CHANCE;
    @NotNull
    public static boolean DO_BLOODMOONS;
    @NotNull
    public static String BLOODMOON_SUBTITLE;
    @NotNull
    public static String BLOODMOON_TITLE;
    @NotNull
    public static String BLOODMOON_CHATMESSAGE;
    @NotNull
    public static HashMap<World, Boolean> ACTIVE_BLOODMOON;

    public void onEnable() {
        plugin = this;
        this.loadConfig();
        this.getCommand("setequipement").setExecutor((CommandExecutor)new MoonCommands());
        this.getCommand("setequipement").setTabCompleter((TabCompleter)new MoonTabComplete());
        this.getCommand("reload-bloodmoon").setExecutor((CommandExecutor)new ReloadCommand());
        this.getCommand("trigger").setExecutor((CommandExecutor)new TriggerBloodMoon());
        this.getCommand("trigger").setTabCompleter((TabCompleter)new MoonTabComplete());
        Bukkit.getPluginManager().registerEvents((Listener)new MoonEntitySpawnEv(), (Plugin)this);
    }

    void loadConfig() {
        File file = new File(this.getDataFolder(), "data.json");
        data = Moon.jsonInit(file);
        this.saveDefaultConfig();
        BLOODMOON_CHANCE = this.getConfig().getDouble("bloodmoon-chance");
        if (BLOODMOON_CHANCE <= 0.0) {
            BLOODMOON_CHANCE = 1.0;
            this.getLogger().warning("bloodmoon-chance value can not be less than, or equal to zero! Defaulting to 1. If this is a mistake, please modify the config.yml and change the value back to an appropriate value");
        }
        if (BLOODMOON_CHANCE > 100.0) {
            BLOODMOON_CHANCE = 100.0;
            this.getLogger().warning("bloodmoon-chance value can not greater than 100! Defaulting to 100. If this is a mistake, please modify the config.yml and change the value back to an appropriate value");
        }
        BLOODMOON_TITLE = this.getConfig().getString("messages.blood-moon-title-message");
        BLOODMOON_SUBTITLE = this.getConfig().getString("messages.blood-moon-subtitle-message");
        BLOODMOON_CHATMESSAGE = this.getConfig().getString("messages.blood-moon-chat-message");
        DO_BLOODMOONS = this.getConfig().getBoolean("do-bloodmoons");
        try {
            if (DO_BLOODMOONS && !DO_BLOODMOONS) {
                DO_BLOODMOONS = true;
                this.getLogger().warning("Warning! do-bloodmoons failed to load... Defaulting to true");
            }
        }
        catch (NullPointerException e) {
            DO_BLOODMOONS = true;
            this.getLogger().warning("Warning! do-bloodmoons failed to load... Defaulting to true");
        }
    }

    public void onDisable() {
        File JSON_FILE = new File(this.getDataFolder(), "data.json");
        Moon.jsonSave(data, JSON_FILE);
    }

    static {
        BLOODMOON_CHANCE = 100.0;
        DO_BLOODMOONS = true;
        BLOODMOON_SUBTITLE = "\u00a74Mobs you find will have stronger armour\u00a74";
        BLOODMOON_TITLE = "\u00a7cThe Blood Moon Rises Once Again!\u00a7c";
        BLOODMOON_CHATMESSAGE = "\u00a74As the blood moon rises the countless monsters band together, you encounter mobs with stronger gear...\u00a74";
        ACTIVE_BLOODMOON = new HashMap();
    }
}

