/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.common;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.core.LiteLoader;
import com.thevoxelbox.common.interfaces.ITimeHandler;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class LiteModVoxelCommon
implements LiteMod {
    public static final String VERSION = "2.3.1";
    public static final bqx GUIPARTS = new bqx("voxelcommon", "textures/gui/guiparts.png");
    private static String NAME = "VoxelLib";
    private static List<ITimeHandler> timeHandlers = new LinkedList<ITimeHandler>();

    public String getName() {
        return NAME;
    }

    public String getVersion() {
        return VERSION;
    }

    public void init(File configPath) {
        try {
            Class<?> voxelPacketListenerClass = Class.forName("com.thevoxelbox.voxelpacket.client.VoxelPacketListener");
            LiteMod voxelPacketListener = (LiteMod)voxelPacketListenerClass.newInstance();
            voxelPacketListener.init(configPath);
            LiteLoader.getInterfaceManager().registerListener((Listener)voxelPacketListener);
            NAME = NAME + " + VoxelPacket";
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public void upgradeSettings(String version, File configPath, File oldConfigPath) {
    }

    public static void registerTimeHandler(ITimeHandler timeHandler) {
        if (!timeHandlers.contains(timeHandler)) {
            timeHandlers.add(timeHandler);
        }
    }

    public static void handleTimeUpdate(fb netHandler, ih packet) {
        LiteModVoxelCommon.updateTime(netHandler, packet.c(), packet.d());
    }

    public static void updateTime(long totalTime, long worldTime) {
        bao mc = bao.B();
        if (mc.h != null && mc.h.a != null) {
            LiteModVoxelCommon.updateTime((fb)mc.h.a, totalTime, worldTime);
        }
    }

    public static void updateTime(fb netHandler, long totalTime, long worldTime) {
        boolean frozen = worldTime < 0L;
        worldTime = Math.abs(worldTime);
        long inTotalTime = totalTime;
        long inWorldTime = worldTime;
        for (ITimeHandler timeHandler : timeHandlers) {
            timeHandler.onTimeUpdate(totalTime, worldTime);
        }
        for (ITimeHandler timeHandler : timeHandlers) {
            if (timeHandler.isFreezingTime()) {
                frozen = true;
                totalTime = timeHandler.getFrozenTotalTime(inTotalTime);
                worldTime = timeHandler.getFrozenWorldTime(inWorldTime);
                break;
            }
            worldTime += timeHandler.getTimeOffset();
        }
        ((fv)netHandler).a(new ih(totalTime, worldTime, !frozen));
    }
}

