/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.common.net;

import com.thevoxelbox.common.net.IDownloadCompletedWatcher;
import com.thevoxelbox.common.net.IDownloadProgressWatcher;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

public class HttpFileRetriever
extends Thread {
    private final IDownloadProgressWatcher progressWatcher;
    private final IDownloadCompletedWatcher completedWatcher;
    private final String sourceUrl;
    private final Map<String, String> requestHeaders;
    private final File localFile;
    private final int maxFileSize;
    private volatile boolean cancelled;

    private HttpFileRetriever(String sourceUrl, Map<String, String> headers, File destinationFile, int maxFileSize, IDownloadProgressWatcher progressWatcher, IDownloadCompletedWatcher completedWatcher) {
        this.setDaemon(true);
        this.sourceUrl = sourceUrl;
        this.requestHeaders = headers;
        this.localFile = destinationFile;
        this.maxFileSize = maxFileSize;
        this.progressWatcher = progressWatcher;
        this.completedWatcher = completedWatcher;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block60: {
            block59: {
                block58: {
                    block56: {
                        block57: {
                            block55: {
                                http = null;
                                httpInputStream = null;
                                fileOutputStream = null;
                                if (this.progressWatcher != null) {
                                    this.progressWatcher.resetProgressAndMessage("Downloading File");
                                    this.progressWatcher.resetProgressAndWorkingMessage("Making Request...");
                                }
                                buffer = new byte[4096];
                                http = new URL(this.sourceUrl).openConnection();
                                http.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
                                progress = 0.0f;
                                progressMax = this.requestHeaders.entrySet().size();
                                for (Map.Entry<String, String> header : this.requestHeaders.entrySet()) {
                                    http.setRequestProperty(header.getKey(), header.getValue());
                                    if (this.progressWatcher == null) continue;
                                    this.progressWatcher.setProgress((int)((progress += 1.0f) / progressMax * 100.0f));
                                }
                                if (!this.cancelled) break block55;
                                if (this.progressWatcher != null) {
                                    this.progressWatcher.onCompleted();
                                }
                                this.completedWatcher.onFailure(this.localFile);
                                try {
                                    if (httpInputStream != null) {
                                        httpInputStream.close();
                                    }
                                }
                                catch (IOException ex) {
                                    // empty catch block
                                }
                                try {
                                    if (fileOutputStream != null) {
                                        fileOutputStream.close();
                                    }
                                }
                                catch (IOException ex) {
                                    // empty catch block
                                }
                                return;
                            }
                            httpInputStream = http.getInputStream();
                            progressMax = http.getContentLength();
                            contentLength = http.getContentLength();
                            if (this.progressWatcher != null) {
                                this.progressWatcher.resetProgressAndWorkingMessage(String.format("Downloading file (%.2f MB)...", new Object[]{Float.valueOf(progressMax / 1000.0f / 1000.0f)}));
                            }
                            if (!this.localFile.exists()) ** GOTO lbl67
                            receivedBytes = this.localFile.length();
                            if (receivedBytes != (long)contentLength) break block56;
                            this.completedWatcher.onSuccess(this.localFile);
                            if (this.progressWatcher == null) break block57;
                            this.progressWatcher.onCompleted();
                        }
                        try {
                            if (httpInputStream != null) {
                                httpInputStream.close();
                            }
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        return;
                    }
                    System.out.println("Deleting " + this.localFile + " as it does not match what we currently have (" + contentLength + " vs our " + receivedBytes + ").");
                    this.localFile.delete();
lbl67:
                    // 2 sources

                    fileOutputStream = new DataOutputStream(new FileOutputStream(this.localFile));
                    if (this.maxFileSize > 0 && progressMax > (float)this.maxFileSize) {
                        if (this.progressWatcher != null) {
                            this.progressWatcher.onCompleted();
                        }
                        throw new IOException("Filesize is bigger than maximum allowed (file is " + progress + ", limit is " + this.maxFileSize + ")");
                    }
                    while ((readBytes = httpInputStream.read(buffer)) >= 0 && !this.cancelled) {
                        progress += (float)readBytes;
                        if (this.progressWatcher != null) {
                            this.progressWatcher.setProgress((int)(progress / progressMax * 100.0f));
                        }
                        if (this.maxFileSize > 0 && progress > (float)this.maxFileSize) {
                            if (this.progressWatcher != null) {
                                this.progressWatcher.onCompleted();
                            }
                            throw new IOException("Filesize was bigger than maximum allowed (got >= " + progress + ", limit was " + this.maxFileSize + ")");
                        }
                        fileOutputStream.write(buffer, 0, readBytes);
                    }
                    if (!this.cancelled) break block58;
                    try {
                        fileOutputStream.close();
                        this.localFile.delete();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    if (this.progressWatcher != null) {
                        this.progressWatcher.onCompleted();
                    }
                    this.completedWatcher.onFailure(this.localFile);
                    try {
                        if (httpInputStream != null) {
                            httpInputStream.close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    return;
                }
                this.completedWatcher.onSuccess(this.localFile);
                if (this.progressWatcher == null) break block59;
                this.progressWatcher.onCompleted();
                try {
                    if (httpInputStream != null) {
                        httpInputStream.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return;
            }
            try {
                break block60;
                catch (Throwable th) {
                    // empty catch block
                }
            }
            catch (Throwable var11_24) {
                throw var11_24;
            }
            finally {
                try {
                    if (httpInputStream != null) {
                        httpInputStream.close();
                    }
                }
                catch (IOException ex) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
    }

    public static HttpFileRetriever beginDownloading(String sourceUrl, Map<String, String> headers, File destFile, int maxFileSize, IDownloadProgressWatcher progressWatcher, IDownloadCompletedWatcher completedWatcher) {
        HttpFileRetriever downloadThread = new HttpFileRetriever(sourceUrl, headers, destFile, maxFileSize, progressWatcher, completedWatcher);
        downloadThread.start();
        return downloadThread;
    }
}

