/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.common.util.gui;

import com.thevoxelbox.common.util.AbstractionLayer;
import com.thevoxelbox.common.util.gui.GuiControl;
import org.lwjgl.opengl.GL11;

public abstract class GuiControlEx
extends GuiControl {
    public int updateCounter;
    protected bao mc;
    protected boolean actionPerformed;
    protected boolean doubleClicked;

    public GuiControlEx(bao minecraft, int controlId, int xPos, int yPos, int controlWidth, int controlHeight, String displayText) {
        super(controlId, xPos, yPos, controlWidth, controlHeight, displayText);
        this.mc = minecraft;
    }

    public final void a(bao minecraft, int mouseX, int mouseY) {
        this.drawControl(minecraft, mouseX, mouseY);
    }

    protected abstract void drawControl(bao var1, int var2, int var3);

    public boolean getActionPerformed() {
        return this.actionPerformed;
    }

    public boolean getDoubleClicked(boolean resetDoubleClicked) {
        boolean result = this.doubleClicked;
        if (resetDoubleClicked) {
            this.doubleClicked = false;
        }
        return result;
    }

    protected void drawLine(int x1, int y1, int x2, int y2, int width, int colour) {
        this.drawArrow(x1, y1, x2, y2, width, colour, false, 0);
    }

    protected void drawArrow(int x1, int y1, int x2, int y2, int width, int arrowHeadSize, int colour) {
        this.drawArrow(x1, y1, x2, y2, width, colour, true, arrowHeadSize);
    }

    private void drawArrow(int x1, int y1, int x2, int y2, int width, int colour, boolean arrowHead, int arrowHeadSize) {
        int length = (int)Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        float angle = (float)Math.toDegrees(Math.atan2(y2 - y1, x2 - x1));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x1, (float)y1, (float)0.0f);
        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        x1 = 0;
        x2 = length - (arrowHead ? arrowHeadSize : 0);
        y1 = (int)((double)width * -0.5);
        y2 = y1 + width;
        float f = (float)(colour >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colour >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colour >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colour & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        bmh tessellator = AbstractionLayer.getTessellator();
        tessellator.b();
        tessellator.a((double)x1, (double)y2, 0.0);
        tessellator.a((double)x2, (double)y2, 0.0);
        tessellator.a((double)x2, (double)y1, 0.0);
        tessellator.a((double)x1, (double)y1, 0.0);
        tessellator.a();
        if (arrowHead && arrowHeadSize > 0) {
            tessellator.a(4);
            tessellator.a((double)x2, (double)(0 - arrowHeadSize / 2), 0.0);
            tessellator.a((double)x2, (double)(arrowHeadSize / 2), 0.0);
            tessellator.a((double)length, 0.0, 0.0);
            tessellator.a();
        }
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public void setTexMapSize(int textureSize) {
        texMapScale = 1.0f / (float)textureSize;
    }

    public void drawTexturedModalRectRot(int x, int y, int x2, int y2, int u, int v, int u2, int v2) {
        bmh tessellator = AbstractionLayer.getTessellator();
        tessellator.b();
        tessellator.a((double)x2, (double)y2, (double)this.getZLevel(), (double)((float)u * texMapScale), (double)((float)v2 * texMapScale));
        tessellator.a((double)x2, (double)y, (double)this.getZLevel(), (double)((float)u2 * texMapScale), (double)((float)v2 * texMapScale));
        tessellator.a((double)x, (double)y, (double)this.getZLevel(), (double)((float)u2 * texMapScale), (double)((float)v * texMapScale));
        tessellator.a((double)x, (double)y2, (double)this.getZLevel(), (double)((float)u * texMapScale), (double)((float)v * texMapScale));
        tessellator.a();
    }

    public void drawTexturedModalRectRot(int x, int y, int u, int v, int width, int height) {
        bmh tessellator = AbstractionLayer.getTessellator();
        tessellator.b();
        tessellator.a((double)(x + height), (double)(y + width), (double)this.getZLevel(), (double)((float)u * texMapScale), (double)((float)(v + height) * texMapScale));
        tessellator.a((double)(x + height), (double)y, (double)this.getZLevel(), (double)((float)(u + width) * texMapScale), (double)((float)(v + height) * texMapScale));
        tessellator.a((double)x, (double)y, (double)this.getZLevel(), (double)((float)(u + width) * texMapScale), (double)((float)v * texMapScale));
        tessellator.a((double)x, (double)(y + width), (double)this.getZLevel(), (double)((float)u * texMapScale), (double)((float)v * texMapScale));
        tessellator.a();
    }

    public void drawTessellatedModalRectV(int x, int y, int x2, int y2, int u, int v, int u2, int v2) {
        int tileSize = (v2 - v) / 2;
        int vMidTop = v + tileSize;
        int vMidBtm = vMidTop + 1;
        this.drawTexturedModalRect(x, y, x2, y + tileSize, u, v, u2, vMidTop);
        this.drawTexturedModalRect(x, y + tileSize, x2, y2 - tileSize + 1, u, vMidTop, u2, vMidBtm);
        this.drawTexturedModalRect(x, y2 - tileSize + 1, x2, y2, u, vMidBtm, u2, v2);
    }

    public void drawTessellatedModalRectH(int x, int y, int x2, int y2, int u, int v, int u2, int v2) {
        int tileSize = (u2 - u) / 2;
        int uMidLeft = u + tileSize;
        int uMidRight = uMidLeft + 1;
        this.drawTexturedModalRect(x, y, x + tileSize, y2, u, v, uMidLeft, v2);
        this.drawTexturedModalRect(x + tileSize, y, x2 - tileSize + 1, y2, uMidLeft, v, uMidRight, v2);
        this.drawTexturedModalRect(x2 - tileSize + 1, y, x2, y2, uMidRight, v, u2, v2);
    }

    public void drawTessellatedModalBorderRect(int x, int y, int x2, int y2, int u, int v, int u2, int v2) {
        this.drawTessellatedModalBorderRect(x, y, x2, y2, u, v, u2, v2, Math.min((x2 - x) / 2 - 1, (y2 - y) / 2 - 1));
    }

    public void drawTessellatedModalBorderRect(int x, int y, int x2, int y2, int u, int v, int u2, int v2, int borderSize) {
        int tileSize = Math.min((u2 - u) / 2 - 1, (v2 - v) / 2 - 1);
        int ul = u + tileSize;
        int ur = u2 - tileSize;
        int vt = v + tileSize;
        int vb = v2 - tileSize;
        int xl = x + borderSize;
        int xr = x2 - borderSize;
        int yt = y + borderSize;
        int yb = y2 - borderSize;
        this.drawTexturedModalRect(x, y, xl, yt, u, v, ul, vt);
        this.drawTexturedModalRect(xl, y, xr, yt, ul, v, ur, vt);
        this.drawTexturedModalRect(xr, y, x2, yt, ur, v, u2, vt);
        this.drawTexturedModalRect(x, yb, xl, y2, u, vb, ul, v2);
        this.drawTexturedModalRect(xl, yb, xr, y2, ul, vb, ur, v2);
        this.drawTexturedModalRect(xr, yb, x2, y2, ur, vb, u2, v2);
        this.drawTexturedModalRect(x, yt, xl, yb, u, vt, ul, vb);
        this.drawTexturedModalRect(xr, yt, x2, yb, ur, vt, u2, vb);
        this.drawTexturedModalRect(xl, yt, xr, yb, ul, vt, ur, vb);
    }

    public static void drawStringWithEllipsis(bbu fontrenderer, String s, int x, int y, int width, int colour) {
        if (fontrenderer.a(s) <= width) {
            fontrenderer.a(s, x, y, colour);
        } else if (width < 8) {
            fontrenderer.a("..", x, y, colour);
        } else {
            String trimmedText = s;
            while (fontrenderer.a(trimmedText) > width - 8 && trimmedText.length() > 0) {
                trimmedText = trimmedText.substring(0, trimmedText.length() - 1);
            }
            fontrenderer.a(trimmedText + "...", x, y, colour);
        }
    }

    public static enum KeyHandledState {
        None,
        Handled,
        ActionPerformed;

    }
}

