/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.common.util.properties;

import com.thevoxelbox.common.interfaces.IVoxelPropertyProvider;
import com.thevoxelbox.common.interfaces.IVoxelPropertyProviderFloat;
import com.thevoxelbox.common.util.properties.VoxelPropertyAbstractTextField;

public class VoxelPropertyFloatField
extends VoxelPropertyAbstractTextField<IVoxelPropertyProviderFloat> {
    private float minFieldValue = 0.1f;
    private float maxFieldValue = 10.0f;

    public VoxelPropertyFloatField(IVoxelPropertyProvider propertyProvider, String binding, String text, int xPos, int yPos, int fieldOffset) {
        super(propertyProvider, binding, text, xPos, yPos, fieldOffset);
        this.allowedCharacters = "0123456789.";
    }

    @Override
    protected void onLostFocus() {
        if (this.fieldValue.length() == 0) {
            this.fieldValue = ((IVoxelPropertyProviderFloat)this.propertyProvider).getDefaultPropertyValue(this.propertyBinding);
        }
        if (Float.valueOf(this.fieldValue).floatValue() < this.minFieldValue) {
            this.fieldValue = String.valueOf(this.minFieldValue);
        }
        ((IVoxelPropertyProviderFloat)this.propertyProvider).setProperty(this.propertyBinding, Float.parseFloat(this.fieldValue));
        this.fieldValue = ((IVoxelPropertyProviderFloat)this.propertyProvider).getStringProperty(this.propertyBinding);
        this.focused = false;
    }

    @Override
    protected boolean checkInvalidValue() {
        return this.fieldValue.length() > 0 && Float.valueOf(this.fieldValue).floatValue() > this.maxFieldValue;
    }
}

