/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.common.util.properties;

import com.thevoxelbox.common.LiteModVoxelCommon;
import com.thevoxelbox.common.interfaces.IVoxelPropertyProvider;
import com.thevoxelbox.common.interfaces.IVoxelPropertyProviderFloat;
import com.thevoxelbox.common.util.gui.IAdvancedDrawGui;
import com.thevoxelbox.common.util.properties.VoxelProperty;
import org.lwjgl.input.Mouse;

public class VoxelPropertySlider
extends VoxelProperty<IVoxelPropertyProviderFloat> {
    private float value = 0.0f;
    private float valueMin = -1.0f;
    private float valueMax = 1.0f;
    private float valueShift = -1.0f;
    private float valueScale;
    private float indicatorValue = 0.0f;
    private int sliderHeight;
    private int sliderWidth;
    private int handleXPos;
    private int handleXPosMin;
    private int handleXPosMax;
    private int handleWidth;
    private int handleHeight;
    private boolean snap = false;
    private boolean indicatorShow = false;
    private String minText = "Min";
    private String maxText = "Max";
    private String labelText;

    public VoxelPropertySlider(IVoxelPropertyProvider propertyProvider, String binding, String text, int xPos, int yPos, int w, int h, float minValue, float maxValue, boolean snap) {
        this(propertyProvider, binding, text, xPos, yPos, w, h, snap);
        this.valueMax = maxValue;
        this.valueMin = minValue;
        if (this.valueMax < this.valueMin || this.valueMax == this.valueMin) {
            this.valueMax = this.valueMin + 1.0f;
        }
        this.valueShift = this.valueMin;
        this.value = ((IVoxelPropertyProviderFloat)this.propertyProvider).getFloatProperty(binding) - this.valueShift;
        this.valueScale = (float)(this.handleXPosMax - this.handleXPosMin) / (this.valueMax - this.valueMin);
        if (((IVoxelPropertyProviderFloat)this.propertyProvider).getFloatProperty(binding) < this.valueMin) {
            ((IVoxelPropertyProviderFloat)this.propertyProvider).setProperty(binding, this.valueMin);
        } else if (((IVoxelPropertyProviderFloat)this.propertyProvider).getFloatProperty(binding) > this.valueMax) {
            ((IVoxelPropertyProviderFloat)this.propertyProvider).setProperty(binding, this.valueMax);
        }
    }

    public VoxelPropertySlider(IVoxelPropertyProvider propertyProvider, String binding, String text, int xPos, int yPos, int w, int h, float minValue, float maxValue, float indicatorValue, boolean snap) {
        this(propertyProvider, binding, text, xPos, yPos, w, h, indicatorValue, snap);
        this.valueMax = maxValue;
        this.valueMin = minValue;
        if (this.valueMax < this.valueMin || this.valueMax == this.valueMin) {
            this.valueMax = this.valueMin + 1.0f;
        }
        this.valueShift = this.valueMin;
        this.value = ((IVoxelPropertyProviderFloat)this.propertyProvider).getFloatProperty(binding) - this.valueShift;
        this.valueScale = (float)(this.handleXPosMax - this.handleXPosMin) / (this.valueMax - this.valueMin);
        if (((IVoxelPropertyProviderFloat)this.propertyProvider).getFloatProperty(binding) < this.valueMin) {
            ((IVoxelPropertyProviderFloat)this.propertyProvider).setProperty(binding, this.valueMin);
        } else if (((IVoxelPropertyProviderFloat)this.propertyProvider).getFloatProperty(binding) > this.valueMax) {
            ((IVoxelPropertyProviderFloat)this.propertyProvider).setProperty(binding, this.valueMax);
        }
    }

    public VoxelPropertySlider(IVoxelPropertyProvider propertyProvider, String binding, String text, int xPos, int yPos, int w, int h, float indicatorValue, boolean snap) {
        this(propertyProvider, binding, text, xPos, yPos, w, h, snap);
        this.indicatorValue = indicatorValue;
        this.indicatorShow = true;
    }

    public VoxelPropertySlider(IVoxelPropertyProvider propertyProvider, String binding, String displayText, int xPos, int yPos, int w, int h, boolean snap) {
        super(propertyProvider, binding, displayText, xPos, yPos);
        this.sliderHeight = h;
        this.sliderWidth = w;
        this.handleWidth = this.sliderHeight - 2;
        this.handleHeight = this.sliderHeight + 4;
        this.handleXPos = this.xPosition;
        this.handleXPosMin = this.xPosition + 2;
        this.handleXPosMax = this.xPosition + this.sliderWidth - this.handleWidth - 2;
        this.value = ((IVoxelPropertyProviderFloat)this.propertyProvider).getFloatProperty(binding) - this.valueShift;
        this.valueScale = (float)(this.handleXPosMax - this.handleXPosMin) / (this.valueMax - this.valueMin);
        this.snap = snap;
    }

    public VoxelPropertySlider(IVoxelPropertyProvider propertyProvider, String binding, String displayText, String minText, String maxText, int xPos, int yPos, float min, float max) {
        this(propertyProvider, binding, displayText, xPos, yPos, min, max);
        this.minText = minText;
        this.maxText = maxText;
    }

    public VoxelPropertySlider(IVoxelPropertyProvider propertyProvider, String binding, String displayText, int xPos, int yPos, float min, float max) {
        this(propertyProvider, binding, displayText, xPos, yPos);
        this.valueMin = min;
        this.valueMax = max;
        if (this.valueMax < this.valueMin || this.valueMax == this.valueMin) {
            this.valueMax = this.valueMin + 1.0f;
        }
        this.valueShift = this.valueMin;
        this.value = ((IVoxelPropertyProviderFloat)this.propertyProvider).getFloatProperty(binding) - this.valueShift;
        this.valueScale = (float)(this.handleXPosMax - this.handleXPosMin) / (this.valueMax - this.valueMin);
    }

    public VoxelPropertySlider(IVoxelPropertyProvider propertyProvider, String binding, String displayText, String minText, String maxText, int xPos, int yPos) {
        this(propertyProvider, binding, displayText, xPos, yPos);
        this.minText = minText;
        this.maxText = maxText;
    }

    public VoxelPropertySlider(IVoxelPropertyProvider propertyProvider, String binding, String displayText, int xPos, int yPos) {
        this(propertyProvider, binding, displayText, xPos, yPos, 100, 8, false);
    }

    @Override
    public void draw(IAdvancedDrawGui host, int mouseX, int mouseY) {
        if (Mouse.isButtonDown((int)0)) {
            if (this.focused) {
                this.moveHandle(mouseX);
            }
        } else {
            this.focused = false;
        }
        this.handleXPos = (int)((float)this.handleXPosMin + this.value * this.valueScale);
        int mintextX = this.fontRenderer.a(this.minText);
        this.fontRenderer.a(this.displayText, this.xPosition, this.yPosition - 12, 0xFFFFFF);
        this.fontRenderer.a(this.minText, this.xPosition - mintextX - 2, this.yPosition, 0xFFFFFF);
        this.fontRenderer.a(this.maxText, this.xPosition + this.sliderWidth + 2, this.yPosition, 0xFFFFFF);
        host.drawTessellatedModalBorderRect(LiteModVoxelCommon.GUIPARTS, 256, this.xPosition, this.yPosition, this.xPosition + this.sliderWidth, this.yPosition + this.sliderHeight, 1, 114, 127, 119, 2);
        if (this.indicatorShow) {
            this.drawIndicator(host);
        }
        this.drawHandle(host);
    }

    private void drawIndicator(IAdvancedDrawGui host) {
        int xPosZero = (int)((float)this.handleXPosMin + (this.indicatorValue + Math.abs(this.valueMin)) * this.valueScale);
        host.drawTessellatedModalBorderRect(LiteModVoxelCommon.GUIPARTS, 256, xPosZero - 1, this.yPosition + 1, xPosZero + this.handleWidth + 1, this.yPosition + this.sliderHeight - 1, 1, 33, 15, 47, 3);
        host.drawTessellatedModalBorderRect(LiteModVoxelCommon.GUIPARTS, 256, xPosZero, this.yPosition + 1, xPosZero + this.handleWidth, this.yPosition + this.sliderHeight - 1, 0, 121, 128, 128, 2);
    }

    private void drawHandle(IAdvancedDrawGui host) {
        host.drawTessellatedModalBorderRect(LiteModVoxelCommon.GUIPARTS, 256, this.handleXPos - 1, this.yPosition - 2, this.handleXPos + this.handleWidth + 1, this.yPosition + this.handleHeight - 2, 17, 33, 31, 47, 3);
        host.drawTessellatedModalBorderRect(LiteModVoxelCommon.GUIPARTS, 256, this.handleXPos, this.yPosition - 2, this.handleXPos + this.handleWidth, this.yPosition + this.handleHeight - 2, 0, 121, 128, 128, 3);
    }

    protected boolean mouseIn(int mouseX, int mouseY, int x1, int y1, int x2, int y2) {
        return mouseX > x1 && mouseX < x2 && mouseY > y1 && mouseY < y2;
    }

    public void moveHandle(int mouseX) {
        this.value = (mouseX -= this.handleWidth / 2) < this.handleXPosMin || (float)(mouseX - this.handleXPosMin) / this.valueScale < 0.0f ? 0.0f : (mouseX > this.handleXPosMin + (this.handleXPosMax - this.handleXPosMin) || (float)(mouseX - this.handleXPosMin) / this.valueScale > this.valueMax - this.valueMin ? this.valueMax - this.valueMin : (this.snap ? (float)((int)((float)(mouseX - this.handleXPosMin) / this.valueScale)) : (float)(mouseX - this.handleXPosMin) / this.valueScale));
        ((IVoxelPropertyProviderFloat)this.propertyProvider).setProperty(this.propertyBinding, this.value + this.valueShift);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY) {
        this.focused = this.mouseIn(mouseX, mouseY, this.xPosition, this.yPosition, this.xPosition + this.sliderWidth, this.yPosition + this.sliderHeight);
    }

    @Override
    public void keyTyped(char keyChar, int keyCode) {
    }
}

