/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelpacket.client;

import com.thevoxelbox.voxelpacket.client.ChatManager;
import com.thevoxelbox.voxelpacket.client.MessageRoutingScheme;
import com.thevoxelbox.voxelpacket.common.VoxelMessage;
import com.thevoxelbox.voxelpacket.common.VoxelPacket;
import com.thevoxelbox.voxelpacket.common.VoxelPacketHandlerBase;
import com.thevoxelbox.voxelpacket.common.interfaces.IPacketSenderDelegate;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelMessagePublisher;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelMessageSubscriber;
import com.thevoxelbox.voxelpacket.common.struct.QueryResponse;
import com.thevoxelbox.voxelpacket.exceptions.InvalidPacketDataException;
import com.thevoxelbox.voxelpacket.exceptions.InvalidShortcodeException;
import com.thevoxelbox.voxelpacket.exceptions.MissingEncoderException;
import com.thevoxelbox.voxelpacket.exceptions.VoxelPacketException;
import java.util.ArrayList;

public class VoxelPacketClient
extends VoxelPacketHandlerBase
implements IVoxelMessageSubscriber {
    public static Class<? extends VoxelPacketClient> instanceClass = VoxelPacketClient.class;
    private static VoxelPacketClient instance;
    protected bao minecraft;
    protected IPacketSenderDelegate senderDelegate;
    protected ChatManager chatManager;

    protected VoxelPacketClient() {
        this.subscribe(this, "@QUERY");
        VoxelPacket.registerClientPacketHandler(this);
        this.minecraft = bao.B();
        this.chatManager = new ChatManager(this.minecraft);
        this.senderDelegate = new IPacketSenderDelegate(){

            @Override
            public void sendPayload(String channel, byte[] payload) {
                VoxelPacketClient.this.onSendPacket((ft)new iz(channel, payload));
            }
        };
    }

    @Override
    protected void onPurgeSubscribers() {
        this.subscribe(this, "@QUERY");
    }

    public static VoxelPacketClient getInstance() {
        if (instance == null) {
            try {
                instance = instanceClass.newInstance();
            }
            catch (IllegalAccessException ex) {
                instance = new VoxelPacketClient();
            }
            catch (InstantiationException ex) {
                instance = new VoxelPacketClient();
            }
        }
        return instance;
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }

    public boolean sendMessageEx(String shortCode, Object messageData) {
        try {
            this.sendMessage(shortCode, messageData, null, MessageRoutingScheme.Both);
            return true;
        }
        catch (VoxelPacketException ex) {
            return false;
        }
    }

    public void sendMessage(String shortCode, Object messageData) throws MissingEncoderException, InvalidPacketDataException, InvalidShortcodeException {
        this.sendMessage(shortCode, messageData, null, MessageRoutingScheme.Both);
    }

    public boolean sendMessageEx(String shortCode, Object messageData, sa relevantEntity) {
        try {
            this.sendMessage(shortCode, messageData, relevantEntity, MessageRoutingScheme.Both);
            return true;
        }
        catch (VoxelPacketException ex) {
            return false;
        }
    }

    public void sendMessage(String shortCode, Object messageData, sa relevantEntity) throws MissingEncoderException, InvalidPacketDataException, InvalidShortcodeException {
        this.sendMessage(shortCode, messageData, relevantEntity, MessageRoutingScheme.Both);
    }

    public boolean sendMessageEx(String shortCode, Object messageData, MessageRoutingScheme routingScheme) {
        try {
            this.sendMessage(shortCode, messageData, null, routingScheme);
            return true;
        }
        catch (VoxelPacketException ex) {
            return false;
        }
    }

    public void sendMessage(String shortCode, Object messageData, MessageRoutingScheme routingScheme) throws MissingEncoderException, InvalidPacketDataException, InvalidShortcodeException {
        this.sendMessage(shortCode, messageData, null, routingScheme);
    }

    public boolean sendMessageEx(String shortCode, Object messageData, sa relevantEntity, MessageRoutingScheme routingScheme) {
        try {
            this.sendMessage(shortCode, messageData, relevantEntity, routingScheme);
            return true;
        }
        catch (VoxelPacketException ex) {
            return false;
        }
    }

    public void sendMessage(String shortCode, Object messageData, sa relevantEntity, MessageRoutingScheme routingScheme) throws MissingEncoderException, InvalidPacketDataException, InvalidShortcodeException {
        ArrayList<IVoxelMessageSubscriber> subscribers;
        if (routingScheme.routeLocally() && (subscribers = this.getAllSubscribers(shortCode)).size() > 0) {
            this.dispatchMessage(subscribers, new VoxelMessage(shortCode, messageData, relevantEntity));
        }
        if (routingScheme.routeRemotely()) {
            this.sendMessage(this.senderDelegate, shortCode, messageData, relevantEntity);
        }
    }

    protected void onSendPacket(ft packet) {
        if (this.minecraft != null && this.minecraft.v() != null) {
            this.minecraft.v().a(packet);
        }
    }

    @Override
    protected void dispatchMessage(ArrayList<IVoxelMessageSubscriber> subscribers, VoxelMessage message) {
        for (IVoxelMessageSubscriber subscriber : subscribers) {
            try {
                subscriber.receiveMessage(this, message);
            }
            catch (ClassCastException ex) {
                subscriber.receiveMessageClassCastFailure(this, message, ex);
            }
            catch (Exception ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessage(IVoxelMessagePublisher publisher, VoxelMessage message) {
        try {
            if (message.hasShortCode("@QUERY")) {
                String queryString = (String)message.data();
                ArrayList queryData = new ArrayList();
                if (queryString.equals("SUBS")) {
                    Object object = this.subscriberLock;
                    synchronized (object) {
                        queryData.addAll(this.subscriberMap.keySet());
                    }
                } else {
                    return;
                }
                queryData.remove("@QUERY");
                queryData.remove("*");
                this.sendMessage("@INFO", (Object)new QueryResponse(queryString, queryData), MessageRoutingScheme.Both);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void receiveMessageClassCastFailure(IVoxelMessagePublisher publisher, VoxelMessage message, ClassCastException ex) {
        System.err.println("Error casting data from query packet " + message.data().toString());
    }
}

