/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelpacket.client;

import com.mojang.authlib.GameProfile;
import com.mumfrey.liteloader.ChatFilter;
import com.mumfrey.liteloader.PluginChannelListener;
import com.mumfrey.liteloader.ServerPlayerListener;
import com.mumfrey.liteloader.ServerPluginChannelListener;
import com.thevoxelbox.voxelpacket.client.VoxelPacketClient;
import com.thevoxelbox.voxelpacket.common.VoxelPacket;
import com.thevoxelbox.voxelpacket.common.interfaces.IChatHandler;
import com.thevoxelbox.voxelpacket.server.VoxelPacketServer;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class VoxelPacketListener
implements PluginChannelListener,
ServerPluginChannelListener,
ServerPlayerListener,
ChatFilter {
    private static IChatHandler chatHandler;

    public void onJoinGame(fb netHandler, hd joinGamePacket) {
    }

    public String getName() {
        return "VoxelPacket";
    }

    public String getVersion() {
        return "2.2.0";
    }

    public void init(File configPath) {
        VoxelPacketClient.getInstance();
        VoxelPacketServer.initInstance();
    }

    public void upgradeSettings(String version, File configPath, File oldConfigPath) {
    }

    public List<String> getChannels() {
        return Arrays.asList("VOXELPACKET");
    }

    public void onCustomPayload(String channel, int length, byte[] data) {
        try {
            VoxelPacket packet = new VoxelPacket(channel, length, data);
            packet.handleServerPacket();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onCustomPayload(mw sender, String channel, int length, byte[] data) {
        try {
            VoxelPacket packet = new VoxelPacket(channel, length, data);
            packet.handleClientPacket(sender);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void registerPacketHandler(IChatHandler handler) {
        chatHandler = handler;
    }

    public boolean onChat(gj chatPacket, fj chat, String message) {
        if (chatHandler != null) {
            return !chatHandler.handleChatPacket(chatPacket, message);
        }
        return true;
    }

    public void onPlayerConnect(mw player, GameProfile profile) {
    }

    public void onPlayerLoggedIn(mw player) {
        VoxelPacketServer.getInstance().queryPlayer(player, "SUBS");
    }

    public void onPlayerRespawn(mw player, mw oldPlayer, int newDimension, boolean playerWonTheGame) {
    }

    public void onPlayerLogout(mw player) {
        VoxelPacketServer.getInstance().onPlayerQuit(player);
    }
}

