/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelpacket.common;

import com.thevoxelbox.voxelpacket.common.VoxelPacket;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelPacketEncoder;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelPacketHandler;
import com.thevoxelbox.voxelpacket.exceptions.MessageOverflowException;
import com.thevoxelbox.voxelpacket.exceptions.MissingEncoderException;
import java.nio.ByteBuffer;

public class VoxelMessage {
    private static int localMessageId = -1;
    @Deprecated
    public final boolean isLocal;
    @Deprecated
    public final String shortCode;
    @Deprecated
    public final int messageId;
    @Deprecated
    public final int messageLength;
    @Deprecated
    public final yz sender;
    @Deprecated
    public final sa relevantEntity;
    private final int dataType;
    private Object messageData;
    private ByteBuffer dataBuffer;
    private boolean finalised = false;
    private IVoxelPacketHandler agent;

    public VoxelMessage(IVoxelPacketHandler agent, VoxelPacket packet) throws MissingEncoderException, MessageOverflowException {
        this.agent = agent;
        this.sender = null;
        this.isLocal = false;
        this.shortCode = packet.packetShortCode;
        this.messageId = packet.packetMessageId;
        this.messageLength = packet.messageLength;
        this.dataType = packet.packetDataType;
        this.relevantEntity = packet.relevantEntity;
        this.dataBuffer = ByteBuffer.allocate(packet.messageLength);
        this.dataBuffer.put(packet.packetData);
        this.finalise();
    }

    public VoxelMessage(IVoxelPacketHandler agent, VoxelPacket packet, yz sender) throws MissingEncoderException, MessageOverflowException {
        this.agent = agent;
        this.sender = sender;
        this.isLocal = false;
        this.shortCode = packet.packetShortCode;
        this.messageId = packet.packetMessageId;
        this.messageLength = packet.messageLength;
        this.dataType = packet.packetDataType;
        this.relevantEntity = packet.relevantEntity;
        this.dataBuffer = ByteBuffer.allocate(packet.messageLength);
        this.dataBuffer.put(packet.packetData);
        this.finalise();
    }

    public VoxelMessage(String shortCode) {
        this(shortCode, null, null);
    }

    public VoxelMessage(String shortCode, Object data) {
        this(shortCode, data, null);
    }

    public VoxelMessage(String shortCode, Object data, sa relevantEntity) {
        this.sender = null;
        this.isLocal = true;
        this.dataType = 0;
        this.messageLength = 0;
        this.messageId = localMessageId--;
        this.shortCode = shortCode;
        this.relevantEntity = relevantEntity;
        this.messageData = data;
        this.finalised = true;
    }

    protected void finalise() throws MissingEncoderException {
        this.dataBuffer.flip();
        this.finalised = true;
        IVoxelPacketEncoder<?> encoder = this.agent.getEncoder(this.dataType);
        if (encoder == null) {
            throw new MissingEncoderException("Could not find an encoder matching data type ID " + this.dataType);
        }
        while (this.dataBuffer.remaining() > this.messageLength) {
            int limit = this.dataBuffer.limit() - 1;
            this.dataBuffer.limit(limit);
        }
        this.messageData = encoder.decode(this.dataBuffer);
    }

    public boolean isFinalised() {
        return this.finalised;
    }

    public <T> T data() throws ClassCastException {
        return (T)this.messageData;
    }

    public Object getRawMessageData() {
        return this.messageData;
    }

    public boolean dataInstanceOf(Class<?> thisClass) {
        if (thisClass == null) {
            return this.messageData == null;
        }
        return thisClass.isInstance(this.messageData);
    }

    public boolean hasShortCode(String shortCode) {
        if (shortCode == null) {
            return false;
        }
        return shortCode.equals(this.shortCode);
    }

    public int ordinal(String ... shortCodes) {
        int ordinal = 0;
        for (String shortCode : shortCodes) {
            if (shortCode != null && shortCode.equals(this.shortCode)) {
                return ordinal;
            }
            ++ordinal;
        }
        return -1;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String getShortCode() {
        return this.shortCode;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public yz getSender() {
        return this.sender;
    }

    public String getSenderName() {
        return this.sender != null ? this.sender.b_() : "Local";
    }

    public sa getRelevantEntity() {
        return this.relevantEntity;
    }
}

