/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelpacket.common.data;

public abstract class Marshal {
    public static int pack(short short1, short short2) {
        return short1 << 16 | short2;
    }

    public static int pack(byte byte1, byte byte2, byte byte3, byte byte4) {
        return byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
    }

    public static int pack(char char1, char char2) {
        return Marshal.pack((short)char1, (short)char2);
    }

    public static int pack(boolean[] flags) {
        if (flags.length > 32) {
            throw new ArrayIndexOutOfBoundsException(flags.length);
        }
        int packed = 0;
        for (int shift = 0; shift < flags.length; ++shift) {
            if (!flags[shift]) continue;
            packed |= 1 << 31 - shift;
        }
        return packed;
    }

    public static long pack(int int1, int int2) {
        return (long)int1 << 32 | (long)int2;
    }

    public static short[] unpackShort(int intValue) {
        return new short[]{(short)((intValue & 0xFFFF0000) >> 16), (short)(intValue & 0xFFFF)};
    }

    public static byte[] unpackByte(int intValue) {
        return new byte[]{(byte)((intValue & 0xFF000000) >> 24), (byte)((intValue & 0xFF0000) >> 16), (byte)((intValue & 0xFF00) >> 8), (byte)(intValue & 0xFF)};
    }

    public static byte[] unpackByte(long longValue) {
        return new byte[]{(byte)((longValue & 0xFF00000000000000L) >> 56), (byte)((longValue & 0xFF000000000000L) >> 48), (byte)((longValue & 0xFF0000000000L) >> 40), (byte)((longValue & 0xFF00000000L) >> 32), (byte)((longValue & 0xFF000000L) >> 24), (byte)((longValue & 0xFF0000L) >> 16), (byte)((longValue & 0xFF00L) >> 8), (byte)(longValue & 0xFFL)};
    }

    public static char[] unpackChar(int intValue) {
        return new char[]{(char)((intValue & 0xFFFF0000) >> 16), (char)(intValue & 0xFFFF)};
    }

    public static boolean[] unpackBoolArray(int intValue) {
        boolean[] unpacked = new boolean[32];
        for (int shift = 0; shift < 32; ++shift) {
            int mask = 1 << 31 - shift;
            unpacked[shift] = (intValue & mask) == mask;
        }
        return unpacked;
    }

    public static int[] unpackInt(long longValue) {
        return new int[]{(int)((longValue & 0xFFFFFFFF00000000L) >> 32), (int)(longValue & 0xFFFFFFFFL)};
    }

    public static byte[] charToByte(int inChar) {
        return new byte[]{(byte)((inChar & 0xFF00) >> 8), (byte)(inChar & 0xFF)};
    }

    public static char byteToChar(byte msb, byte lsb) {
        short sMsb = (short)(msb << 8 | lsb & 0xFF);
        return (char)sMsb;
    }
}

