/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelpacket.common.data;

import com.thevoxelbox.voxelpacket.common.data.Marshal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class VoxelPacketCharsetDecoder
extends CharsetDecoder {
    public VoxelPacketCharsetDecoder(Charset cs) {
        super(cs, 1.0f, 1.0f);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        byte[] bytes = new byte[2];
        while (in.remaining() > 1) {
            bytes[0] = in.get();
            bytes[1] = in.get();
            out.put(Marshal.byteToChar(bytes[0], bytes[1]));
        }
        if (in.remaining() == 1) {
            bytes[0] = in.get();
            bytes[1] = 0;
            out.put(Marshal.byteToChar(bytes[0], bytes[1]));
        }
        if (in.remaining() > 0) {
            throw new RuntimeException("Error decoding data");
        }
        return CoderResult.UNDERFLOW;
    }
}

