/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelpacket.common.encoders;

import com.thevoxelbox.voxelpacket.common.data.Marshal;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelPacketEncoder;
import java.nio.ByteBuffer;

public class VoxelPacketEncoderFloat
implements IVoxelPacketEncoder<Float> {
    private int dataTypeId;

    public VoxelPacketEncoderFloat(int dataTypeId) {
        this.dataTypeId = dataTypeId;
    }

    @Override
    public int getDataTypeID() {
        return this.dataTypeId;
    }

    @Override
    public byte[] encode(Float object) {
        if (object != null) {
            int intValue = Float.floatToIntBits(object.floatValue());
            return Marshal.unpackByte(intValue);
        }
        return new byte[0];
    }

    @Override
    public Float decode(ByteBuffer dataBuffer) {
        try {
            int value = dataBuffer.getInt();
            return Float.valueOf(Float.intBitsToFloat(value));
        }
        catch (Exception exception) {
            return Float.valueOf(0.0f);
        }
    }
}

