/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.common.gl;

import java.awt.image.BufferedImage;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class FBO {
    private static boolean supported = false;
    private static boolean useARB = false;
    private boolean created;
    private boolean active;
    private int depthBuffer;
    private int frameBuffer;
    private bpq texture;
    private int frameBufferWidth;
    private int frameBufferHeight;

    public static boolean detectFBOCapabilities() {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        if (capabilities.GL_ARB_framebuffer_object) {
            supported = true;
            useARB = true;
            return true;
        }
        if (capabilities.GL_EXT_framebuffer_object) {
            supported = true;
            return true;
        }
        supported = false;
        return false;
    }

    public FBO() {
        FBO.detectFBOCapabilities();
    }

    public static boolean isSupported() {
        return supported;
    }

    public void begin(int width, int height) {
        if (!supported) {
            return;
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Attempted to create an FBO with zero or negative size");
        }
        if (this.created && (width != this.frameBufferWidth || height != this.frameBufferHeight)) {
            this.dispose();
        }
        if (!this.created) {
            this.created = true;
            this.frameBufferWidth = width;
            this.frameBufferHeight = height;
            BufferedImage textureImage = new BufferedImage(this.frameBufferWidth, this.frameBufferHeight, 1);
            this.texture = new bpq(textureImage);
            if (useARB) {
                this.frameBuffer = ARBFramebufferObject.glGenFramebuffers();
                this.depthBuffer = ARBFramebufferObject.glGenRenderbuffers();
                ARBFramebufferObject.glBindFramebuffer((int)36160, (int)this.frameBuffer);
                ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texture.b(), (int)0);
                ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)this.depthBuffer);
                ARBFramebufferObject.glRenderbufferStorage((int)36161, (int)33190, (int)this.frameBufferWidth, (int)this.frameBufferHeight);
                ARBFramebufferObject.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.depthBuffer);
                ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
                ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)0);
            } else {
                this.frameBuffer = EXTFramebufferObject.glGenFramebuffersEXT();
                this.depthBuffer = EXTFramebufferObject.glGenRenderbuffersEXT();
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.frameBuffer);
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)this.texture.b(), (int)0);
                EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)this.depthBuffer);
                EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)33190, (int)this.frameBufferWidth, (int)this.frameBufferHeight);
                EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)this.depthBuffer);
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
                EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)0);
            }
        }
        this.bind();
    }

    public void bind() {
        if (!supported) {
            return;
        }
        if (this.created && this.checkFBO()) {
            if (useARB) {
                ARBFramebufferObject.glBindFramebuffer((int)36160, (int)this.frameBuffer);
                ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)this.depthBuffer);
            } else {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.frameBuffer);
                EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)this.depthBuffer);
            }
            GL11.glPushAttrib((int)2048);
            GL11.glViewport((int)0, (int)0, (int)this.frameBufferWidth, (int)this.frameBufferHeight);
            GL11.glClear((int)16384);
            this.active = true;
        }
    }

    public void end() {
        if (supported && this.active) {
            if (useARB) {
                ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
                ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)0);
            } else {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
                EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)0);
            }
            GL11.glPopAttrib();
            this.active = false;
        }
    }

    public void dispose() {
        if (!supported) {
            return;
        }
        this.end();
        if (this.texture != null) {
            GL11.glDeleteTextures((int)this.texture.b());
        }
        if (useARB) {
            ARBFramebufferObject.glDeleteRenderbuffers((int)this.depthBuffer);
            ARBFramebufferObject.glDeleteFramebuffers((int)this.frameBuffer);
        } else {
            EXTFramebufferObject.glDeleteRenderbuffersEXT((int)this.depthBuffer);
            EXTFramebufferObject.glDeleteFramebuffersEXT((int)this.frameBuffer);
        }
        this.depthBuffer = 0;
        this.texture = null;
        this.frameBuffer = 0;
        this.created = false;
    }

    private boolean checkFBO() {
        if (useARB) {
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)this.frameBuffer);
            ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)this.depthBuffer);
        } else {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.frameBuffer);
            EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)this.depthBuffer);
        }
        int frameBufferStatus = useARB ? ARBFramebufferObject.glCheckFramebufferStatus((int)36160) : EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        switch (frameBufferStatus) {
            case 36053: {
                return true;
            }
            case 36054: 
            case 36055: 
            case 36057: 
            case 36058: 
            case 36059: 
            case 36060: {
                return false;
            }
        }
        throw new RuntimeException("Unexpected reply from glCheckFramebufferStatus: " + frameBufferStatus);
    }

    public void draw(int x, int y, int x2, int y2, int z, float alpha) {
        this.draw(x, y, x2, y2, z, alpha, 0.0, 0.0, 1.0, 1.0);
    }

    public void draw(double x, double y, double x2, double y2, double z, float alpha, double u, double v, double u2, double v2) {
        if (supported && this.created) {
            GL11.glEnable((int)3553);
            GL11.glBindTexture((int)3553, (int)this.texture.b());
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            bmh tessellator = bmh.a;
            tessellator.b();
            tessellator.a(x, y2, z, u, v);
            tessellator.a(x2, y2, z, u2, v);
            tessellator.a(x2, y, z, u2, v2);
            tessellator.a(x, y, z, u, v2);
            tessellator.a();
        }
    }
}

