/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.common.gui;

import com.mumfrey.liteloader.Tickable;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.core.LiteLoader;
import com.thevoxelbox.common.gui.GuiVoxelBoxSettingsPanel;
import com.thevoxelbox.common.gui.SettingsPanelMenuTab;
import com.thevoxelbox.common.gui.SettingsPanelScrollBar;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.lwjgl.opengl.GL11;

public class SettingsPanelManager
implements Tickable {
    private static int TAB_WIDTH = 72;
    private static final int TAB_HEIGHT = 16;
    private static SettingsPanelManager instance;
    private bao mc;
    private Map<String, Class<? extends GuiVoxelBoxSettingsPanel>> panels = new TreeMap<String, Class<? extends GuiVoxelBoxSettingsPanel>>();
    private TreeSet<SettingsPanelMenuTab> tabs = new TreeSet();
    private SettingsPanelScrollBar scrollbar = new SettingsPanelScrollBar(6, 4, 10, 220, 0);
    private Class<? extends GuiVoxelBoxSettingsPanel> firstPanel = null;
    public static bal guiKeyBinding;

    public static SettingsPanelManager getInstance() {
        if (instance == null) {
            instance = new SettingsPanelManager();
            LiteLoader.getInterfaceManager().registerListener((Listener)instance);
            LiteLoader.getInput().registerKeyBinding(guiKeyBinding);
        }
        return instance;
    }

    private SettingsPanelManager() {
        this.mc = bao.B();
    }

    public static void addSettingsPanel(String panelName, Class<? extends GuiVoxelBoxSettingsPanel> panel) {
        SettingsPanelManager.getInstance().addPanel(panelName, panel);
    }

    public static void removeSettingsPanel(String panelName) {
        SettingsPanelManager.getInstance().removePanel(panelName);
    }

    public static void displaySettings() {
        SettingsPanelManager.getInstance().displaySettings(bao.B());
    }

    public static boolean hasOptions() {
        return SettingsPanelManager.getInstance().panels.size() > 0;
    }

    public void addPanel(String panelName, Class<? extends GuiVoxelBoxSettingsPanel> panel) {
        if (panel != null) {
            this.panels.put(panelName, panel);
            this.tabs.add(new SettingsPanelMenuTab(panelName, GuiVoxelBoxSettingsPanel.PANEL_LEFT, 0));
        }
        this.updateTabs();
    }

    public void addPanel(String panelName, Class<? extends GuiVoxelBoxSettingsPanel> panel, int priority) {
        if (panel != null) {
            this.panels.put(panelName, panel);
            this.tabs.add(new SettingsPanelMenuTab(panelName, 62, priority));
        }
        this.updateTabs();
    }

    public void removePanel(String panelName) {
        this.panels.remove(panelName);
        this.updateTabs();
    }

    protected void updateTabs() {
        Iterator<String> iter = this.panels.keySet().iterator();
        if (iter.hasNext()) {
            this.firstPanel = this.panels.get(iter.next());
        }
        int largest = 0;
        for (SettingsPanelMenuTab tab : this.tabs) {
            if (this.mc.l.a(tab.getLabel()) <= largest) continue;
            largest = this.mc.l.a(tab.getLabel());
        }
        TAB_WIDTH = 16 * this.tabs.size() < GuiVoxelBoxSettingsPanel.PANEL_HEIGHT ? largest + 6 : largest + 18 + this.scrollbar.getWidth();
        for (SettingsPanelMenuTab tab : this.tabs) {
            tab.setXPos(TAB_WIDTH);
        }
        GuiVoxelBoxSettingsPanel.PANEL_LEFT = TAB_WIDTH;
    }

    public void onTick(bao minecraft, float partialTicks, boolean inGame, boolean clock) {
        if (minecraft.n == null && guiKeyBinding.d() && this.firstPanel != null) {
            this.displaySettings(minecraft);
        }
    }

    public void displaySettings(bao minecraft) {
        try {
            GuiVoxelBoxSettingsPanel panel = this.firstPanel.newInstance();
            minecraft.a((bdw)panel);
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public boolean mouseClicked(GuiVoxelBoxSettingsPanel panel, int mouseX, int mouseY, int button, int xPos, int yPos, int spacing) {
        if (button == 0) {
            int newWidth = TAB_WIDTH;
            if (16 * this.tabs.size() > GuiVoxelBoxSettingsPanel.PANEL_HEIGHT) {
                newWidth -= 18 + this.scrollbar.getWidth();
            }
            for (SettingsPanelMenuTab tab : this.tabs) {
                if (!tab.isMouseOver(newWidth, mouseX, mouseY)) continue;
                try {
                    GuiVoxelBoxSettingsPanel newPanel = this.panels.get(tab.getLabel()).newInstance();
                    this.mc.a((bdw)newPanel);
                    return true;
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                }
            }
            boolean intersects = this.scrollbar.mouseIn(mouseX, mouseY);
            if (intersects) {
                this.scrollbar.mouseHeld = true;
                return true;
            }
            this.scrollbar.mouseHeld = false;
            return false;
        }
        return false;
    }

    public void renderTabs(GuiVoxelBoxSettingsPanel panel, int mouseX, int mouseY, float partialTicks, int xPos, int yPos, int spacing, boolean mask) {
        int tabYPosition = yPos;
        GL11.glEnable((int)2929);
        this.updateTabs();
        int newWidth = TAB_WIDTH;
        int newY = 0;
        if (16 * this.tabs.size() > GuiVoxelBoxSettingsPanel.PANEL_HEIGHT) {
            newWidth -= 12 + this.scrollbar.getWidth();
            newY = (int)((double)(16 * this.tabs.size()) * this.scrollbar.getValue());
        }
        tabYPosition += 8;
        tabYPosition -= newY;
        for (SettingsPanelMenuTab tab : this.tabs) {
            tab.setActive(panel.getClass().equals(this.panels.get(tab.getLabel())));
            tab.renderTab(panel, newWidth, mouseX, mouseY, tabYPosition, mask);
            tabYPosition += 16;
        }
        if (16 * this.tabs.size() > GuiVoxelBoxSettingsPanel.PANEL_HEIGHT) {
            this.scrollbar.setHeight(GuiVoxelBoxSettingsPanel.PANEL_HEIGHT - 8);
            this.scrollbar.render(panel, mouseY);
        }
        GL11.glDisable((int)2929);
    }

    public void init(File f) {
    }

    public String getName() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public void upgradeSettings(String version, File configPath, File oldConfigPath) {
    }

    static {
        guiKeyBinding = new bal("VoxelMods Config", 0, "VoxelLib");
    }
}

