/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.common.status;

import java.util.Random;

public class StatusMessage
implements Comparable<StatusMessage> {
    private static final String MESSAGE_FORMAT = "\u00a7%s%s\u00a7f: \u00a7%s%s\u00a7r";
    private static final int MESSAGE_HEIGHT = 10;
    private char titleColour = (char)102;
    private char textColour = (char)97;
    private final String label;
    private String title = "";
    private String text = "";
    private int priority = 0;
    private int order = 0;
    private boolean visible = false;

    public StatusMessage(String label) {
        this.label = label;
        this.order = new Random().nextInt(Integer.MAX_VALUE);
    }

    public StatusMessage(String label, int priority, int order) {
        this(label);
        this.priority = priority;
        this.order = order;
    }

    public StatusMessage setTitleAndText(String title, String text) {
        this.title = title;
        this.text = text;
        return this;
    }

    public StatusMessage setTitle(String title) {
        this.title = title;
        return this;
    }

    public StatusMessage setText(String text) {
        this.text = text;
        return this;
    }

    public StatusMessage setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public StatusMessage setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public StatusMessage setTextColour(char textColour) {
        this.textColour = textColour;
        return this;
    }

    public StatusMessage setTitleColour(char titleColour) {
        this.titleColour = titleColour;
        return this;
    }

    public StatusMessage setColours(char textColour, char titleColour) {
        this.textColour = textColour;
        this.titleColour = titleColour;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public String getLabel() {
        return this.label;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int drawStatus(bbu fontRenderer, int xPos, int yPos) {
        if (this.isVisible()) {
            fontRenderer.a(String.format(MESSAGE_FORMAT, Character.valueOf(this.titleColour), this.title, Character.valueOf(this.textColour), this.text), xPos, yPos, 0xFFFFFF);
            return 10;
        }
        return 0;
    }

    @Override
    public int compareTo(StatusMessage other) {
        if (other == null) {
            return 0;
        }
        if (this.priority == other.priority) {
            return this.order - other.order;
        }
        return this.priority - other.priority;
    }
}

