/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.common.status;

import com.mumfrey.liteloader.Tickable;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.core.LiteLoader;
import com.thevoxelbox.common.gui.SettingsPanelManager;
import com.thevoxelbox.common.status.StatusMessage;
import com.thevoxelbox.common.status.StatusMessageConfig;
import com.thevoxelbox.common.status.StatusMessageGUI;
import com.thevoxelbox.common.util.ModConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.lwjgl.opengl.GL11;

public class StatusMessageManager
implements Tickable {
    private static StatusMessageManager instance;
    private static int order;
    private Map<String, StatusMessage> statusMessages = new HashMap<String, StatusMessage>();
    private TreeSet<StatusMessage> sortedMessage = new TreeSet();
    private StatusMessageConfig config = new StatusMessageConfig();
    private boolean showStatuses = true;

    public void init(File configPath) {
        this.showStatuses = this.config.getBoolProperty("showStatuses");
    }

    public static StatusMessageManager getInstance() {
        if (instance == null) {
            instance = new StatusMessageManager();
            LiteLoader.getInterfaceManager().registerListener((Listener)instance);
            SettingsPanelManager.addSettingsPanel("Status MSG", StatusMessageGUI.class);
        }
        return instance;
    }

    public void onTick(bao minecraft, float partialTicks, boolean inGame, boolean clock) {
        this.showStatuses = this.config.getBoolProperty("showStatuses");
        if (minecraft.x && !minecraft.u.av && !minecraft.u.ax && this.showStatuses) {
            int xPos;
            int yPos = xPos = 2;
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            for (StatusMessage msg : this.sortedMessage) {
                yPos += msg.drawStatus(minecraft.l, xPos, yPos);
            }
        }
    }

    public StatusMessage getStatusMessage(String label, int priority) {
        if (this.statusMessages.containsKey(label)) {
            return this.statusMessages.get(label);
        }
        StatusMessage newMessage = new StatusMessage(label, priority, order++);
        this.statusMessages.put(label, newMessage);
        this.sortedMessage.add(newMessage);
        return newMessage;
    }

    public void releaseStatusMessage(StatusMessage message) {
        this.sortedMessage.remove(message);
        this.statusMessages.remove(message);
    }

    public ModConfig getConfig() {
        return this.config;
    }

    public void toggleOption(String optionName) {
        this.config.setProperty(optionName, !this.config.getBoolProperty(optionName));
    }

    public String getName() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public void upgradeSettings(String version, File configPath, File oldConfigPath) {
    }

    static {
        order = 0;
    }
}

