/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.common.util;

import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import com.thevoxelbox.common.interfaces.IVoxelPropertyProviderBoolean;
import com.thevoxelbox.common.interfaces.IVoxelPropertyProviderFloat;
import com.thevoxelbox.common.interfaces.IVoxelPropertyProviderInteger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Map;
import java.util.Properties;

public abstract class ModConfig
implements IVoxelPropertyProviderFloat,
IVoxelPropertyProviderInteger,
IVoxelPropertyProviderBoolean {
    protected final Properties defaults = new Properties();
    protected Properties config;
    protected final String modName;
    protected final String propertiesFileName;
    protected File propertiesFile;

    public ModConfig(String modName, String propertiesFileName) {
        this.modName = modName;
        this.propertiesFileName = propertiesFileName;
        this.setDefaults();
        LiteLoaderLogger.info((String)"%s> Attempting to load/create the configuration.", (Object[])new Object[]{this.modName});
        this.loadConfig();
    }

    protected abstract void setDefaults();

    protected void loadConfig() {
        this.config = new Properties(this.defaults);
        try {
            this.propertiesFile = new File(LiteLoader.getCommonConfigFolder(), this.propertiesFileName);
            if (this.propertiesFile.exists()) {
                LiteLoaderLogger.info((String)"%s> Config file found, loading...", (Object[])new Object[]{this.modName});
                this.config.load(new FileInputStream(this.propertiesFile));
            } else {
                LiteLoaderLogger.info((String)"%s> No config file found, creating...", (Object[])new Object[]{this.modName});
                this.createConfig();
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning((String)"%s> ERROR: %s", (Object[])new Object[]{this.modName, ex.toString()});
        }
    }

    protected void createConfig() {
        try {
            this.config.putAll((Map<?, ?>)this.defaults);
            this.config.store(new FileWriter(this.propertiesFile), null);
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning((String)"%s> ERROR: %s", (Object[])new Object[]{this.modName, ex.toString()});
        }
    }

    @Override
    public void setProperty(String propertyName, float value) {
        this.config.setProperty(propertyName, String.valueOf(value));
        this.saveConfig();
    }

    @Override
    public void setProperty(String propertyName, int value) {
        this.config.setProperty(propertyName, String.valueOf(value));
        this.saveConfig();
    }

    @Override
    public void setProperty(String propertyName, boolean value) {
        this.config.setProperty(propertyName, String.valueOf(value));
        this.saveConfig();
    }

    public void setProperty(String propertyName, String value) {
        this.config.setProperty(propertyName, value);
        this.saveConfig();
    }

    @Override
    public String getStringProperty(String propertyName) {
        return this.config.getProperty(propertyName);
    }

    @Override
    public float getFloatProperty(String propertyName) {
        return Float.parseFloat(this.config.getProperty(propertyName));
    }

    public float getClampedFloatProperty(String propertyName, float min, float max) {
        float value = this.getFloatProperty(propertyName);
        return Math.min(Math.max(value, min), max);
    }

    @Override
    public int getIntProperty(String propertyName) {
        return Integer.parseInt(this.config.getProperty(propertyName));
    }

    @Override
    public boolean getBoolProperty(String propertyName) {
        return Boolean.parseBoolean(this.config.getProperty(propertyName));
    }

    @Override
    public String getDefaultPropertyValue(String propertyName) {
        return this.defaults.getProperty(propertyName);
    }

    public float getDefaultFloatProperty(String propertyName) {
        return Float.parseFloat(this.defaults.getProperty(propertyName));
    }

    public int getDefaultIntProperty(String propertyName) {
        return Integer.parseInt(this.defaults.getProperty(propertyName));
    }

    public boolean getDefaultBoolProperty(String propertyName) {
        return Boolean.parseBoolean(this.defaults.getProperty(propertyName));
    }

    public void saveConfig() {
        try {
            this.config.store(new FileWriter(this.propertiesFile), null);
        }
        catch (Exception e) {
            LiteLoaderLogger.warning((String)"%s> ERROR: %s", (Object[])new Object[]{this.modName, e.toString()});
        }
    }

    @Override
    public void toggleOption(String propertyName) {
        this.setProperty(propertyName, !this.getBoolProperty(propertyName));
    }

    @Override
    public String getOptionDisplayString(String propertyName) {
        return "";
    }
}

