/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.common.util.gui;

import com.thevoxelbox.common.LiteModVoxelCommon;
import com.thevoxelbox.common.util.AbstractionLayer;
import com.thevoxelbox.common.util.gui.GuiControlEx;
import org.lwjgl.opengl.GL11;

public class GuiScrollBar
extends GuiControlEx {
    protected ScrollBarOrientation orientation;
    protected int min;
    protected int max;
    protected int value;
    protected int buttonPos = 0;
    protected int scrollButtonSize = 20;
    protected int traySize;
    protected int dragOffset;
    protected int mouseDownState = 0;
    protected int mouseDownTime = 0;

    public GuiScrollBar(bao minecraft, int controlId, int xPos, int yPos, int controlWidth, int controlHeight, int minValue, int maxValue, ScrollBarOrientation orientation) {
        super(minecraft, controlId, xPos, yPos, controlWidth, controlHeight, "");
        this.orientation = orientation;
        this.value = this.min = minValue;
        this.max = Math.max(this.min, maxValue);
        this.traySize = this.getLargeDimension() - this.getSmallDimension() * 2 - this.scrollButtonSize;
    }

    protected int getLargeDimension() {
        return this.orientation == ScrollBarOrientation.Vertical ? this.g : this.f;
    }

    protected int getSmallDimension() {
        return this.orientation == ScrollBarOrientation.Vertical ? this.f : this.g;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.updateValue();
    }

    public void setMin(int value) {
        this.min = value;
        this.max = Math.max(this.min, this.max);
        this.updateValue();
    }

    public void setMax(int value) {
        this.max = value;
        this.min = Math.min(this.max, this.min);
        this.updateValue();
    }

    public void setPosition(int left, int top) {
        this.setXPosition(left);
        this.setYPosition(top);
    }

    public void setSize(int controlWidth, int controlHeight) {
        this.setWidth(controlWidth);
        this.setHeight(controlHeight);
        this.traySize = this.getLargeDimension() - this.getSmallDimension() * 2 - this.scrollButtonSize;
        this.updateValue();
    }

    public void setSizeAndPosition(int left, int top, int controlWidth, int controlHeight) {
        this.setPosition(left, top);
        this.setSize(controlWidth, controlHeight);
    }

    private void updateValue() {
        if (this.value < this.min) {
            this.value = this.min;
        }
        if (this.value > this.max) {
            this.value = this.max;
        }
        this.buttonPos = (int)((float)(this.value - this.min) / (float)(this.max - this.min) * (float)this.traySize);
    }

    @Override
    protected void drawControl(bao minecraft, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        float opacity = this.isEnabled() ? 1.0f : 0.3f;
        GL11.glColor4f((float)opacity, (float)opacity, (float)opacity, (float)opacity);
        boolean mouseOverUpButton = this.mouseDownState == 3 || this.mouseIsOverButton(3, mouseX, mouseY);
        boolean mouseOverDownButton = this.mouseDownState == 2 || this.mouseIsOverButton(2, mouseX, mouseY);
        boolean mouseOverButton = this.mouseDownState == 1 || this.mouseIsOverButton(1, mouseX, mouseY);
        int upButtonHoverState = 0 + this.a(mouseOverUpButton) * 16;
        int downButtonHoverState = 0 + this.a(mouseOverDownButton) * 16;
        int buttonHoverState = 0 + this.a(mouseOverButton) * 16;
        if (this.orientation == ScrollBarOrientation.Vertical) {
            AbstractionLayer.bindTexture(LiteModVoxelCommon.GUIPARTS);
            this.setTexMapSize(256);
            this.drawTessellatedModalBorderRect(this.h, this.i, this.h + this.f, this.i + this.f, 0, upButtonHoverState, 16, upButtonHoverState + 16, 4);
            this.drawTessellatedModalBorderRect(this.h, this.i + this.g - this.f, this.h + this.f, this.i + this.g, 0, downButtonHoverState, 16, downButtonHoverState + 16, 4);
            this.drawTessellatedModalBorderRect(this.h + 1, this.i + this.f, this.h + this.f - 1, this.i + this.g - this.f, 0, 0, 16, 16, 4);
            this.drawTexturedModalRect(this.h + 1, this.i + 1, this.h + this.f - 2, this.i + this.f - 2, 36, 0, 54, 18);
            this.drawTexturedModalRect(this.h + 1, this.i + this.g - this.f + 1, this.h + this.f - 2, this.i + this.g - 1, 18, 0, 36, 18);
        }
        this.b(minecraft, mouseX, mouseY);
        AbstractionLayer.bindTexture(LiteModVoxelCommon.GUIPARTS);
        if (this.orientation == ScrollBarOrientation.Vertical) {
            this.drawTessellatedModalBorderRect(this.h, this.i + this.f + this.buttonPos, this.h + this.f, this.i + this.f + this.buttonPos + this.scrollButtonSize, 0, buttonHoverState, 16, buttonHoverState + 16, 4);
        }
    }

    protected boolean mouseIsOverButton(int button, int mouseX, int mouseY) {
        int buttonX = 0;
        int buttonY = 0;
        int buttonWidth = this.getSmallDimension();
        int buttonHeight = this.getSmallDimension();
        if ((mouseX -= this.h) < 0 || (mouseY -= this.i) < 0 || mouseX > this.f || mouseY > this.g) {
            return false;
        }
        if (button == 2) {
            if (this.orientation == ScrollBarOrientation.Vertical) {
                buttonY = this.getLargeDimension() - this.getSmallDimension();
            }
            if (this.orientation == ScrollBarOrientation.Horizontal) {
                buttonX = this.getLargeDimension() - this.getSmallDimension();
            }
        } else if (button == 1) {
            if (this.orientation == ScrollBarOrientation.Vertical) {
                buttonY = this.getSmallDimension() + this.buttonPos;
                buttonHeight = this.scrollButtonSize;
            }
            if (this.orientation == ScrollBarOrientation.Horizontal) {
                buttonX = this.getSmallDimension() + this.buttonPos;
                buttonWidth = this.scrollButtonSize;
            }
        }
        return mouseX >= buttonX && mouseY >= buttonY && mouseX < buttonX + buttonWidth && mouseY < buttonY + buttonHeight;
    }

    protected void b(bao minecraft, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        if (this.mouseDownState > 0) {
            int mouseDownTicks = this.updateCounter - this.mouseDownTime;
            if (this.mouseDownState == 1) {
                int mPos = this.orientation == ScrollBarOrientation.Vertical ? mouseY - this.i : mouseX - this.h;
                this.value = (int)((float)(mPos - this.dragOffset - this.getSmallDimension()) / (float)this.traySize * (float)(this.max - this.min)) + this.min;
            } else if (this.mouseDownState == 2 && mouseDownTicks > 6) {
                this.value += 4;
            } else if (this.mouseDownState == 3 && mouseDownTicks > 6) {
                this.value -= 4;
            }
            this.updateValue();
        }
    }

    public void a(int mouseX, int mouseY) {
        this.mouseDownState = 0;
    }

    public boolean c(bao minecraft, int mouseX, int mouseY) {
        this.actionPerformed = false;
        boolean returnValue = false;
        if (super.c(minecraft, mouseX, mouseY)) {
            mouseX -= this.h;
            mouseY -= this.i;
            if (this.orientation == ScrollBarOrientation.Horizontal) {
                int mouseT = mouseY;
                mouseY = mouseX;
                mouseX = mouseT;
            }
            this.mouseDownTime = this.updateCounter;
            if (mouseY < this.getSmallDimension()) {
                this.mouseDownState = 3;
                this.value -= 4;
                this.actionPerformed = true;
            } else if (mouseY > this.getLargeDimension() - this.getSmallDimension()) {
                this.mouseDownState = 2;
                this.value += 4;
                this.actionPerformed = true;
            } else if (mouseY > this.buttonPos + this.getSmallDimension() && mouseY < this.buttonPos + this.getSmallDimension() + this.scrollButtonSize) {
                this.mouseDownState = 1;
                this.dragOffset = mouseY - this.buttonPos - this.getSmallDimension();
                returnValue = true;
            } else if (mouseY < this.buttonPos + this.getSmallDimension()) {
                this.value -= 40;
                this.actionPerformed = true;
            } else if (mouseY > this.buttonPos + this.getSmallDimension() + this.scrollButtonSize) {
                this.value += 40;
                this.actionPerformed = true;
            }
            this.updateValue();
        }
        return this.actionPerformed || returnValue;
    }

    public static enum ScrollBarOrientation {
        Vertical,
        Horizontal;

    }
}

