/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelpacket.client;

import com.thevoxelbox.voxelpacket.client.VoxelPacketListener;
import com.thevoxelbox.voxelpacket.common.Util;
import com.thevoxelbox.voxelpacket.common.interfaces.IChatHandler;
import com.thevoxelbox.voxelpacket.common.interfaces.IChatPublisher;
import com.thevoxelbox.voxelpacket.common.interfaces.IChatSubscriber;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChatManager
implements IChatHandler,
IChatPublisher {
    private static final Pattern vanillaPlus = Pattern.compile("^(?:\\[[^\\]]*\\]\\s*)*<(?:[^>]*[^>\\w])?(\\w{2,16})(?:\\s*\\([^\\)]*\\))?>+\\s*(.*)");
    private static final Pattern bukkitPlus = Pattern.compile("^(?:(?:\\[[^\\]]*\\]|(?:([^\\w\\s]?)([^\\w\\s])(?:(?!\\2).)+\\2\\1))\\s*)*(\\w{2,16})(?:\\s*\\([^\\)]*\\))?:\\s*(.*)");
    private static final Pattern matchedSymbolsPlus = Pattern.compile("^(?:(?:\\[[^\\]]*\\]|(?:([^\\w\\s]?)([^\\w\\s])(?:(?!\\2).)+\\2\\1))\\s*)*([\\W&&\\S])(\\w{2,16})\\3+(?:\\s*\\([^\\)]*\\))?\\s*(.*)");
    private static final Pattern factionsPlus = Pattern.compile("^([^\\*]?)[\\*]*\\w*\\s*(?:\\1\\[[^\\]]*\\])?[\\s]*(\\w{2,16})(?::|(?:\\s*>))\\s*(.*)");
    private static final Pattern fallbackPattern = Pattern.compile("(?:[^:]*[^:\\w])?(\\w{2,16})(?:\\s*\\([^\\)]*\\))?(?::|(?:\\s*>))\\s*(.*)");
    private static boolean registered = false;
    private bao minecraft;
    private Object subscriberLock = new Object();
    private ArrayList<IChatSubscriber> chatSubscribers = new ArrayList();
    private String lastChatPlayerName;
    private yz lastChatPlayer;

    protected ChatManager(bao minecraft) {
        this.minecraft = minecraft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(IChatSubscriber subscriber) {
        Object object = this.subscriberLock;
        synchronized (object) {
            if (!this.chatSubscribers.contains(subscriber)) {
                this.chatSubscribers.add(subscriber);
            }
            if (!registered) {
                VoxelPacketListener.registerPacketHandler(this);
                registered = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(IChatSubscriber subscriber) {
        Object object = this.subscriberLock;
        synchronized (object) {
            this.chatSubscribers.remove(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleChatPacket(gj packet, String message) {
        boolean cancel = false;
        String chatMessage = this.guessPlayer(message);
        if (this.lastChatPlayerName != null) {
            Object object = this.subscriberLock;
            synchronized (object) {
                for (IChatSubscriber subscriber : this.chatSubscribers) {
                    cancel |= subscriber.receiveChatMessage(message, chatMessage, this.lastChatPlayer, this.lastChatPlayerName);
                }
            }
        }
        return cancel;
    }

    protected String guessPlayer(String message) {
        String cleanMessage = Util.stripColourCodes(message);
        this.lastChatPlayerName = null;
        this.lastChatPlayer = null;
        Matcher matcher = vanillaPlus.matcher(cleanMessage);
        if (matcher.find()) {
            this.lastChatPlayerName = matcher.group(1);
            this.lastChatPlayer = this.findGuessedPlayer(this.lastChatPlayerName);
            return matcher.group(2);
        }
        matcher = bukkitPlus.matcher(cleanMessage);
        if (matcher.find()) {
            this.lastChatPlayerName = matcher.group(3);
            this.lastChatPlayer = this.findGuessedPlayer(this.lastChatPlayerName);
            return matcher.group(4);
        }
        matcher = matchedSymbolsPlus.matcher(cleanMessage);
        if (matcher.find()) {
            this.lastChatPlayerName = matcher.group(4);
            this.lastChatPlayer = this.findGuessedPlayer(this.lastChatPlayerName);
            return matcher.group(5);
        }
        matcher = factionsPlus.matcher(cleanMessage);
        if (matcher.find()) {
            this.lastChatPlayerName = matcher.group(1);
            this.lastChatPlayer = this.findGuessedPlayer(this.lastChatPlayerName);
            return matcher.group(2);
        }
        matcher = fallbackPattern.matcher(cleanMessage);
        if (matcher.find()) {
            this.lastChatPlayerName = matcher.group(1);
            this.lastChatPlayer = this.findGuessedPlayer(this.lastChatPlayerName);
            return matcher.group(2);
        }
        return "";
    }

    protected yz findGuessedPlayer(String guess) {
        if (this.minecraft.f != null && this.minecraft.f.h != null) {
            for (Object entity : this.minecraft.f.h) {
                yz playerEntity = (yz)entity;
                String playerName = playerEntity.b_();
                if (playerName == null || !playerName.equalsIgnoreCase(guess)) continue;
                this.lastChatPlayerName = playerName;
                return playerEntity;
            }
        }
        return null;
    }
}

