/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelpacket.common;

import com.thevoxelbox.voxelpacket.common.Util;
import com.thevoxelbox.voxelpacket.common.data.VoxelPacketCharset;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelPacketHandler;
import com.thevoxelbox.voxelpacket.exceptions.InvalidShortcodeException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class VoxelPacket {
    public static final String VOXELPACKET_CHANNEL = "VOXELPACKET";
    public static final VoxelPacketCharset CHARSET = new VoxelPacketCharset();
    protected static final int HEADER_LENGTH = 18;
    protected static IVoxelPacketHandler clientPacketHandler;
    protected static IVoxelPacketHandler serverPacketHandler;
    protected static int nextMessageId;
    public int packetMessageId;
    public int packetDataType;
    public String packetShortCode;
    public sa relevantEntity;
    public int messageLength;
    public byte[] packetData;
    protected static Object bufferLock;
    protected static ByteBuffer dataBuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoxelPacket(String channel, int length, byte[] data) {
        if (channel.equals(VOXELPACKET_CHANNEL)) {
            try {
                Object object = bufferLock;
                synchronized (object) {
                    dataBuffer.clear();
                    dataBuffer.put(data);
                    dataBuffer.flip();
                    this.packetDataType = dataBuffer.getInt();
                    this.messageLength = dataBuffer.getInt();
                    this.relevantEntity = Util.getEntityWithID(dataBuffer.getInt());
                    byte[] shortCodeBytes = new byte[6];
                    dataBuffer.get(shortCodeBytes);
                    this.packetShortCode = new String(shortCodeBytes, "US-ASCII").trim();
                    this.packetData = new byte[dataBuffer.remaining()];
                    dataBuffer.get(this.packetData);
                }
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void handleServerPacket() {
        clientPacketHandler.handleVoxelPacket(this, null);
    }

    public void handleClientPacket(mw sender) {
        serverPacketHandler.handleVoxelPacket(this, sender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createPayload(int dataType, sa relevantEntity, String shortCode, byte[] payload) throws InvalidShortcodeException {
        int messageId = nextMessageId++;
        if (shortCode.length() > 6 || shortCode.length() < 1) {
            throw new InvalidShortcodeException("Invalid shortcode specified building voxel packet with ID " + messageId);
        }
        int messageLength = payload.length;
        Object object = bufferLock;
        synchronized (object) {
            dataBuffer.clear();
            dataBuffer.putInt(dataType);
            dataBuffer.putInt(messageLength);
            dataBuffer.putInt(relevantEntity != null ? relevantEntity.hashCode() : -1);
            try {
                dataBuffer.put(shortCode.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalArgumentException("VoxelPacket error: Shortcode contains invalid (non-ASCII) characters at ID " + messageId);
            }
            while (dataBuffer.position() < 18) {
                dataBuffer.put((byte)32);
            }
            dataBuffer.put(payload);
            int length = dataBuffer.position();
            dataBuffer.flip();
            byte[] packetData = new byte[length];
            dataBuffer.get(packetData);
            return packetData;
        }
    }

    public static void registerClientPacketHandler(IVoxelPacketHandler handler) {
        clientPacketHandler = handler;
    }

    public static void registerServerPacketHandler(IVoxelPacketHandler handler) {
        serverPacketHandler = handler;
    }

    static {
        nextMessageId = 0;
        bufferLock = new Object();
        dataBuffer = ByteBuffer.allocate(Short.MAX_VALUE);
    }
}

