/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelpacket.common;

import com.thevoxelbox.voxelpacket.common.VoxelMessage;
import com.thevoxelbox.voxelpacket.common.VoxelPacket;
import com.thevoxelbox.voxelpacket.common.encoders.VoxelPacketEncoderCoord3D;
import com.thevoxelbox.voxelpacket.common.encoders.VoxelPacketEncoderEntityNBT;
import com.thevoxelbox.voxelpacket.common.encoders.VoxelPacketEncoderFloat;
import com.thevoxelbox.voxelpacket.common.encoders.VoxelPacketEncoderInt;
import com.thevoxelbox.voxelpacket.common.encoders.VoxelPacketEncoderIntArray;
import com.thevoxelbox.voxelpacket.common.encoders.VoxelPacketEncoderNull;
import com.thevoxelbox.voxelpacket.common.encoders.VoxelPacketEncoderObject;
import com.thevoxelbox.voxelpacket.common.encoders.VoxelPacketEncoderRaw;
import com.thevoxelbox.voxelpacket.common.encoders.VoxelPacketEncoderString;
import com.thevoxelbox.voxelpacket.common.interfaces.IPacketSenderDelegate;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelMessagePublisher;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelMessageSubscriber;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelPacketEncoder;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelPacketHandler;
import com.thevoxelbox.voxelpacket.exceptions.InvalidPacketDataException;
import com.thevoxelbox.voxelpacket.exceptions.InvalidShortcodeException;
import com.thevoxelbox.voxelpacket.exceptions.MessageOverflowException;
import com.thevoxelbox.voxelpacket.exceptions.MissingEncoderException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import sun.reflect.generics.reflectiveObjects.GenericArrayTypeImpl;

public abstract class VoxelPacketHandlerBase
implements IVoxelPacketHandler,
IVoxelMessagePublisher {
    protected static final int ENCODER_NULL = -1;
    protected static final int ENCODER_RAW = 0;
    protected static final int ENCODER_SERIALIZABLE = 1;
    protected static HashMap<Integer, IVoxelPacketEncoder<?>> encoders = new HashMap();
    protected static VoxelPacketEncoderNull nullEncoder = new VoxelPacketEncoderNull(-1);
    protected static VoxelPacketEncoderRaw defaultEncoder = new VoxelPacketEncoderRaw(0);
    protected static VoxelPacketEncoderObject serializableEncoder = new VoxelPacketEncoderObject(1);
    protected Object subscriberLock = new Object();
    protected HashMap<String, ArrayList<IVoxelMessageSubscriber>> subscriberMap = new HashMap();
    protected Object messagesLock = new Object();
    protected HashMap<Integer, VoxelMessage> messages = new HashMap();

    protected VoxelPacketHandlerBase() {
        encoders.clear();
        this.registerEncoder(new VoxelPacketEncoderString(2));
        this.registerEncoder(new VoxelPacketEncoderInt(3));
        this.registerEncoder(new VoxelPacketEncoderFloat(4));
        this.registerEncoder(new VoxelPacketEncoderIntArray(5));
        this.registerEncoder(new VoxelPacketEncoderEntityNBT(6));
        this.registerEncoder(new VoxelPacketEncoderCoord3D(7));
        this.registerEncoder(defaultEncoder);
        this.registerEncoder(serializableEncoder);
    }

    @Override
    public boolean registerEncoder(IVoxelPacketEncoder<?> encoder) {
        Integer dataTypeId = encoder.getDataTypeID();
        if (!encoders.containsKey(dataTypeId)) {
            encoders.put(dataTypeId, encoder);
            return true;
        }
        return false;
    }

    protected void sendMessage(IPacketSenderDelegate packetSender, String shortCode, Object messageData, sa relevantEntity) throws MissingEncoderException, InvalidPacketDataException, InvalidShortcodeException {
        IVoxelPacketEncoder<?> encoder = this.getEncoder(messageData);
        if (encoder == null) {
            throw new MissingEncoderException("Could not find an encoder for payload with type " + messageData.getClass().getName());
        }
        int dataTypeId = encoder.getDataTypeID();
        byte[] payload = encoder.encode(messageData);
        byte[] data = VoxelPacket.createPayload(dataTypeId, relevantEntity, shortCode, payload);
        packetSender.sendPayload("VOXELPACKET", data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ArrayList<IVoxelMessageSubscriber> getSubscribers(String shortCode) {
        Object object = this.subscriberLock;
        synchronized (object) {
            if (!this.subscriberMap.containsKey(shortCode)) {
                this.subscriberMap.put(shortCode, new ArrayList());
            }
            return this.subscriberMap.get(shortCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ArrayList<IVoxelMessageSubscriber> getAllSubscribers(String shortCode) {
        ArrayList<IVoxelMessageSubscriber> currentSubscribers = new ArrayList<IVoxelMessageSubscriber>();
        Object object = this.subscriberLock;
        synchronized (object) {
            currentSubscribers.addAll(this.getSubscribers(shortCode));
            ArrayList<IVoxelMessageSubscriber> globalSubscribers = this.getSubscribers("*");
            for (IVoxelMessageSubscriber globalSubscriber : globalSubscribers) {
                if (currentSubscribers.contains(globalSubscriber)) continue;
                currentSubscribers.add(globalSubscriber);
            }
        }
        return currentSubscribers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void purgeSubscribers() {
        Object object = this.subscriberLock;
        synchronized (object) {
            for (Map.Entry<String, ArrayList<IVoxelMessageSubscriber>> subscriberList : this.subscriberMap.entrySet()) {
                subscriberList.getValue().clear();
            }
            this.subscriberMap.clear();
        }
        this.onPurgeSubscribers();
    }

    protected void onPurgeSubscribers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IVoxelMessagePublisher subscribe(IVoxelMessageSubscriber subscriber, String shortCode) {
        Object object = this.subscriberLock;
        synchronized (object) {
            ArrayList<IVoxelMessageSubscriber> subscribers = this.getSubscribers(shortCode);
            if (!subscribers.contains(subscriber)) {
                subscribers.add(subscriber);
            }
        }
        this.onSubscribe(subscriber, shortCode);
        return this;
    }

    protected void onSubscribe(IVoxelMessageSubscriber subscriber, String shortCode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IVoxelMessagePublisher unsubscribe(IVoxelMessageSubscriber subscriber, String shortCode) {
        Object object = this.subscriberLock;
        synchronized (object) {
            if (this.subscriberMap.containsKey(shortCode)) {
                ArrayList<IVoxelMessageSubscriber> subscribers = this.getSubscribers(shortCode);
                subscribers.remove(subscriber);
            }
        }
        this.onUnsubscribe(subscriber, shortCode);
        return this;
    }

    protected void onUnsubscribe(IVoxelMessageSubscriber subscriber, String shortCode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handleVoxelPacket(VoxelPacket packet, mw sender) {
        if (packet != null) {
            VoxelMessage dispatchMessage = null;
            String messageId = sender != null ? sender.aB().toString() + "[" + packet.packetMessageId + "]" : String.valueOf(packet.packetMessageId);
            Object object = this.messagesLock;
            synchronized (object) {
                VoxelMessage msg = this.messages.get(messageId);
                try {
                    if (msg == null) {
                        msg = new VoxelMessage(this, packet, (yz)sender);
                    }
                    if (msg.isFinalised()) {
                        dispatchMessage = msg;
                        this.messages.remove(messageId);
                    }
                }
                catch (MissingEncoderException ex) {
                    ex.printStackTrace();
                    this.messages.remove(messageId);
                }
                catch (MessageOverflowException ex) {
                    ex.printStackTrace();
                    this.messages.remove(messageId);
                }
            }
            if (dispatchMessage != null) {
                ArrayList<IVoxelMessageSubscriber> currentSubscribers = this.getAllSubscribers(dispatchMessage.getShortCode());
                this.dispatchMessage(currentSubscribers, dispatchMessage);
            }
        }
    }

    protected abstract void dispatchMessage(ArrayList<IVoxelMessageSubscriber> var1, VoxelMessage var2);

    @Override
    public final IVoxelPacketEncoder<?> getEncoder(int dataType) {
        if (dataType < 0) {
            return nullEncoder;
        }
        if (encoders.containsKey(dataType)) {
            return encoders.get(dataType);
        }
        return null;
    }

    @Override
    public final IVoxelPacketEncoder<?> getEncoder(Object dataObject) {
        if (dataObject == null) {
            return nullEncoder;
        }
        for (IVoxelPacketEncoder<?> encoder : encoders.values()) {
            Class<?> encoderClass = this.getGenericSuperClass(encoder);
            if (encoderClass == null || !encoderClass.equals(dataObject.getClass())) continue;
            return encoder;
        }
        for (IVoxelPacketEncoder<?> encoder : encoders.values()) {
            if (!this.getGenericSuperClassName(encoder).equals(dataObject.getClass().getSimpleName())) continue;
            return encoder;
        }
        return serializableEncoder;
    }

    protected final Class<?> getGenericSuperClass(IVoxelPacketEncoder<?> encoder) {
        try {
            Type encoderType = encoder.getClass().getGenericInterfaces()[0];
            if (encoderType instanceof ParameterizedType) {
                ParameterizedType parameterizedEncoderType = (ParameterizedType)encoderType;
                Type encoderTypeType = parameterizedEncoderType.getActualTypeArguments()[0];
                if (encoderTypeType instanceof GenericArrayTypeImpl) {
                    return null;
                }
                return (Class)encoderType;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected final String getGenericSuperClassName(IVoxelPacketEncoder<?> encoder) {
        Type encoderType = encoder.getClass().getGenericInterfaces()[0];
        if (encoderType instanceof ParameterizedType) {
            ParameterizedType parameterizedEncoderType = (ParameterizedType)encoderType;
            Type encoderTypeType = parameterizedEncoderType.getActualTypeArguments()[0];
            if (encoderTypeType instanceof GenericArrayTypeImpl) {
                GenericArrayTypeImpl encoderArrayType = (GenericArrayTypeImpl)encoderTypeType;
                encoderTypeType = encoderArrayType.getGenericComponentType();
                return ((Class)encoderTypeType).getSimpleName() + "[]";
            }
            return ((Class)encoderTypeType).getSimpleName();
        }
        return ((Class)encoderType).getSimpleName();
    }
}

