/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelpacket.common.struct;

import com.thevoxelbox.voxelpacket.common.data.Marshal;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Coord3D
implements Serializable {
    private static final long serialVersionUID = 1331074709877612503L;
    public double X;
    public double Y;
    public double Z;

    private Coord3D() {
    }

    public Coord3D(double x, double y, double z) {
        this.X = x;
        this.Y = y;
        this.Z = z;
    }

    public Coord3D(azw vector) {
        this.X = vector.a;
        this.Y = vector.b;
        this.Z = vector.c;
    }

    public Coord3D(azu position) {
        this.X = position.b;
        this.Y = position.c;
        this.Z = position.d;
    }

    public Coord3D(ByteBuffer dataBuffer) {
        try {
            this.X = Double.longBitsToDouble(dataBuffer.getLong());
            this.Y = Double.longBitsToDouble(dataBuffer.getLong());
            this.Z = Double.longBitsToDouble(dataBuffer.getLong());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] getBytes() {
        try {
            long x = Double.doubleToLongBits(this.X);
            long y = Double.doubleToLongBits(this.Y);
            long z = Double.doubleToLongBits(this.Z);
            byte[] xBytes = Marshal.unpackByte(x);
            byte[] yBytes = Marshal.unpackByte(y);
            byte[] zBytes = Marshal.unpackByte(z);
            byte[] result = new byte[]{xBytes[0], xBytes[1], xBytes[2], xBytes[3], xBytes[4], xBytes[5], xBytes[6], xBytes[7], yBytes[0], yBytes[1], yBytes[2], yBytes[3], yBytes[4], yBytes[5], yBytes[6], yBytes[7], zBytes[0], zBytes[1], zBytes[2], zBytes[3], zBytes[4], zBytes[5], zBytes[6], zBytes[7]};
            return result;
        }
        catch (Exception ex) {
            return new byte[0];
        }
    }
}

